<?php
/**
* @version 1.0.0
* @author Daniel Ecer
* @package bot_exmenu_source_sql_query_1.0.0
* @copyright (C) 2005-2006 Daniel Ecer (de.siteof.de)
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

$_MAMBOTS->registerFunction('onLoadMenu', 'botExtendedMenuSourceSqlQuery_onLoadMenu');

	
function botExtendedMenuSourceSqlQuery_getRawUrlParameter($url, $paramName) {
	$i	= strpos($url, '&'.$paramName.'=');
	$j	= strpos($url, '?'.$paramName.'=');
	if (($j !== FALSE) && ($j < $i)) {
		$i	= $j;
	}
	if ($i !== FALSE) {
		$i	+= 2 + strlen($paramName);
		$j	= strpos($url, '&', $i);
		if ($j !== FALSE) {
			return substr($url, $i, $j - $i);
		} else {
			return substr($url, $i);
		}
	}
	return FALSE;
}

function botExtendedMenuSourceSqlQuery_onLoadMenu(&$menuLoader, $name = '') {
	global $database, $mosConfig_live_site, $option, $Itemid;
	global $mosConfig_lang, $mosConfig_mbf_content;

	$botName		= 'bot_exmenu_source_sql_query';
	// load parameters
	$database->setQuery('SELECT m.params FROM #__mambots AS m WHERE element = \''.$botName.'\' AND folder = \'exmenu\'');
	$rows	= $database->loadObjectList();
	foreach(array_keys($rows) as $key) {
		$row		=& $rows[$key];
		$params	= new mosParameters($row->params);
		$params->def('source_name', 'sql_query');

		if ($name != $params->get('source_name')) {
			continue;	// this is not the intended plugin instance, skip to the next
		}

		$fieldname_caption		= trim($params->get('fieldname_caption', 'caption'));
		$fieldname_url			= trim($params->get('fieldname_url', 'url'));
		$fieldname_type			= trim($params->get('fieldname_type', 'type'));
		$fieldname_id			= trim($params->get('fieldname_id', 'id'));
		$fieldname_parent_id		= trim($params->get('fieldname_parent_id', 'parent_id'));
		$fieldname_itemid		= trim($params->get('fieldname_itemid', ''));
		$query					= $params->get('query', "SELECT\n
  name AS caption,\n
  link AS url,\n
  type,\n
  id,\n
  parent AS parent_id\n
FROM #__menu1\n
WHERE menutype = 'mainmenu'\n
  AND published = 1");
		$removeBr				= $params->get('remove_br', 1);

		$mamblefish_enabled		= $params->get('mamblefish_enabled', 0);
		$mamblefish_entity_name	= $params->get('mamblefish_entity_name', 'menu');

		if ($removeBr) {
			$query					= str_replace("\r<br />", "\n", $query);
		}
	
		$rootMenuNode	=& $menuLoader->getRootMenuNode();
		$database->setQuery($query);
		$rows	= $database->loadObjectList();
		if ($database->getErrorNum()) {
			trigger_error('database error:'.stripslashes($database->getErrorMsg()), E_USER_WARNING);
			return FALSE;
		}
		$menuNodeById			= array();
		$childMenuNodeListById	= array();
		$itemidMenuNode			= NULL;
		$linkMenuNode			= NULL;
		$componentMenuNode		= NULL;
		$currentUrl				= (isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '');
		if ($currentUrl != '') {
			if ((substr($currentUrl, 0, 1) != '/') && (strpos($currentUrl, ':') === FALSE)) {
				$currentUrl		= '/'.$currentUrl;
			}
			$i		= strpos($currentUrl, '&Itemid=');
			if ($i === FALSE) {
				$i		= strpos($currentUrl, '?Itemid=');
			}
			$currentUrlArray			= array();
			if (substr($currentUrl, 0, 1) == '/') {
				$currentUrlArray[]		= substr($currentUrl, 1);
				$currentUrlArray[]		= $mosConfig_live_site.$currentUrl;
			} else {
				$currentUrlArray[]		= $currentUrl;
			}
			if ($i !== FALSE) {
				if (substr($currentUrl, 0, 1) == '/') {
					$currentUrlArray[]		= substr(substr($currentUrl, 0, $i), 1);
					$currentUrlArray[]		= $mosConfig_live_site.substr($currentUrl, 0, $i);
				} else {
					$currentUrlArray[]		= substr($currentUrl, 0, $i);
				}
			}
		}
		if (($mamblefish_enabled) && ($mosConfig_mbf_content)) {
			foreach(array_keys($rows) as $key) {
				$translatedObject	= MambelFish::translate($rows[$key], $mamblefish_entity_name, $mosConfig_lang);
				$rows[$key]			=& $translatedObject;
			}
		}
		foreach(array_keys($rows) as $key) {
			$row					=& $rows[$key];
			$menuNode			=& $menuLoader->getEmptyMenuNode();
			$menuNode->name		= $row->$fieldname_caption;
			$menuNode->link		= (($fieldname_url != '') && (isset($row->$fieldname_url)) ? $row->$fieldname_url : '');
			$menuNode->type		= (($fieldname_type != '') && (isset($row->$fieldname_type)) ? $row->$fieldname_type : '');
			if ($menuNode->type == '') {
				$menuNode->type		= ($menuNode->link != '' ? 'url' : 'separator');
			}
			$menuNode->id		= (($fieldname_itemid != '') && (isset($row->$fieldname_itemid)) ? $row->$fieldname_itemid : '');
			$id					= (($fieldname_id != '') && (isset($row->$fieldname_id)) ? $row->$fieldname_id : '');
			if ($id > 0) {
				$menuNodeById[$id]		=& $menuNode;
			}
			$parentId			= (($fieldname_parent_id != '') && (isset($row->$fieldname_parent_id)) ? $row->$fieldname_parent_id : '');
			if ($parentId <= 0) {
				$parentId	= 0;
			}
			if (!isset($childMenuNodeListById[$parentId])) {
				$childMenuNodeListById[$parentId]		= array();
			}
			$childMenuNodeListById[$parentId][]		=& $menuNode;
			if (($Itemid > 0) && ($Itemid == $menuNode->id)) {
				$itemidMenuNode		=& $menuNode;
			}
			if (($menuNode->link != '') && (in_array($menuNode->link, $currentUrlArray))) {
				$linkMenuNode		=& $menuNode;
			} else if ($option == botExtendedMenuSourceSqlQuery_getRawUrlParameter($menuNode->link, 'option')) {
				$componentMenuNode	=& $menuNode;
			}
		}
		$currentMenuNode		= NULL;
		if (!is_null($linkMenuNode)) {
			$currentMenuNode		=& $linkMenuNode;
		} else if (!is_null($itemidMenuNode)) {
			$currentMenuNode		=& $itemidMenuNode;
		} else if (!is_null($componentMenuNode)) {
			$currentMenuNode		=& $componentMenuNode;
		}
		if (!is_null($currentMenuNode)) {
			$currentMenuNode->setCurrent(TRUE);
			$menuNode	=& $currentMenuNode->getParent();
			while(!is_null($menuNode)) {
				$menuNode->setActive(TRUE);
				$t			=& $menuNode->getParent();
				$menuNode	=& $t;
			}
		}
		$menuNodeById[0]		=& $rootMenuNode;
		foreach(array_keys($childMenuNodeListById) as $id) {
			if (!isset($menuNodeById[$id])) {
				trigger_error('exmenu: parent with id '.$id.' not found', E_USER_NOTICE);
				continue;
			}
			$menuNode			=& $menuNodeById[$id];
			$menuNodeList		=& $childMenuNodeListById[$id];
			foreach(array_keys($menuNodeList) as $key) {
				$childMenuNode		=& $menuNodeList[$key];
				$menuNode->setExpanded(TRUE);
				$menuLoader->addMenuNode($menuNode, $childMenuNode);
			}
		}
		return TRUE;
	}
	return FALSE;
}

?>