<?php
/**
* @version 1.0.0
* @author Daniel Ecer
* @package bot_exmenu_view_sample_1.0.0
* @copyright (C) 2005 Daniel Ecer (de.siteof.de)
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

$_MAMBOTS->registerFunction('onShowMenu', 'botExtendedMenuViewSample_onShowMenu');

function botExtendedMenuViewSample_onShowMenu(&$menuView, $name = '') {
	global $database;

	$botName		= 'bot_exmenu_view_sample';
	// load parameters
	$database->setQuery('SELECT m.params FROM #__mambots AS m WHERE element = \''.$botName.'\' AND folder = \'exmenu\'');
	$params	= new mosParameters($database->loadResult());
	$params->def('source_name', 'sample');
	
	if ($name != $params->get('source_name')) {
		return FALSE;
	}

	$menuNodeList	=& $menuView->getMenuNodeList();
	$result	= botExtendedMenuViewSample_showMenuNodeList($menuView, $menuNodeList);
	return $result;
}


function botExtendedMenuViewSample_showMenuNodeList(&$menuView, &$menuNodeList) {
	$result		= '<ul>';
	foreach(array_keys($menuNodeList) as $key) {
		$menuNode			=& $menuNodeList[$key];
		$result		.= '<li>';
		$result		.= '(-'.$menuView->getMenuLink($menuNode).'-)';
		if ($menuNode->hasChildren()) {
			$children	=& $menuNode->getChildNodeList();
			$result		.= botExtendedMenuViewSample_showMenuNodeList($menuView, $children);
		}
		$result		.= '</li>';
	}
	$result	.= '</ul>';
	return $result;
}

?>