<?php
/**
 * Moslate admin interface classes.
 *
 * @package moslate
 * @version $Id: admin.moslate.class.php 208 2006-09-19 22:48:33Z  $
 * @copyright (C) 2004-2006 Daniel Ecer (de.siteof.de)
 * @license GNU/GPL
 */

global $mosConfig_absolute_path, $mosConfig_live_site;
global $administratorAbsolutePath, $administratorLiveSite;

$administratorAbsolutePath	= $mosConfig_absolute_path.'/administrator';
$administratorLiveSite		= $mosConfig_live_site.'/administrator';

if (!class_exists('mosInstaller')) {
	require_once $administratorAbsolutePath.'/components/com_installer/installer.class.php';
}
if (!class_exists('DOMIT_Lite_Document')) {
	require_once $mosConfig_absolute_path.'/includes/domit/xml_domit_lite_include.php';
}

if (!class_exists('mosMoslateLogger')) {
	require_once($mosConfig_absolute_path.'/components/com_moslate/moslate.logger.class.php');
}


DEFINE('MOSLATE_STATUS_NOT_INSTALLED',	1);
DEFINE('MOSLATE_STATUS_NOT_PUBLISHED',	2);
DEFINE('MOSLATE_STATUS_PUBLISHED',		3);


class mosInstallerMoslate extends mosInstaller {

	var $rootNodeName	= 'mosdata';

	function doChmod($fileName) {
		if (function_exists('mosChmod')) {
			return mosChmod($fileName);
		} else {
			return chmod($fileName, 0777 );
		}
	}

	/**
	 * (copied from /administrator/components/com_installer/admin.installer.php)
	 *
	 * @param string The name of the php (temporary) uploaded file
	 * @param string The name of the file to put in the temp directory
	 * @param string The message to return
	 */
	function uploadFile( $filename, $userfile_name, &$msg ) {
		global $mosConfig_absolute_path;
		$baseDir = mosPathName( $mosConfig_absolute_path . '/media' );

		if (file_exists( $baseDir )) {
			if (is_writable( $baseDir )) {
				if (move_uploaded_file( $filename, $baseDir . $userfile_name )) {
				    if ($this->doChmod($baseDir.$userfile_name)) {
				        return true;
					} else {
						$msg = 'Failed to change the permissions of the uploaded file.';
					}
				} else {
					$msg = 'Failed to move uploaded file to <code>/media</code> directory.';
				}
			} else {
			    $msg = 'Upload failed as <code>/media</code> directory is not writable.';
			}
		} else {
		    $msg = 'Upload failed as <code>/media</code> directory does not exist.';
		}
		$this->setError(1, $msg);
		return false;
	}

	/**
	* @param string A file path
	* @return object A DOMIT XML document, or null if the file failed to parse
	*/
	function isPackageFile( $p_file ) {
		$xmlDoc =& new DOMIT_Lite_Document();
		$xmlDoc->resolveErrors( true );

		if (!$xmlDoc->loadXML( $p_file, false, true )) {
			return null;
		}
		$element = &$xmlDoc->documentElement;

		if ($element->getTagName() != $this->rootNodeName) {
			return null;
		}
		// Set the type
		$this->elementType( $element->getAttribute( 'type' ) );
		$this->installFilename( $p_file );
		return $xmlDoc;
	}

	function elementType( $elementType = null ) {
		return $this->setVar( 'elementType', $elementType );
	}

}

class mosMoslateStatusManager {

	function getStatusText($status) {
		$lang			= mosMoslateLang::getInstance();
		$variableMap	= array('code' => $status);
		$text			= '';
		switch($status) {
			case MOSLATE_STATUS_NOT_INSTALLED:
				$text	= 'NOT_INSTALLED';
				break;
			case MOSLATE_STATUS_NOT_PUBLISHED:
				$text	= 'NOT_PUBLISHED';
				break;
			case MOSLATE_STATUS_PUBLISHED:
				$text	= 'PUBLISHED';
				break;
			default:
				$text	= 'STATUS_'.$status;
		}
		$text	= $lang->getLangText('_MOSLATE_STATUS_'.$text, $text, $variableMap);
		return $text;
	}

	function getMambotStatus($mambotName) {
		global $database;
		$database->setQuery('SELECT published FROM #__mambots WHERE element=\''.$mambotName.'\'');
		$result	= $database->loadRowList();
		if (($result == null) || (count($result) < 1)) {
			return MOSLATE_STATUS_NOT_INSTALLED;
		}
		$published	= FALSE;
		foreach($result as $row) {
			if (intval($row[0]) == 1) {
				$published	= TRUE;
			}
		}
		return ($published ? MOSLATE_STATUS_PUBLISHED : MOSLATE_STATUS_NOT_PUBLISHED);
	}

	function publishMambot($mambotName) {
		global $database;
		$database->setQuery('UPDATE #__mambots SET published = 1 WHERE element=\''.$mambotName.'\'');
		$result	= $database->query();
		$result	= ($this->getMambotStatus($mambotName) == MOSLATE_STATUS_PUBLISHED);
		return $result;
	}

	function getMoslateMambotStatus() {
		return $this->getMambotStatus('moslate_mambot');
	}

	function getLegacyMambotStatus() {
		return $this->getMambotStatus('legacybots');
	}

	function publishMoslateMambot() {
		return $this->publishMambot('moslate_mambot');
	}

	function publishLegacyMambot() {
		return $this->publishMambot('legacybots');
	}

	function getLegacyMoslateMambotStatus() {
		global $mosConfig_absolute_path;
		if (file_exists($mosConfig_absolute_path.'/mambots/moslate_mambot.php')) {
			return MOSLATE_STATUS_NOT_PUBLISHED;
		}
		return MOSLATE_STATUS_NOT_INSTALLED;
	}
}

class mosMoslateAdminManager {

	var	$moslateMambotStatus;
	var	$legacyMambotStatus;
	var	$legacyMoslateMambotStatus;

	function &getMambotStatusLogEntries() {
		$lang			= mosMoslateLang::getInstance();
		$config			= mosMoslateConfig::getInstance();

		$status	= new mosMoslateStatusManager();
		$moslateMambotStatus		= $status->getMoslateMambotStatus();
		$legacyMambotStatus			= $status->getLegacyMambotStatus();
		$legacyMoslateMambotStatus	= $status->getLegacyMoslateMambotStatus();
		if (($legacyMoslateMambotStatus == MOSLATE_STATUS_NOT_PUBLISHED) && ($legacyMambotStatus == MOSLATE_STATUS_PUBLISHED)) {
			$legacyMoslateMambotStatus	= MOSLATE_STATUS_PUBLISHED;
		}

		$variableMap		= array();

		$mambotLogEntries	= array();
		$variableMap['status']	= $status->getStatusText($moslateMambotStatus);
		if ($moslateMambotStatus == MOSLATE_STATUS_PUBLISHED) {
			$prefix	= '<b>';
			$suffix	= '</b>';
		} else {
			$prefix	= '';
			$suffix	= '';
		}
		$mambotLogEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_INFO,
				$prefix.$lang->getInfoTextAsHtml('STATUS_MOSLATE_MAMBOT', 'Moslate Mambot is ${status}.', $variableMap).$suffix);

		$variableMap['status']	= $status->getStatusText($legacyMoslateMambotStatus);
		if ($legacyMoslateMambotStatus == MOSLATE_STATUS_PUBLISHED) {
			$prefix	= '<b>';
			$suffix	= '</b>';
		} else {
			$prefix	= '';
			$suffix	= '';
		}
		$mambotLogEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_INFO,
				$prefix.$lang->getInfoTextAsHtml('STATUS_LEGACY_MAMBOT', 'Legacy Moslate Mambot (using Legacy Mambot Includer) is ${status}.', $variableMap).$suffix);
		unset($variableMap['status']);

		if (($moslateMambotStatus != MOSLATE_STATUS_PUBLISHED) && ($legacyMoslateMambotStatus != MOSLATE_STATUS_PUBLISHED)) {
			$mambotLogEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_WARNING,
					$lang->getErrorTextAsHtml('NO_MAMBOT_PUBLISHED', 'Please install and publish either the Moslate Mambot or the Legacy Moslate Mambot.', $variableMap));
		}
		if (($moslateMambotStatus == MOSLATE_STATUS_PUBLISHED) && ($legacyMoslateMambotStatus == MOSLATE_STATUS_PUBLISHED)) {
			$mambotLogEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_WARNING,
					$lang->getErrorTextAsHtml('MORE_THAN_ONE_MAMBOTS_PUBLISHED', 'Please publish one of the Mambots only.', $variableMap));
		}
		if ($config->get('enabled', '1') != '1') {
			$mambotLogEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_WARNING,
					$lang->getErrorTextAsHtml('MOSLATE_DISABLED', 'Moslate component is currently disabled.', $variableMap));
		}
		return $mambotLogEntries;
	}

	function getAccessLevelTextById($accessLevelId) {
		global $database;
		$query = 'SELECT name FROM #__groups WHERE id='.intval($accessLevelId);
		$database->setQuery($query);
		return $database->loadResult();
	}

	function &getMoslateStatusLogEntries(&$moslate) {
		$lang			= mosMoslateLang::getInstance();
		$config			= mosMoslateConfig::getInstance();

		$variableMap		= array();
		$logEntries			= array();

		if ($moslate->id > 0) {
			$name		= trim($moslate->name);
			$paramsObj	=& new mosParameters($moslate->params);
			$mosTag		= trim($config->get('mos_tag', 'moslate'));
			$tagType	= intval(trim($config->get('tag_type', '1')));
			$dataVar	= trim($paramsObj->get('data_var', ''));
			$mode		= intval($paramsObj->get('mode', 1));
			$activation	= intval($paramsObj->get('activation', 10));
			$published	= intval($moslate->published) == 1;
			$code		= '';
			$indent		= '';
			$tagBegin	= array();
			$tagEnd		= array();
			if ($tagType == 0) {
				$tagType	= 3;
			}
			if (($tagType & 1) != 0) {
					$tagBegin[]	= '<';
					$tagEnd[]	= '>';
			}
			if (($tagType & 2) != 0) {
					$tagBegin[]	= '{';
					$tagEnd[]	= '}';
			}
			if (($tagType & 4) != 0) {
					$tagBegin[]	= '[';
					$tagEnd[]	= ']';
			}
			if ($mosTag != '') {
				$code		.= '{'.$mosTag.'}<br />';
				$indent		= '&nbsp;&nbsp;';
			}
			// parse the template arguments
			$templateArgs	= array();
			$a				= (is_array($moslate->args) ? $moslate->args : explode("\n", $moslate->args));
			foreach($a as $v) {
				$a2				= explode('|', $v);
				if (count($a2) >= 1) {
					$argName	= trim(rawurldecode($a2[0]));
					if ($argName != '') {
						$templateArgs[$argName] = (count($a2) >= 2 ? rawurldecode($a2[1]) : '');
					}
				}
			}
			if (count($templateArgs) == 0) {
				$templateArgs['param']	= 'value';
			}
			for($tagTypeIndex = 0; $tagTypeIndex < count($tagBegin); $tagTypeIndex++) {
				$tagBeginThis	= htmlentities($tagBegin[$tagTypeIndex]);
				$tagEndThis		= htmlentities($tagEnd[$tagTypeIndex]);
				$code		.= $indent.$tagBeginThis.'<b>'.htmlentities($name).'</b>';
				foreach($templateArgs as $k => $v) {
					$code		.= ' '.htmlentities($k).'=&quot;'.htmlentities($v).'&quot;';
				}
				if ($dataVar != '') {
					$code		.= $tagEndThis.'&nbsp;...&nbsp;'.$tagBeginThis.'/'.'<b>'.$name.'</b>';
				} else {
					$code		.= ' /';
				}
				$code		.= $tagEndThis.'<br />';
			}
			if ($mosTag != '') {
				$code		.= '{/'.$mosTag.'}';
				$indent		= '';
			}
			if ($activation == 10) {
				$variableMap['code']	= $code;
				$text	= $lang->getInfoTextAsHtml('MOSLATE_SAMPLE_CONTENT', 'Moslate may be called inside content item', $variableMap);
				$text	.= ':<br /><div class="moslate-code">'.$code.'</div>';
				if ($name != '') {
					$logEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_INFO,	$text);
				} else {
					$logEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_WARNING,
							$lang->getErrorTextAsHtml('MOSLATE_NAME_EMPTY', 'Name is empty.', $variableMap));
				}
			} else {
				$activationText				= mosMoslateLang::getLangTextAsHtml('_MOSLATE_FIELD_ACTIVATION_'.$activation, $activation, $variableMap);
				$variableMap['activation']	= '<b>'.$activationText.'</b>';
				$logEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_INFO,
					$lang->getInfoTextAsHtml('MOSLATE_ACTIVATION', 'Activation is set to: ${activation}.', $variableMap));
			}
			$variableMap['access']	= $this->getAccessLevelTextById($moslate->access);
			$logEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_INFO,
				$lang->getInfoTextAsHtml('MOSLATE_ACCESS', 'Access level is set to: ${access}.', $variableMap));
			if (!$published) {
				$logEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_WARNING,
						$lang->getErrorTextAsHtml('MOSLATE_NOT_PUBLISHED', 'Moslate is currently not published.', $variableMap));
			}
		} else {
			$logEntries[]	= new mosMoslateLogEntry(MOSLATE_LOGLEVEL_INFO,
				$lang->getInfoTextAsHtml('MOSLATE_NEW', 'New Moslate.', $variableMap));
		}
		return $logEntries;
	}

}

?>