<?php
/**
 * Moslate admin interface output class.
 *
 * @package moslate
 * @version $Id: admin.moslate.html.php 208 2006-09-19 22:48:33Z  $
 * @copyright (C) 2004-2006 Daniel Ecer (de.siteof.de)
 * @license GNU/GPL
 */

/** Ensure this file is being included by a parent file */
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

error_reporting(E_ALL);

/*
 * Some legacy functions for campatibility with Mambo 4.5.1
 */
class mosCommonHTMLLegacy {

	function loadOverlib() {
		global  $mosConfig_live_site;
		if (is_callable(array('mosCommonHTML', 'loadOverlib'))) {
			mosCommonHTML::loadOverlib();
		} else {
			?>
			<script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
			<?php
		}
	}

	function checkedOut( &$row, $overlib=1 ) {
		if (is_callable(array('mosCommonHTML', 'checkedOut'))) {
			return mosCommonHTML::checkedOut($row, $overlib);
		} else {
			$hover = '';
			if ( $overlib ) {
				$date 				= mosFormatDate( $row->checked_out_time, '%A, %d %B %Y' );
				$time				= mosFormatDate( $row->checked_out_time, '%H:%M' );
				$checked_out_text 	= '<table>';
				$checked_out_text 	.= '<tr><td>'. $row->editor .'</td></tr>';
				$checked_out_text 	.= '<tr><td>'. $date .'</td></tr>';
				$checked_out_text 	.= '<tr><td>'. $time .'</td></tr>';
				$checked_out_text 	.= '</table>';
				$hover = 'onMouseOver="return overlib(\''. $checked_out_text .'\', CAPTION, \'Checked Out\', BELOW, RIGHT);" onMouseOut="return nd();"';
			}
			$checked	 		= '<img src="images/disabled.png" '. $hover .'/>';

			return $checked;
		}
	}

	function CheckedOutProcessing( &$row, $i ) {
		global $my;
		if (is_callable(array('mosCommonHTML', 'CheckedOutProcessing'))) {
			return mosCommonHTML::CheckedOutProcessing($row, $i);
		} else {
			if ( $row->checked_out ) {
				$checked = mosCommonHTMLLegacy::checkedOut( $row );
			} else {
				$checked = mosHTML::idBox( $i, $row->id, ($row->checked_out && $row->checked_out != $my->id ) );
			}
			return $checked;
		}
	}
}

/**
*
*/
class HTML_moslate {

	function showMoslateLinks() {
		global $administratorLiveSite;

		$lang				= mosMoslateLang::getInstance();
		$variableMap		= null;

		echo '<div class="moslate-links">';
		$menuMap	= $lang->getMoslateMenuMap();
		$first		= TRUE;
		foreach($menuMap as $k => $v) {
			$label	= $lang->getLangText('_MOSLATE_MENU_'.$v, $v, $variableMap);
			if ($first) {
				echo '<span class="moslate-links-header">'.$label.'</span><ul align="left">';
				$first	= FALSE;
			} else {
				echo '<li><a href="'.$administratorLiveSite.'/index2.php?'.$k.'">'.$label.'</a></li>';
			}
		}
		if (!$first) {
			echo '</ul>';
		}
		echo '</div>';
	}

	function showMoslates(&$rows, &$pageNav, $search, $option, &$lists) {
		global $my;
		$variableMap	= array();

		mosCommonHTMLLegacy::loadOverlib();
		?>
		<form action="index2.php" method="post" name="adminForm">
		<table class="adminheading">
		<tr>
			<th>
				<?php echo mosMoslateLang::getTitleTextAsHtml('MANAGER', 'Moslate Manager', $variableMap); ?>
			</th>
			<td>
				<?php echo mosMoslateLang::getFieldTextAsHtml('FILTER', 'Filter', $variableMap); ?>:
			</td>
			<td>
				<input type="text" name="search" value="<?php echo $search; ?>" class="inputbox" onChange="document.adminForm.submit();" />
			</td>
			<td width="right">
				<?php echo $lists['catid'];?>
			</td>
		</tr>
		</table>

		<table class="adminlist">
		<tr>
			<th width="20" nowrap="nowrap">
				<?php echo mosMoslateLang::getColumnTextAsHtml('NO', '#', $variableMap); ?>
			</th>
			<th width="20" class="title" nowrap="true">
				<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($rows); ?>);" />
			</th>
			<th width="30%" class="title" nowrap="true">
				<?php echo mosMoslateLang::getColumnTextAsHtml('NAME', 'Name', $variableMap); ?>
			</th>
			<th width="50" class="title" nowrap="true">
				<?php echo mosMoslateLang::getColumnTextAsHtml('PUBLISHED', 'Published', $variableMap); ?>
			</th>
			<th colspan="2" nowrap="nowrap" align="center" width="5%">
				<?php echo mosMoslateLang::getColumnTextAsHtml('REORDER', 'Reorder', $variableMap); ?>
			</th>
			<th width="2%">
				<?php echo mosMoslateLang::getColumnTextAsHtml('ORDER', 'Order', $variableMap); ?>
			</th>
			<th width="1%">
				<a href="javascript:saveorder(<?php echo count( $rows )-1; ?>)"><img src="images/filesave.png" border="0" width="16" height="16" alt="<?php echo $hint = mosMoslateLang::getHintTextAsHtml('SAVE_ORDER', 'Save Order', $variableMap); ?>" title="<?php echo $hint; ?>"/></a>
			</th>
			<th width="10%">
				<?php echo mosMoslateLang::getColumnTextAsHtml('ACCESS', 'Access', $variableMap); ?>
			</th>
			<th width="2%">
				<?php echo mosMoslateLang::getColumnTextAsHtml('ID', 'ID', $variableMap); ?>
			</th>
			<th width="10%">
				<?php echo mosMoslateLang::getColumnTextAsHtml('ACTIVATION', 'Activation', $variableMap); ?>
			</th>
			<th nowrap="true" width="20%" align="center">
				<?php echo mosMoslateLang::getColumnTextAsHtml('CATEGORY', 'Category', $variableMap); ?>
			</th>
			<th class="title" nowrap="true" width="20%">
				<?php echo mosMoslateLang::getColumnTextAsHtml('LINKED_TO_USER', 'Link to User', $variableMap); ?>
			</th>
		</tr>
		<?php
		$k = 0;
		for ($i=0, $n=count($rows); $i < $n; $i++) {
			$row = $rows[$i];

			$link 		= 'index2.php?option='.$option.'&task=edit&hidemainmenu=1&id='.$row->id;
			$cat_link 	= 'index2.php?option=com_categories&task=editA&hidemainmenu=1&section='.$option.'&id='. $row->catid;

			$params = new mosParameters($row->params);
			$img = $row->published ? 'tick.png' : 'publish_x.png';
			$task = $row->published ? 'unpublish' : 'publish';
			$alt = $row->published ? 'Published' : 'Unpublished';
			if ( !$row->access ) {
				$color_access = 'style="color: green;"';
				$task_access = 'accessregistered';
			} else if ( $row->access == 1 ) {
				$color_access = 'style="color: red;"';
				$task_access = 'accessspecial';
			} else {
				$color_access = 'style="color: black;"';
				$task_access = 'accesspublic';
			}
			$activation = $params->get('activation', 10);
//			switch($activation) {
//				case 10:
//					$activation	= mosMoslateLang::getLangTextAsHtml('_MOSLATE_FIELD_ACTIVATION_10', 'Normal', $variableMap);
//					break;
//				case 20:
//					$activation	= mosMoslateLang::getLangTextAsHtml('_MOSLATE_FIELD_ACTIVATION_20', 'Mos-Tag', $variableMap);
//					break;
//				case 30:
//					$activation	= mosMoslateLang::getLangTextAsHtml('_MOSLATE_FIELD_ACTIVATION_30', 'Content', $variableMap);
//					break;
//			}
			$activation	= mosMoslateLang::getLangTextAsHtml('_MOSLATE_FIELD_ACTIVATION_'.$activation, $activation, $variableMap);
			//$link = 'index2.php?option=com_content&sectionid='. $redirect .'&task=edit&id='. $row->id;
			$checked 	= mosCommonHTMLLegacy::CheckedOutProcessing( $row, $i );
			?>
			<tr class="<?php echo 'row'.$k; ?>">
				<td width="20">
					<?php echo $pageNav->rowNumber( $i ); ?>
				</td>
				<td width="20" align="center">
					<?php echo $checked; ?>
				</td>
				<td width="20%">
				<?php
				if ( $row->checked_out && ( $row->checked_out != $my->id ) ) {
					?>
					<?php echo $row->name; ?>
					&nbsp;[ <i>Checked Out</i> ]
					<?php
				} else {
					?>
					<a href="<?php echo $link?>" title="<?php echo mosMoslateLang::getHintTextAsHtml('EDIT_MOSLATE', 'Edit Moslate', $variableMap); ?>">
					<?php echo $row->name; ?>
					</a>
					<?php
				}
				?>
				</td>
				<td width="10%" align="center">
					<a href="javascript: void(0);" onClick="return listItemTask('cb<?php echo $i;?>','<?php echo $task;?>')">
					<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />
					</a>
				</td>
				<td>
					<?php echo $pageNav->orderUpIcon( $i ); ?>
				</td>
				<td>
					<?php echo $pageNav->orderDownIcon( $i, $n ); ?>
				</td>
				<td align="center" colspan="2">
					<input type="text" name="order[]" size="5" value="<?php echo $row->ordering; ?>" class="text_area" style="text-align: center" />
				</td>
				<td align="center">
					<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $task_access;?>')" <?php echo $color_access; ?>>
					<?php echo $row->groupname;?>
					</a>
				</td>
				<td align="left">
					<?php echo $row->id; ?>
				</td>
				<td align="center">
					<?php echo $activation; ?>
				</td>
				<td align="center">
					<a href="<?php echo $cat_link; ?>" title="<?php echo mosMoslateLang::getHintTextAsHtml('EDIT_CATEGORY', 'Edit Category', $variableMap); ?>">
					<?php echo $row->category; ?>
					</a>
				</td>
				<td>
					<?php echo $row->user; ?>
				</td>
			</tr>
			<?php
			$k = 1 - $k;
		}
		?>
		</table>
		<?php echo $pageNav->getListFooter(); ?>

		<input type="hidden" name="option" value="<?php echo $option; ?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		</form>
		<?php
	} // function showMoslates

	function editMoslate( &$row, &$lists, $option, &$includes, &$params ) {
		global $mosConfig_live_site;

		$logger				= new mosMoslateLoggerHtml();
		$variableMap		= array();

		mosMakeHtmlSafe($row);

		mosMoslateLang::translateParameters($params);

		if ($row->image == '') {
			$row->image = 'blank.png';
		}

		$tabs = new mosTabs(0);

		$mambotLogEntries	= $lists['mambot_log_entries'];
		$moslateLogEntries	= $lists['moslate_log_entries'];

		//mosMakeHtmlSafe( $row, ENT_QUOTES, 'template' );
		?>
		<script language="javascript" type="text/javascript">

		var folderincludes = new Array;
		<?php
		$i = 0;
		foreach ($includes as $k=>$items) {
			foreach ($items as $v) {
				echo "folderincludes[".$i++."] = new Array( '$k','".addslashes( $v->value )."','".addslashes( $v->text )."' );\n\t\t";
			}
		}
		?>

		// not used/tested currenty
		function addcslashes(s, chars) {
			if (chars.indexOf('\\') == -1) {
				s = s.replace(/\\/g, '\\\\');
			}
			for (var i = 0; i < chars.length; i++) {
				s	= s.replace(chars[i], '\\'+chars[i]);
			}
			return s;
		}

		/**
		* Adds a new item to a list
		*/
		function addNewToList( frmName, tgtListName, namePrefix ) {
			var form = eval( 'document.' + frmName );
			var tgtList = eval( 'form.' + tgtListName );

			var tgtLen = tgtList.length;
			var tgt = "x";

			//build array of target items
			for (var i=tgtLen-1; i > -1; i--) {
				tgt += "," + tgtList.options[i].value + ","
			}

			//Pull selected resources and add them to list
			for (var i=1; i < 1000; i++) {
				var name = namePrefix + i;
				if (tgt.indexOf( "," + name + "," ) == -1) {
					opt = new Option( name, name );
					tgtList.options[tgtList.length] = opt;
					break;
				}
			}
		}

		function chgSelectedText( frmName, srcListName, text ) {
			var form = eval( 'document.' + frmName );
			var srcList = eval( 'form.' + srcListName );

			i = srcList.selectedIndex;
			if (i != null && i > -1) {
				srcList.options[i].text = text;
				return true;
			} else {
				return false;
			}
		}

		function showIncludeProps() {
			form = document.adminForm;
			value = getSelectedValue( 'adminForm', 'includelist' );
			parts = value.split( '|' );
			form._include_source.value = unescape(parts[0]);
			form._include_description.value = unescape(parts[1] || '');
		}

		function applyIncludeProps() {
			form = document.adminForm;
			if (!getSelectedValue( 'adminForm', 'includelist' )) {
				alert( "Select an include-file from the list" );
				return;
			}
			value = escape(form._include_source.value) + '|'
			+ escape(form._include_description.value);
			chgSelectedValue( 'adminForm', 'includelist', value );
		}

		function showArgumentProps() {
			form = document.adminForm;
			value = getSelectedValue( 'adminForm', 'argumentlist' );
			parts = value.split( '|' );
			form._argument_name.value = unescape(parts[0]);
			form._argument_value.value = unescape(parts[1] || '');
		}

		function applyArgumentProps() {
			form = document.adminForm;
			if (!getSelectedValue( 'adminForm', 'argumentlist' )) {
				alert( "Select an argument from the list" );
				return;
			}
			value = escape(form._argument_name.value) + '|'
			+ escape(form._argument_value.value);
			chgSelectedValue( 'adminForm', 'argumentlist', value );
			chgSelectedText('adminForm', 'argumentlist', form._argument_name.value);
		}

		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}

			// assemble the includes back into one field
			var temp = new Array;
			for (var i=0, n=form.includelist.options.length; i < n; i++) {
				temp[i] = form.includelist.options[i].value;
			}
			form.includes.value = temp.join( '\n' );

			// assemble the arguments back into one field
			var temp = new Array;
			for (var i=0, n=form.argumentlist.options.length; i < n; i++) {
				temp[i] = form.argumentlist.options[i].value;
			}
			form.args.value = temp.join( '\n' );

			// do field validation
			if ( form.catid.value == 0 ) {
				alert(<?php echo mosMoslateLang::getErrorTextAsScriptString('EMPTY_CATEGORY', 'Please select a Category.', $variableMap); ?>);
			} else if ( form.name.value == "" ) {
				alert(<?php echo mosMoslateLang::getErrorTextAsScriptString('EMPTY_NAME', 'You must provide a name.', $variableMap); ?>);
			} else {
				submitform( pressbutton );
			}
		}
		</script>
		<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
		<form action="index2.php" method="post" name="adminForm">

		<input type="hidden" name="includes" value="" />
		<input type="hidden" name="args" value="" />

		<table class="adminheading">
		<tr>
			<th>
				<?php
					if ($row->id > 0) {
						echo mosMoslateLang::getTitleTextAsHtml('EDIT_MOSLATE', 'Edit Moslate', $variableMap);
					} else {
						echo mosMoslateLang::getTitleTextAsHtml('NEW_MOSLATE', 'Add Moslate', $variableMap);
					}
				?>
			</th>
		</tr>
		</table>

		<table width="100%">
		<tr>
			<td width="60%" valign="top">
				<table width="100%" class="adminform">
				<tr>
					<th colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('MOSLATE', 'Moslate', $variableMap); ?>
					</th>
				<tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('CATEGORY', 'Category', $variableMap); ?>:
					</td>
					<td width="40%">
						<?php echo $lists['catid'];?>
					</td>
				</tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('LINKED_TO_USER', 'Linked to User', $variableMap); ?>:
					</td>
					<td >
					<?php echo $lists['user_id'];?>
					</td>
				</tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('NAME', 'Name', $variableMap); ?>:
					</td>
					<td >
						<input class="inputbox" type="text" name="name" size="50" maxlength="100" value="<?php echo $row->name; ?>" />
					</td>
				</tr>
				<tr>
					<td align="right" valign="top" colspan="2">
						<?php echo mosMoslateLang::getFieldTextAsHtml('TEMPLATE', 'Template', $variableMap); ?>:
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<textarea name="template" rows="30" cols="75" class="inputbox" style="width:100%; height:400;"><?php echo $row->template; ?></textarea>
					</td>
				</tr>
				<tr>
				</table>
			</td>
			<td width="40%" valign="top">
				<?php
				$tabs->startPane('moslate-pane');
				$tabs->startTab(mosMoslateLang::getTabTextAsHtml('PUBLISHING', 'Publishing', $variableMap), 'publish-page');
				?>
				<table width="100%" class="adminform">
				<tr>
					<th colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('PUBLISH_INFO', 'Publishing Info', $variableMap); ?>
					</th>
				<tr>
				<tr>
					<td valign="top" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('PUBLISHED', 'Published', $variableMap); ?>:
					</td>
					<td>
						<?php echo $lists['published']; ?>
					</td>
				</tr>
				<tr>
					<td valign="top" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('ORDERING', 'Ordering', $variableMap); ?>:
					</td>
					<td>
					<?php echo $lists['ordering']; ?>
					</td>
				</tr>
				<tr>
					<td valign="top" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('ACCESS', 'Access', $variableMap); ?>:
					</td>
					<td>
					<?php echo $lists['access']; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">&nbsp;

					</td>
				</tr>
				</table>
				<?php
				$tabs->endTab();
				$tabs->startTab(mosMoslateLang::getTabTextAsHtml('INCLUDES', 'Includes', $variableMap), 'includes-page');
				?>
				<table class="adminform" width="100%">
				<tr>
					<th colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('INCLUDES', 'Include Control', $variableMap); ?>
					</th>
				</tr>
				<tr>
					<td colspan="6">Sub-folder: <?php echo $lists['includefolders'];?></td>
				</tr>
				<tr>
					<td>
						<?php echo mosMoslateLang::getFieldTextAsHtml('AVAILABLE_INCLUDES', 'Available Includes', $variableMap); ?>:
						<br />
						<?php echo $lists['includefiles'];?>
					</td>
				</tr>
				<tr>
					<td>
						<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('ADD', 'add', $variableMap); ?>" onClick="addSelectedToList('adminForm','includefiles','includelist')" />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo mosMoslateLang::getFieldTextAsHtml('MOSLATE_INCLUDES', 'Moslate Includes', $variableMap); ?>:
						<br />
						<?php echo $lists['includelist'];?>
					</td>
				</tr>
				<tr>
					<td>
						<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('UP', 'up', $variableMap); ?>" onClick="moveInList('adminForm','includelist',adminForm.includelist.selectedIndex,-1)" />
						<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('DOWN', 'down', $variableMap); ?>" onClick="moveInList('adminForm','includelist',adminForm.includelist.selectedIndex,+1)" />
						<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('REMOVE', 'remove', $variableMap); ?>" onClick="delSelectedFromList('adminForm','includelist')" />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('INCLUDE_EDIT', 'Edit the selected include', $variableMap); ?>:
						<table>
						<tr>
							<td align="right">
								<?php echo mosMoslateLang::getFieldTextAsHtml('INCLUDE_SOURCE', 'Source', $variableMap); ?>:
							</td>
							<td>
								<input class="text_area" type="text" name="_include_source" value="" />
							</td>
						</tr>
						<tr>
							<td align="right">
								<?php echo mosMoslateLang::getFieldTextAsHtml('INCLUDE_DESCRIPTION', 'Description', $variableMap); ?>:
							</td>
							<td>
								<input class="text_area" type="text" name="_include_description" value="" />
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('APPLY', 'apply'); ?>" onClick="applyIncludeProps()" />
							</td>
						</tr>
						</table>
					</td>
				</tr>
				</table>
				<?php
				$tabs->endTab();
				$tabs->startTab(mosMoslateLang::getTabTextAsHtml('ARGUMENTS', 'Arguments', $variableMap), 'args-page');
				?>
				<table class="adminform" width="100%">
				<tr>
					<th colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('ARGUMENTS', 'Argument Control', $variableMap); ?>
					</th>
				</tr>
				<tr>
					<td>
					<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('ADD', 'add', $variableMap); ?>" onClick="addNewToList('adminForm','argumentlist','arg')" />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo mosMoslateLang::getFieldTextAsHtml('ARGUMENTS', 'Moslate Arguments', $variableMap); ?>:
						<br />
						<?php echo $lists['argumentlist'];?>
					</td>
				</tr>
				<tr>
					<td>
					<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('UP', 'up', $variableMap); ?>" onClick="moveInList('adminForm','argumentlist',adminForm.argumentlist.selectedIndex,-1)" />
					<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('DOWN', 'down', $variableMap); ?>" onClick="moveInList('adminForm','argumentlist',adminForm.argumentlist.selectedIndex,+1)" />
					<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('REMOVE', 'remove', $variableMap); ?>" onClick="delSelectedFromList('adminForm','argumentlist')" />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('ARGUMENT_EDIT', 'Edit the selected argument', $variableMap); ?>:
						<table>
						<tr>
							<td align="right">
								<?php echo mosMoslateLang::getFieldTextAsHtml('ARGUMENT_NAME', 'Name', $variableMap); ?>:
							</td>
							<td>
								<input class="text_area" type="text" name="_argument_name" value="" />
							</td>
						</tr>
						<tr>
							<td align="right">
								<?php echo mosMoslateLang::getFieldTextAsHtml('ARGUMENT_VALUE', 'Value', $variableMap); ?>:
							</td>
							<td>
								<input class="text_area" type="text" name="_argument_value" value="" />
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<input class="button" type="button" value="<?php echo mosMoslateLang::getButtonTextAsHtml('APPLY', 'apply', $variableMap); ?>" onClick="applyArgumentProps()" />
							</td>
						</tr>
						</table>
					</td>
				</tr>
				</table>
				<?php
				$tabs->endTab();
				$tabs->startTab(mosMoslateLang::getTabTextAsHtml('PARAMETERS', 'Options', $variableMap), 'params-page');
				?>
				<table class="adminform">
				<tr>
					<th>
						<?php echo mosMoslateLang::getHeaderTextAsHtml('PARAMETERS', 'Options', $variableMap); ?>
					</th>
				</tr>
				<tr>
					<td>
						<?php echo $params->render(); ?>
					</td>
				</tr>
				</table>
				<?php
				$tabs->endTab();
				$tabs->startTab(mosMoslateLang::getTabTextAsHtml('STATUS', 'Status'), 'status-page');
				?>
				<table class="adminform">
				<tr>
					<th>
						<?php echo mosMoslateLang::getHeaderTextAsHtml('STATUS_MAMBOT', 'Mambot'); ?>
					</th>
				</tr>
				<tr>
					<td>
						<?php
							$logger->logEntries($mambotLogEntries);
						?>
					</td>
				</tr>
				<tr>
					<th>
						<?php echo mosMoslateLang::getHeaderTextAsHtml('STATUS_MOSLATE', 'Moslate'); ?>
					</th>
				</tr>
				<tr>
					<td>
						<?php
							$logger->logEntries($moslateLogEntries);
						?>
					</td>
				</tr>
				</table>
				<?php
				$tabs->endTab();
				$tabs->endPane();
				?>
			</td>
		</tr>
		</table>

		<script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
		<input type="hidden" name="option" value="<?php echo $option; ?>" />
		<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
		<input type="hidden" name="task" value="" />
		</form>
		<?php
	}


	function editConfiguration( &$row, &$lists, $option, &$params ) {
		global $mosConfig_live_site;

		$variableMap		= array();

		$logger				= new mosMoslateLoggerHtml();
		mosMoslateLang::translateParameters($params);

		$tabs = new mosTabs(0);

		$mambotLogEntries	= $lists['mambot_log_entries'];

		?>
		<script language="javascript" type="text/javascript">
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}

			submitform( pressbutton );
		}
		</script>
		<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
		<form action="index2.php" method="post" name="adminForm">

		<table class="adminheading">
		<tr>
			<th class="config">
				<?php echo mosMoslateLang::getTitleTextAsHtml('CONFIGURATION', 'Edit Configuration'); ?>
			</th>
		</tr>
		</table>

		<table align="left">
		<tr>
			<td valign="top">
				<?php
				$tabs->startPane('moslate-pane');
				$tabs->startTab(mosMoslateLang::getTabTextAsHtml('CONFIGURATION', 'Configuration'), 'params-page');
				?>
				<table class="adminform">
				<tr>
					<th colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('CONFIGURATION', 'Configuration'); ?>
					</th>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo $params->render(); ?>
					</td>
				</tr>
				<tr>
					<td valign="top" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('ACCESS_EL', 'Access Level for EL', $variableMap); ?>:
					</td>
					<td>
						<?php echo $lists['access_el']; ?>
					</td>
				</tr>
				</table>
				<?php
				$tabs->endTab();
				$tabs->endPane();
				?>
			</td>
		</tr>
		</table>

		<table align="left" width="60%">
		<tr>
			<td valign="top">
				<?php
				$tabs->startPane('moslate-status-pane');
				$tabs->startTab(mosMoslateLang::getTabTextAsHtml('STATUS', 'Status'), 'status-page');
				?>
				<table class="adminform">
				<tr>
					<th>
						<?php echo mosMoslateLang::getHeaderTextAsHtml('STATUS_MAMBOT', 'Mambot'); ?>
					</th>
				</tr>
				<tr>
					<td>
						<?php
							$logger->logEntries($mambotLogEntries);
						?>
					</td>
				</tr>
				</table>
				<?php
				$tabs->endTab();
				$tabs->endPane();
				?>
			</td>
		</tr>
		</table>

		<script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
		<input type="hidden" name="option" value="<?php echo $option; ?>" />
		<input type="hidden" name="task" value="" />
		</form>
		<?php
	}


	function showImport( &$lists, $option ) {
		global $mosConfig_live_site;

		$tabs = new mosTabs(0);

		?>
		<script language="javascript" type="text/javascript">
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}

			submitform( pressbutton );
		}
		</script>
		<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
		<form action="index2.php" method="post" name="adminForm" enctype="multipart/form-data">

		<table class="adminheading">
		<tr>
			<th class="dbrestore">
				<?php echo mosMoslateLang::getTitleTextAsHtml('IMPORT', 'Import Moslates (XML)'); ?>
			</th>
		</tr>
		</table>

		<table width1="100%" align="left">
		<tr>
			<td width1="60%" valign="top">
				<table width1="100%" class="adminform">
				<tr>
					<th colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('IMPORT', 'Import File'); ?>
					</th>
				<tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('FILE', 'File'); ?>:
					</td>
	                <td>
	                    <input class="inputbox" type="file" name="userfile" value="" size="50" maxlength="250">
	                </td>
				</tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('OVERWRITE_CATEGORIES', 'Overwrite Categories'); ?>:
					</td>
					<td >
						<?php echo $lists['overwrite_categories']; ?>
					</td>
				</tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('OVERWRITE_MOSLATES', 'Overwrite Moslates'); ?>:
					</td>
					<td >
						<?php echo $lists['overwrite_moslates']; ?>
					</td>
				</tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('OVERWRITE_FILES', 'Overwrite Files'); ?>:
					</td>
					<td >
					<?php echo $lists['overwrite_files']; ?>
					</td>
				</tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('UNPUBLISH_IMPORTED_MOSLATES', 'Unpublish imported Moslates'); ?>:
					</td>
					<td >
						<?php echo $lists['unpublish_moslates']; ?>
					</td>
				</tr>
				</table>
			</td>
		</tr>
		</table>

		<script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
		<input type="hidden" name="option" value="<?php echo $option; ?>" />
		<input type="hidden" name="task" value="" />
		</form>
		<?php
	}

	function showExport( &$lists, $option ) {
		global $mosConfig_live_site;

		$tabs = new mosTabs(0);

		?>
		<script language="javascript" type="text/javascript">
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}

			submitform( pressbutton );
		}
		</script>
		<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
		<form action="index2.php" method="post" name="adminForm">

		<table class="adminheading">
		<tr>
			<th class="dbbackup">
				<?php echo mosMoslateLang::getTitleTextAsHtml('EXPORT', 'Export Moslates (XML)'); ?>
			</th>
		</tr>
		</table>

		<table width="100%">
		<tr>
			<td width="60%" valign="top">
				<table width="100%" class="adminform">
				<tr>
					<th colspan="2">
						<?php echo mosMoslateLang::getHeaderTextAsHtml('EXPORT', 'Export Filters/Options (optional)'); ?>
					</th>
				<tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('CATEGORY', 'Category'); ?>:
					</td>
					<td width="40%">
						<?php echo $lists['catid'];?>
					</td>
				</tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('LINKED_TO_USER', 'Linked to User'); ?>:
					</td>
					<td >
					<?php echo $lists['user_id'];?>
					</td>
				</tr>
				<tr>
					<td width="20%" align="right">
						<?php echo mosMoslateLang::getFieldTextAsHtml('EXPORT_FILES', 'Export Files'); ?>:
					</td>
					<td >
						<?php echo $lists['export_files']; ?>
					</td>
				</tr>
				</table>
			</td>
		</tr>
		</table>

		<script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
		<input type="hidden" name="option" value="<?php echo $option; ?>" />
		<input type="hidden" name="task" value="" />
		</form>
		<?php
	}

	function showEmptyForm( $option ) {
		global $mosConfig_live_site;

		?>
		<script language="javascript" type="text/javascript">
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}

			submitform( pressbutton );
		}
		</script>
		<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
		<form action="index2.php" method="post" name="adminForm">
		<script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
		<input type="hidden" name="option" value="<?php echo $option; ?>" />
		<input type="hidden" name="task" value="" />
		</form>
		<?php
	}

	function printText($msg, $color = null) {
		if (!$color) {
			echo ($msg);
		} else {
			echo ("<span style=\"color:$color\">$msg</span>");
		}
	}

	function printLine($msg = null, $color = null, $indent = 0) {
		if ($indent > 0) {
			for ($i = 0; $i < $indent; $i ++)
				echo ("&nbsp;");
		}
		if ($msg) {
			HTML_moslate :: printText($msg, $color);
		}
		echo ("<br />\n");
	}

	function beginPage($title, $styleClass = "") {
		?><table class="adminheading" width="100%">
			<tr>
				<th class="<?php echo $styleClass; ?>">&nbsp;<?php echo $title; ?></th>
		    </tr>
		    <tr>
				<td valign="top" align="left">
				<br/><?php
	}

	function endPage() {
		?></td>
		</tr>
	</table><?php
	}

} // class HTML_moslate

?>