<?php
/**
 * Moslate admin interface controller.
 *
 * @package moslate
 * @version $Id: admin.moslate.php 203 2006-09-19 22:22:24Z  $
 * @copyright (C) 2004-2006 Daniel Ecer (de.siteof.de)
 * @license GNU/GPL
 */

/** Ensure this file is being included by a parent file */
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

//error_reporting(E_ALL);

require_once($mainframe->getPath('class'));
require_once($mainframe->getPath('admin_html'));
require_once('admin.moslate.class.php');

mosMoslateLang::load();

if (!DEFINED('MOSLATE_CSS_INCLUDED')) {
	// note: this may cause the admin page to not validate, which it doesn't anyway
	echo '<link href="'.$mosConfig_live_site.'/components/com_moslate/css/moslate.css" rel="stylesheet" type="text/css"/>';
}


$task = trim(mosGetParam($_REQUEST, "task", null));
$id = mosGetParam($_REQUEST, 'id', '');
$cid = mosGetParam($_REQUEST, "cid", array (0));
if (!is_array($cid)) {
	$cid = array (0);
}

$func = ($task <> '' ? $task : $act);

switch ($func) {

	case "info":
	case "about":
		HTML_moslate::showMoslateLinks();
		echo '<hr />';
		include 'readme.moslate.php';
		break;

	case "installtest":
		include 'install.moslate.php';
		echo com_install();
		break;

	case "config":
		editConfiguration(0, $option);
		break;

	case "saveconfig":
		saveConfiguration($option);
		break;

	case "new":
		editMoslate('0', $option);
		break;

	case "edit":
		editMoslate($id, $option);
		break;

	case "editA":
		editMoslate($cid[0], $option);
		break;

	case "cancel":
		cancelMoslate($cid, $option);
		break;

	case "apply":
	case "save":
		saveMoslate($option, $func);
		break;

	case "remove":
		removeMoslates($cid, $option);
		break;

	case "import":
		importMoslates($cid, $option);
		break;

	case "uploadimport":
		uploadImportMoslates($cid, $option);
		break;

	case "export":
		exportMoslates($cid, $option);
		break;

	case "downloadexport":
		downloadExportMoslates($cid, $option);
		break;

	case "publish":
		changeMoslate( $cid, 1, $option );
		break;

	case "unpublish":
		changeMoslate( $cid, 0, $option );
		break;

	case "orderup":
		orderMoslates( $cid[0], -1, $option );
		break;

	case "orderdown":
		orderMoslates( $cid[0], 1, $option );
		break;

	case 'saveorder':
		saveOrder($cid, $option);
		break;

	case 'accesspublic':
		accessMenu( $cid[0], 0, $option, $client );
		break;

	case 'accessregistered':
		accessMenu( $cid[0], 1, $option, $client );
		break;

	case 'accessspecial':
		accessMenu( $cid[0], 2, $option, $client );
		break;

	case 'updatelanguage':
		updateLanguage($option);

	default :
		showMoslates($option);
		break;
}

function mkdirsMoslate($dir) {
	if ($dir == '') {
		return true;
	}
	if (!file_exists($dir)) {
		mkdirsMoslate(dirname($dir));
		if (function_exists('mosMakeDir')) {
			return mosMakeDir($dir);
		} else {
			return mkdir($dir);
		}
	}
	return true;
}

/**
* List the records
* @param string The current GET/POST option
*/
function showMoslates( $option) {
	global $database, $mainframe, $mosConfig_list_limit, $administratorAbsolutePath;

	$catid = $mainframe->getUserStateFromRequest( "catid{$option}", 'catid', 0 );
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	$search = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
	$search = $database->getEscaped( trim( strtolower( $search ) ) );

	$where	= array();

	if ( $catid > 0 ) {
		$where[] = "moslate.catid='$catid'";
	}

	if ($search != "") {
		$where[] = "moslate.name LIKE '%$search%'";
	}

	// flatten $where
	$where	= (count( $where ) > 0 ? "\nWHERE " . implode( ' AND ', $where ) : "");

	// get the total number of records
	$database->setQuery( "SELECT COUNT(*) FROM #__moslate AS moslate $where" );
	$total = $database->loadResult();

	require_once($administratorAbsolutePath.'/includes/pageNavigation.php');
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );

	// get the subset (based on limits) of required records
	$query = "SELECT moslate.*, g.name AS groupname, cc.title AS category, v.name AS user, u.name as editor"
	. "\n FROM #__moslate AS moslate"
	. "\n LEFT JOIN #__groups AS g ON g.id = moslate.access"
	. "\n LEFT JOIN #__categories AS cc ON cc.id = moslate.catid"
	. "\n LEFT JOIN #__users AS u ON u.id = moslate.checked_out"
	. "\n LEFT JOIN #__users AS v ON v.id = moslate.user_id"
	. $where
	. "\n ORDER BY moslate.catid, moslate.ordering, moslate.name ASC"
	. "\n LIMIT $pageNav->limitstart, $pageNav->limit"
	;
	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	// build list of categories
	$javascript = 'onchange="document.adminForm.submit();"';
	$lists['catid'] 			= mosAdminMenus::ComponentCategory( 'catid', 'com_moslate', intval( $catid ), $javascript );

	HTML_moslate::showMoslates( $rows, $pageNav, $search, $option, $lists );
}


/**
* Changes the state of one or more content pages
* @param array An array of unique moslate id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current option
*/
function changeMoslate( $cid=null, $state=0, $option ) {
	global $database, $my;

	if (count( $cid ) < 1) {
		$publish	= $state;
		$action = $publish == 1 ? 'publish' : 'unpublish';
		echo "<script> alert('Select a record to $action'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__moslate SET published='$state'"
	. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosMoslate( $database );
		$row->checkin( intval( $cid[0] ) );
	}

	mosRedirect( "index2.php?option=$option" );
}

/**
* Moves the order of a record
* @param integer The increment to reorder by
*/
function orderMoslates( $uid, $inc, $option ) {
	global $database;
	$row = new mosMoslate( $database );
	$row->load( $uid );
	$row->move( $inc, "published >= 0" );

	mosRedirect( "index2.php?option=$option" );
}

/**
* changes the access level of a record
* @param integer The increment to reorder by
*/
function accessMenu( $uid, $access, $option ) {
	global $database;

	$row = new mosMoslate( $database );
	$row->load( $uid );
	$row->access = $access;

	if ( !$row->check() ) {
		return $row->getError();
	}
	if ( !$row->store() ) {
		return $row->getError();
	}

	mosRedirect( "index2.php?option=$option" );
}

/**
* Creates a new or edits and existing user record
* @param int The id of the record, 0 if a new entry
* @param string The current GET/POST option
*/
function editMoslate( $id, $option ) {
	global $database, $my, $mainframe;
	global $mosConfig_absolute_path, $mosConfig_live_site;
	global $administratorAbsolutePath;

	$admin			= new mosMoslateAdminManager();

	$row = new mosMoslate( $database );
	// load the row from the db table
	$row->load( $id );

	if ($id) {
		// do stuff for existing records
		$row->checkout($my->id);

		if (trim( $row->includes )) {
			$row->includes = explode( "\n", $row->includes );
		} else {
			$row->includes = array();
		}
		if (trim( $row->args )) {
			$row->args = explode( "\n", $row->args );
		} else {
			$row->args = array();
		}
	} else {
		$catid = $mainframe->getUserStateFromRequest( "catid{$option}", 'catid', 0 );

		// do stuff for new records
		$row->access = 2;
		$row->imagepos = 'top';
		$row->ordering = 0;
		$row->published = 1;

		$row->includes = array();
		$row->args = array();

		if ($catid > 0) {
			$row->catid = $catid;
		}
	}
	$lists = array();

	// build the html select list for ordering
	$query = "SELECT ordering AS value, name AS text"
	. "\n FROM #__moslate"
	. "\n WHERE published >= 0"
	. "\n ORDER BY ordering"
	;
	$lists['ordering'] 			= mosAdminMenus::SpecificOrdering( $row, $id, $query, 1 );

	// build list of users
	$lists['user_id'] 			= mosAdminMenus::UserSelect( 'user_id', $row->user_id, 1 );
	// build list of categories
	$lists['catid'] 			= mosAdminMenus::ComponentCategory( 'catid', 'com_moslate', intval( $row->catid ) );
	// build the html select list for images
	$lists['image'] 			= mosAdminMenus::Images( 'image', $row->image );
	// build the html select list for the group access
	$lists['access'] 			= mosAdminMenus::Access( $row );
	// build the html radio buttons for published
	$lists['published'] 		= mosHTML::yesnoradioList( 'published', '', $row->published );


	// calls function to read image from directory
	$pathA = $mosConfig_absolute_path .'/components/com_moslate/includes';
	$pathL = '';
	$includes = array();
	$folders = array();
	$folders[] = mosHTML::makeOption( '/' );
	mosMoslateMenus::ReadIncludes( $pathA, '/', $folders, $includes );

	// list of folders in .../com_moslate/includes/
	$lists['includefolders']	= mosMoslateMenus::GetIncludeFolders( $folders, $pathL );
	// list of includes in specfic folder in images/stories/
	$lists['includefiles']		= mosMoslateMenus::GetIncludes( $includes, $pathL );
	// list of saved includes
	$lists['includelist'] 		= mosMoslateMenus::GetSavedIncludes( $row );

	// list of saved arguments
	$lists['argumentlist'] 		= mosMoslateMenus::GetSavedArguments( $row );

	// get params definitions
	$file = $administratorAbsolutePath .'/components/com_moslate/res/moslate_items.xml';
	$params =& new mosMoslateParameters( $row->params, $file, 'component' );

	$lists['mambot_log_entries']	=& $admin->getMambotStatusLogEntries();
	$lists['moslate_log_entries']	=& $admin->getMoslateStatusLogEntries($row);

	HTML_moslate::editMoslate( $row, $lists, $option, $includes, $params );
}

/**
* Saves the record from an edit form submit
* @param string The current GET/POST option
*/
function saveMoslate($option, $task) {
	global $database, $my;

	$row = new mosMoslate( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	// save params
	$params = mosGetParam( $_POST, 'params', '' );
	if (is_array( $params )) {
		$txt = array();
		foreach ( $params as $k=>$v) {
			$txt[] = "$k=$v";
		}
		$row->params = implode( "\n", $txt );
	}

	// pre-save checks
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	// save the changes
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	$row->updateOrder();

	switch($task) {
		case 'apply':
			$msg = 'Successfully Saved changes to Item: '. $row->title;
			mosRedirect('index2.php?option='.$option.'&task=edit&hidemainmenu=1&id='.$row->id, $msg);

		case 'save':
		default:
			$msg = 'Successfully Saved Item: '. $row->title;
			mosRedirect('index2.php?option='.$option, $msg);
			break;
	}
}

function saveOrder(&$cid, $option) {
	global $database;

	$total		= count($cid);
	$order 		= mosGetParam($_POST, 'order', array(0));
	$rettask	= mosGetParam($_POST, 'returntask', '');
	$row 		= new mosMoslate($database);
	$conditions = array();

    // update ordering values
	for($i=0; $i < $total; $i++) {
		$row->load($cid[$i]);
		if ($row->ordering != $order[$i]) {
			$row->ordering = $order[$i];
	        if (!$row->store()) {
	            echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	            exit();
	        } // if
	        // remember to updateOrder this group
	        $condition = "catid='$row->catid' AND state>=0";
	        $found = false;
	        foreach ( $conditions as $cond )
	            if ($cond[1]==$condition) {
	                $found = true;
	                break;
	            } // if
	        if (!$found) $conditions[] = array($row->id, $condition);
		} // if
	} // for

	// execute updateOrder for each group
	foreach ($conditions as $cond) {
		$row->load( $cond[0] );
		$row->updateOrder($cond[1]);
	} // foreach

	$msg 	= 'New ordering saved';
	switch ($rettask) {
		case 'showarchive':
			mosRedirect( 'index2.php?option='.$option.'&task=showarchive', $msg );
			break;

		default:
			mosRedirect( 'index2.php?option='.$option, $msg );
			break;
	} // switch
} // saveOrder

/**
* Edits the configuration
* @param int not used
* @param string The current GET/POST option
*/
function editConfiguration( $id, $option ) {
	global $database, $my, $mainframe;
	global $mosConfig_absolute_path;
	global $administratorAbsolutePath;

	$lang			= mosMoslateLang::getInstance();
	$admin			= new mosMoslateAdminManager();

	$lists = array();

	// get params definitions
	$file = $administratorAbsolutePath.'/components/com_moslate/res/moslate_config.xml';
	$params =& new mosParameters( "", $file, 'component' );

	$config	= new mosMoslateConfig();
	$config->def('access_el', 2);
	$propertyNames	= $config->getPropertyNames();
	foreach ($propertyNames as $k) {
		$params->set($k, $config->get($k));
	}

	$accessObject	= new stdClass();
	$accessObject->access	= $config->get('access_el');

	$mambotLogEntries				= $admin->getMambotStatusLogEntries();
	$lists['mambot_log_entries']	=& $mambotLogEntries;
	$lists['access_el'] 			= mosAdminMenus::Access( $accessObject );

	$row	= new stdClass();

	HTML_moslate::editConfiguration( $row, $lists, $option, $params );
}

/**
* Saves the configuration from an edit form submit
* @param string The current GET/POST option
*/
function saveConfiguration( $option ) {
	global $database, $my;

	// save params
	$params = mosGetParam( $_POST, 'params', '' );
	$config	= new mosMoslateConfig();
	if (is_array( $params )) {
		foreach ( $params as $k=>$v) {
			$config->set($k, $v);
		}
	}

	$access_el = intval(mosGetParam( $_POST, 'access', ''));
	$config->set('access_el', $access_el);

	if ($config->save()) {
		mosRedirect( 'index2.php?option='.$option.'&task=config', 'The configuration details have been updated!' );
	} else {
		mosRedirect( 'index2.php?option='.$option.'&task=config', 'An Error Has Occurred! Unable to open config file to write!' );
	}
}


/**
* Cancels editing and checks in the record
* @int the contact id
*/
function cancelMoslate($cid, $option){
	global $database;
	$row = new mosMoslate( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect("index2.php?option=$option");
}

/**
* Removes records
* @param array An array of id keys to remove
* @param string The current GET/POST option
*/
function removeMoslates( &$cid, $option ) {
	global $database;

	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__moslate WHERE id IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

	mosRedirect( "index2.php?option=$option" );
}

/**
* Import records
* @param array An array of id keys (ignored)
* @param string The current GET/POST option
*/
function importMoslates(&$cid, $option) {
	global $database, $my, $mainframe;
	global $mosConfig_absolute_path;
	global $mosConfig_db, $mosConfig_dbprefix;

	$lists = array();

	$lists['overwrite_categories']	= mosHTML::yesnoradioList( 'overwrite_categories', '', false );
	$lists['overwrite_moslates']	= mosHTML::yesnoradioList( 'overwrite_moslates', '', false );
	$lists['overwrite_files'] 		= mosHTML::yesnoradioList( 'overwrite_files', '', false );
	$lists['unpublish_moslates'] 		= mosHTML::yesnoradioList( 'unpublish_moslates', '', false );

	HTML_moslate::showImport( $lists, $option );
	return;
}

function importMoslateFilesByNode(&$xmlDoc, &$xmlParent, $nodename, $basePath, $isOverwriteFiles) {
	$debug	= false;
	$slashesCharset		= "\0..\37!@\@\177..\377";
	$xmlGroup = null;
	$elements	= $xmlDoc->getElementsByTagName($nodename);
	if ($elements->getLength() == 1) {
		$xmlGroup	=& $elements->item(0);
	}
	if ($xmlGroup == null) {
		return 0;
	}
	$fileElements	= $xmlGroup->getElementsByTagName("file");
	$fileCount		= $fileElements->getLength();
	for ($iFile = 0; $iFile < $fileCount; $iFile++) {
		$xmlFile	=& $fileElements->item($iFile);
		$fileName	= $xmlFile->getAttribute('filename');
		$data		= $xmlFile->getText();
		$fullName	= $basePath.$fileName;
		if ($debug) {
			echo "<hr/>\n";
			echo htmlentities($fileName)."\n";
			echo "<hr/>\n";
			echo str_replace("\n", "<br/>\n", htmlentities($data))."\n";
			echo "<hr/>\n";
		}

		if (file_exists($fullName)) {
			if ($isOverwriteFiles) {
				echo "overwriting file ".htmlentities($fullName)."<br/>\n";
			} else {
				echo "file already exists ".htmlentities($fullName)."<br/>\n";
				continue;
			}
		} else {
				echo "creating file ".htmlentities($fullName)."<br/>\n";
		}
		mkdirsMoslate(dirname($fullName));
		$h	= fopen($fullName, "wb");
		fwrite($h, $data);
		fclose($h);
	}
}

function uploadImportMoslates(&$cid, $option) {
	global $database, $my, $mainframe;
	global $mosConfig_absolute_path, $mosConfig_live_site;
	global $mosConfig_db, $mosConfig_dbprefix;
	global $HTTP_POST_FILES;

	$logger				= new mosMoslateLoggerHtml();
	$lang				= mosMoslateLang::getInstance();
	$variableMap		= array();

	$userfile			= mosGetParam( $_FILES, 'userfile', null );
    $userfileTempName	= $userfile['tmp_name'];
	$userfileName 		= $userfile['name'];

	HTML_moslate::beginPage(mosMoslateLang::getTitleTextAsHtml('IMPORT', 'Import Moslates (XML)'), 'dbrestore');
	HTML_moslate::showEmptyForm($option);

	$overwrite_categories	= mosGetParam($_POST, "overwrite_categories", null) == 1;
	$overwrite_moslates		= mosGetParam($_POST, "overwrite_moslates", null) == 1;
	$overwrite_files		= mosGetParam($_POST, "overwrite_files", null) == 1;
	$unpublish_moslates		= mosGetParam($_POST, "unpublish_moslates", null) == 1;

	$baseName	= basename($userfileName);
	$i			= strrpos($baseName, '.');
	if ($i !== FALSE) {
		$ext	= strtolower(substr($baseName, $i));
	} else {
		$ext	= '';
	}
	$xmlDoc 		= null;
	$xmlCategories	= null;
	$variableMap['file.name']	= $userfileName;
	if ($ext != '.xml') {
		$installer	= new mosInstallerMoslate();
		$msg = '';
		$resultdir = $installer->uploadFile( $userfile['tmp_name'], $userfile['name'], $msg );

		if ($resultdir !== false) {
			if (!$installer->upload( $userfile['name'] )) {
				$variableMap['error.message']	= $installer->getError();
				$logger->logError($lang->getLangText('_MOSLATE_ERROR_UPLOAD_FAILED', 'Upload Failed: ${error.message}', $variableMap));
				HTML_moslate::endPage();
				return false;
			}
			$findFileResult = $installer->findInstallFile();

			if (!$findFileResult) {
				$variableMap['error.message']	= $installer->getError();
				$logger->logError($lang->getLangText('_MOSLATE_ERROR_UPLOAD_FAILED', 'Upload Failed: ${error.message}', $variableMap));
			} else {
				$variableMap['file.name']	= $installer->installFilename();
			}
			cleanupInstall( $userfile['name'], $installer->unpackDir() );
			if (!$findFileResult) {
				HTML_moslate::endPage();
				return false;
			}
			$xmlDoc	=& $installer->xmlDoc();
		} else {
			$variableMap['error.message']	= $installer->getError();
			$logger->logError($lang->getLangText('_MOSLATE_ERROR_UPLOAD_FAILED', 'Upload Failed: ${error.message}', $variableMap));
			HTML_moslate::endPage();
			return false;
		}
	} else {
		$xmlDoc =& new DOMIT_Lite_Document();
		$xmlDoc->resolveErrors( true );
		if ($xmlDoc->loadXML( $userfileTempName, false, true )) {
		} else {
			$logger->logError($lang->getLangText('_MOSLATE_ERROR_INVALID_XML', 'Invalid XML file.', $variableMap));
			HTML_moslate::endPage();
			return false;
		}
	}

	$logger->logInfo($lang->getLangText('_MOSLATE_INFO_IMPORT_FROM_FILE', 'Importing from file "${file.name}".', $variableMap));

	$elements	= $xmlDoc->getElementsByTagName("categories");
	if ($elements->getLength() == 1) {
		$xmlCategories	=& $elements->item(0);
	}

	if ($xmlCategories == null) {
		$logger->logError($lang->getLangText('_MOSLATE_ERROR_CATEGORIES_NODE_NOT_FOUND', 'Categories-Node not found.', $variableMap));
		HTML_moslate::endPage();
		return false;
	}

	$section	= "com_moslate";
	$order		= "ordering";
	$query = "SELECT * FROM #__categories";
	$query	.= "\n WHERE section = '". $section ."'";
	$query	.= "\n ORDER BY ". $order;

	$database->setQuery($query);
	$rowsCategories = $database->loadObjectList();
	if ($database->getErrorNum()) {
		$logger->logError(stripslashes($database->getErrorMsg()));
		HTML_moslate::endPage();
		return false;
	}

	$order		= "ordering";
	$query = "SELECT * FROM #__moslate";
	$query	.= "\n ORDER BY ". $order;
	$database->setQuery($query);
	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		$logger->logError(stripslashes($database->getErrorMsg()));
		HTML_moslate::endPage();
		return false;
	}

	$moslatesCreated	= 0;
	$moslatesUpdated	= 0;
	$moslatesSkipped	= 0;
	$categoriesCreated	= 0;
	$categoriesUpdated	= 0;
	$categoriesSkipped	= 0;
	$categoryAttributes	= array("title", "name", "image", "image_position", "description", "published", "access");
	$moslateAttributes	= array("language", "name", "template", "published", "access", "includes", "args", "params");
	$moslateRowById		= array();
	$categoryRowById	= array();
	$categoryRowByName	= array();
	$moslateByCategoryIdAndName	= array();
	for ($i = 0; $i < count($rowsCategories); $i++) {
		$row	=& $rowsCategories[$i];
		$categoryRowById[$row->id]		=& $row;
		$categoryRowByName[$row->name]	=& $row;
		$moslateByCategoryIdAndName[$row->id]	= array();
	}
	for ($i = 0; $i < count($rows); $i++) {
		$row	=& $rows[$i];
		if (!isset($moslateByCategoryIdAndName[$row->catid])) {
			$moslateByCategoryIdAndName[$row->catid]	= array();
		}
		$moslateByCategoryIdAndName[$row->catid][$row->name]	=& $row;
	}

	$categoryElements	= $xmlCategories->getElementsByTagName("category");
	$categoryCount		= $categoryElements->getLength();
	if ($categoryCount < 1) {
		$logger->logWarning($lang->getLangText('_MOSLATE_ERROR_IMPORT_NO_CATEGORIES', 'No categories found.', $variableMap));
		HTML_moslate::endPage();
		return false;
	}
	for ($iCategory = 0; $iCategory < $categoryCount; $iCategory++) {
		$xmlCategory	=& $categoryElements->item($iCategory);
//		$attributes	= $xmlCategory->attributes->toArray();	// not part of the lite version
		$attributes	= $xmlCategory->attributes;
		foreach(array_keys($attributes) as $key) {
			$attributes[$key]	= stripcslashes($attributes[$key]);
			if (get_magic_quotes_gpc()) {	// to make bind work properly
				$attributes[$key]	= addslashes($attributes[$key]);
			}
		}
		if (!isset($attributes['name'])) {
			continue;
		}
		$nameCategory	= $attributes['name'];
		$variableMap['category.name']	= $nameCategory;
		if ($nameCategory != '') {
			$catid	= -1;
			if (isset($categoryRowByName[$nameCategory])) {
				$catid	= $categoryRowByName[$nameCategory]->id;
				$variableMap['category.id']		= $catid;
				if ($overwrite_categories) {
					$row = new mosCategory( $database );
					$row->load($catid);
					if (!$row->bind( $attributes )) {
						$logger->logError($row->getError());
						HTML_moslate::endPage();
						exit();
					}
					if (!$row->store()) {
						$logger->logError($row->getError());
						HTML_moslate::endPage();
						exit();
					}
					$variableMap['category.id']		= $row->id;
					$logger->logInfo($lang->getLangText('_MOSLATE_INFO_IMPORT_CATEGORY_UPDATED', 'Category "${category.name}" (${category.id}) successfully updated.', $variableMap));
					$categoriesUpdated++;
				} else {
					$logger->logInfo($lang->getLangText('_MOSLATE_INFO_IMPORT_CATEGORY_ALREADY_EXISTS', 'Category "${category.name}" (${category.id}) already exists, will not be created.', $variableMap));
					$categoriesSkipped++;
				}
			} else {
				// create the category
				$row = new mosCategory( $database );
				if (!$row->bind( $attributes )) {
					$logger->logError($row->getError());
					HTML_moslate::endPage();
					exit();
				}
				$row->section	= 'com_moslate';
				if (!$row->store()) {
					$logger->logError($row->getError());
					HTML_moslate::endPage();
					exit();
				}
				$catid	= $row->id;
				$variableMap['category.id']		= $row->id;
				$logger->logInfo($lang->getLangText('_MOSLATE_INFO_IMPORT_CATEGORY_CREATED', 'Category "${category.name}" (${category.id}) successfully created.', $variableMap));
				$categoriesCreated++;
			}
			if ($catid < 0) {
				continue;
			}
			$moslateElements	= $xmlCategory->getElementsByTagName("moslate");
			$moslateCount		= $moslateElements->getLength();
			for ($iMoslate = 0; $iMoslate < $moslateCount; $iMoslate++) {
				$xmlMoslate	=& $moslateElements->item($iMoslate);
//				$attributes	= $xmlMoslate->attributes->toArray();	// not part of the lite version
				$attributes	= $xmlMoslate->attributes;
				foreach(array_keys($attributes) as $key) {
					$attributes[$key]	= stripcslashes($attributes[$key]);
					if (get_magic_quotes_gpc()) {	// to make bind work properly
						$attributes[$key]	= addslashes($attributes[$key]);
					}
				}
				if (!isset($attributes['name'])) {
					continue;
				}
				$name			= $attributes['name'];
				$variableMap['moslate.name']		= $name;
				if ($name != "") {
					if (isset($moslateByCategoryIdAndName[$catid][$name])) {
						$id	= $moslateByCategoryIdAndName[$catid][$name]->id;
						$variableMap['moslate.id']		= $id;
						if ($overwrite_moslates) {
							$row = new mosMoslate( $database );
							$row->load($id);
							unset($attributes['published']);	// always preserve publishing state
							unset($attributes['access']);		// always preserve access level
							if (!$row->bind( $attributes )) {
								$logger->logError($row->getError());
								HTML_moslate::endPage();
								exit();
							}
							if (!$row->store()) {
								$logger->logError($row->getError());
								HTML_moslate::endPage();
								exit();
							}
							$logger->logInfo($lang->getLangText('_MOSLATE_INFO_IMPORT_MOSLATE_UPDATED', 'Moslate [${category.name}] "${moslate.name}" (${moslate.id}) successfully updated.', $variableMap));
							$moslatesUpdated++;
						} else {
							$logger->logInfo($lang->getLangText('_MOSLATE_INFO_IMPORT_MOSLATE_ALREADY_EXISTS', 'Moslate [${category.name}] "${moslate.name}" (${moslate.id}) already exists, will not be created.', $variableMap));
							$moslatesSkipped++;
						}
					} else {
						// create the mosMoslate
						$row = new mosMoslate( $database );
						$row->ordering	= $iMoslate;
						if (!$row->bind( $attributes )) {
							$logger->logError($row->getError());
							HTML_moslate::endPage();
							exit();
						}
						if ($unpublish_moslates) {
							$row->published	= 0;	// unpublish imported moslate
						}
						$row->catid	= $catid;
						if (!$row->store()) {
							$logger->logError($row->getError());
							HTML_moslate::endPage();
							exit();
						}
						$variableMap['moslate.id']		= $row->id;
						$logger->logInfo($lang->getLangText('_MOSLATE_INFO_IMPORT_MOSLATE_CREATED', 'Moslate [${category.name}] "${moslate.name}" (${moslate.id}) successfully created.', $variableMap));
						$moslatesCreated++;
					}
				}
			}
		}
	}

	$variableMap['categories.created.count']	= $categoriesCreated;
	$variableMap['categories.updated.count']	= $categoriesUpdated;
	$variableMap['categories.skipped.count']	= $categoriesSkipped;
	$variableMap['moslates.created.count']		= $moslatesCreated;
	$variableMap['moslates.updated.count']		= $moslatesUpdated;
	$variableMap['moslates.skipped.count']		= $moslatesSkipped;
	$logger->logInfo('<b>'.$lang->getLangText('_MOSLATE_INFO_IMPORT_SUMMARY',
		'Summary: ${moslates.created.count} Moslates created, ${moslates.updated.count} Moslates updated, ${moslates.skipped.count} Moslates skipped.', $variableMap).'</b>');

	importMoslateFilesByNode($xmlDoc, $xmlCategories->parentNode, 'includefiles',
		$mosConfig_absolute_path.'/components/com_moslate/includes/',
		$overwrite_files);
	importMoslateFilesByNode($xmlDoc, $xmlCategories->parentNode, 'templatefiles',
		$mosConfig_absolute_path.'/components/com_moslate/templates/',
		$overwrite_files);

	HTML_moslate::endPage();

}

/**
* Export records
* @param array An array of id keys (ignored)
* @param string The current GET/POST option
*/
function exportMoslates(&$cid, $option) {
	global $database, $my, $mainframe;
	global $mosConfig_absolute_path;
	global $mosConfig_db, $mosConfig_dbprefix;

	$lists = array();

	// build list of users
	$lists['user_id'] 			= mosAdminMenus::UserSelect( 'user_id', -1, 1 );
	// build list of categories
	$lists['catid'] 			= mosAdminMenus::ComponentCategory( 'catid', 'com_moslate', intval( -1 ) );

	$lists['export_files'] 		= mosHTML::yesnoradioList( 'export_files', '', true );

	HTML_moslate::showExport( $lists, $option );
	return;
}

function getMoslateDepencyFilter($data) {
	$pattern	= '#/\*\*.*@moslate\.depency\s.*?match\s?=\s?"(.*?)".*\*/#s';
	$matches	= NULL;
	if (preg_match($pattern, $data, $matches) > 0) {
		//echo 'pattern found:'.$matches[1].'<br/>';
		return $matches[1];
	} else {
		//echo 'pattern not found:'.$pattern.'<br/>';
		return '';
	}
}

function addMoslateFilesNode(&$xmlDoc, &$xmlParent, $nodename, $basePath, &$filelist) {
	$result				= true;
	$slashesCharset		= "\0..\37!@\@\177..\377";
	$xmlGroup =& $xmlDoc->createElement($nodename);
	foreach($filelist as $fileName) {
		$fullName	= $basePath.$fileName;
		if (file_exists($fullName)) {
			$xmlNode =& $xmlDoc->createElement('file');
			$xmlNode->setAttribute('filename', addcslashes($fileName, $slashesCharset));
			$size	= filesize($fullName);
			if ($size > 0) {
				$h	= fopen($fullName, "rb");
				$v	= fread($h, $size);
				fclose($h);
				$xmlNode->setText($v);
				$filter	= getMoslateDepencyFilter($v);
				if ($filter != '') {
					$fileDir	= dirname($fileName);
					if ($fileDir != '') {
						$fileDir	.= '/';
					}
					$depencyFiles	= mosReadDirectory($basePath.$fileDir, $filter);
					sort($depencyFiles);
					foreach ($depencyFiles as $depencyFile) {
						if (!in_array($fileDir.$depencyFile, $filelist)) {
							echo 'depency to:'.$fileDir.$depencyFile.' ('.$fileName.')<br/>';
							$filelist[]	= $fileDir.$depencyFile;
						}
					}
				}
			}
			$xmlGroup->appendChild($xmlNode);
		} else {
			HTML_moslate :: printLine(htmlentities($fullName).' not found.', "red");
			$result	= false;
		}
	}
	$xmlParent->appendChild($xmlGroup);
}

function downloadExportMoslates(&$cid, $option) {
	// note: the output of the export will only visible when debugging, the user just gets the download
	global $database, $my, $mainframe;
	global $mosConfig_absolute_path, $mosConfig_live_site;
	global $mosConfig_db, $mosConfig_dbprefix;
	global $administratorAbsolutePath;

	$logger				= new mosMoslateLoggerHtml();
	$lang				= mosMoslateLang::getInstance();
	$variableMap		= array();

	HTML_moslate::beginPage(mosMoslateLang::getTitleTextAsHtml('EXPORT', 'Export Moslates (XML)'), 'dbbackup');
	HTML_moslate::showEmptyForm($option);

	$catid				= intval(mosGetParam($_POST, "catid", null));
	$user_id			= intval(mosGetParam($_POST, "user_id", null));
	$export_files		= intval(mosGetParam($_POST, "export_files", null));

	$export_files		= ($export_files == '1');

	$filePrefix			= 'moslate';

	$xmlTemplateFile	= $administratorAbsolutePath.'/components/com_moslate/res/moslate_export_template.xml';

//	include_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_include.php' );

//	$xmlDoc =& new DOMIT_Document();
	$xmlDoc =& new DOMIT_Lite_Document();
	$xmlDoc->resolveErrors( true );
	$xmlCategories	= null;
	if ($xmlDoc->loadXML( $xmlTemplateFile, false, true )) {
		$elements	= $xmlDoc->getElementsByTagName("categories");
		if ($elements->getLength() == 1) {
			$xmlCategories	=& $elements->item(0);
		}
	}

	if ($xmlCategories == null) {
		$logger->logError($lang->getLangText('_MOSLATE_ERROR_CATEGORIES_NODE_NOT_FOUND ', 'Categories-Node not found.', $variableMap));
		HTML_moslate::endPage();
		return false;
	}

	$section	= "com_moslate";
	$order		= "ordering";
	$query = "SELECT * FROM #__categories";
	if (($catid != null) && (is_numeric($catid)) && ($catid > 0)) {
		$query	.= "\n WHERE id = ". $catid;
	} else {
		$query	.= "\n WHERE section = '". $section ."'";
		$query	.= "\n ORDER BY ". $order;
		$catid	= -1;
	}
	$database->setQuery($query);
	$rowsCategories = $database->loadObjectList();
	if ($database->getErrorNum()) {
		$logger->logError(stripslashes($database->getErrorMsg()));
		HTML_moslate::endPage();
		return false;
	}

	if (($catid > 0) && (count($rowsCategories) > 0)) {
		$filePrefix	= strtolower($rowsCategories[0]->name);
	}

	$order		= "ordering";
	$query = "SELECT * FROM #__moslate";
	if (($user_id != null) && (is_numeric($user_id)) && ($user_id > 0)) {
		$query	.= "\n WHERE user_id = ". $user_id;
	}
	$query	.= "\n ORDER BY ". $order;
	$database->setQuery($query);
	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		$logger->logError(stripslashes($database->getErrorMsg()));
		HTML_moslate::endPage();
		return false;
	}

	$includeFiles		= array();
	$templateFiles		= array();

	$slashesCharset		= "\0..\37!@\@\177..\377";
	$categoryAttributes	= array("title", "name", "image", "image_position", "description", "published", "access");
	$moslateAttributes	= array("language", "name", "template", "published", "params", "access", "includes", "args", "params");
	$categoryElementById	= array();
	foreach ($rowsCategories as $row) {
		$xmlCategory =& $xmlDoc->createElement("category");
		foreach($categoryAttributes as $k) {
			if ((isset($row->$k)) && ($row->$k != '')) {
				$xmlCategory->setAttribute($k, addcslashes($row->$k, $slashesCharset));
			}
		}
		$xmlCategories->appendChild($xmlCategory);
		$categoryElementById[$row->id]	=& $xmlCategory;
	}
	foreach ($rows as $row) {
		$xmlMoslate =& $xmlDoc->createElement("moslate");
		foreach($moslateAttributes as $k) {
			if ((isset($row->$k)) && ($row->$k != '')) {
				$xmlMoslate->setAttribute($k, addcslashes($row->$k, $slashesCharset));
			}
		}
		if (isset($categoryElementById[$row->catid])) {
			// parse the template parameters
			$templateParams =& new mosParameters( $row->params );
			$mode		= intval($templateParams->get('mode', 1));
			if ($mode == 30) {
				$fileName	= trim($row->template);
				if ($fileName != '') {
					if (!in_array($fileName, $templateFiles)) {
						$templateFiles[]	= $fileName;
					}
				}
			}

			// parse the include-files
			$a				= explode("\n", $row->includes);
			foreach($a as $v) {
				$a2				= explode('|', $v);
				if (count($a2) >= 1) {
					$fileName	= trim(rawurldecode($a2[0]));
					if ($fileName != '') {
						if (!in_array($fileName, $includeFiles)) {
							$includeFiles[]	= $fileName;
						}
					}
				}
			}
			$xmlCategory =& $categoryElementById[$row->catid];
			$xmlCategory->appendChild($xmlMoslate);
		}
	}

	$result	= true;

	if ($export_files) {
		$result = $result && addMoslateFilesNode($xmlDoc, $xmlCategories->parentNode, 'includefiles',
			$mosConfig_absolute_path.'/components/com_moslate/includes/',
			$includeFiles);
		$result = $result && addMoslateFilesNode($xmlDoc, $xmlCategories->parentNode, 'templatefiles',
			$mosConfig_absolute_path.'/components/com_moslate/templates/',
			$templateFiles);
	}

	$output	= $xmlDoc->toString(false, true);
	$output	= str_replace("><", ">\n<", $output);	// we dont want all in one line

	$filename = $filePrefix."_export_".date("Ymd").".xml";

	$isDebugOutput	= false;

	if ($isDebugOutput) {
		echo "<hr/>\n";
		echo htmlentities($filename);
		echo "<hr/>\n";
		echo "<pre>\n";
		echo htmlentities($output);
		echo "</pre>\n";
		echo "<hr/>\n";

		HTML_moslate::endPage();
	} else {
		while (@ ob_end_clean());
		ob_start();
		header("Pragma: no-cache");
		header("Cache-Control: no-cache");
		header("Expires: -1");
		header("Content-Type: application/force-download");
		header("Content-Disposition: attachment; filename=$filename");
		header("Content-Length: ".strlen($output));
		echo $output;
		ob_end_flush();
		exit;
	}
}

/**
* Updates Language (Menu)
* @param string The current GET/POST option
*/
function updateLanguage($option) {
	$lang			= mosMoslateLang::getInstance();
	if ($lang->translateMoslateMenu()) {
		$msg	= $lang->getInfoTextAsHtml('LANGUAGE_UPDATED', 'Language updated.');
	} else {
		$msg	= $lang->getErrorTextAsHtml('LANGUAGE_NOT_UPDATED', 'Language could not be updated.');
	}
	mosRedirect('index2.php?option='.$option.'&task=config', $msg);
}

?>