<?php
/**
 * fn.tld implementation for Logic (for Moslate 0.3b+ (for Mambo 4.5.1))
 * @package moslate
 * @version $Id: org_apache_taglibs_standard_functions_Functions.php 208 2006-09-19 22:48:33Z  $
 * @copyright (C) 2004-2006 Daniel Ecer (de.siteof.de)
 * @license GNU/GPL

 * <b>org_apache_taglibs_standard_functions_Functions</b><br/>
 * This class implements the functions defined by fn.tld.
 *
 * */

class org_apache_taglibs_standard_functions_Functions {

	function contains($string, $substring) {
		return (strpos($string, $substring) !== FALSE);
	}

	function containsIgnoreCase($string, $substring) {
		return (stripos($string, $substring) !== FALSE);
	}

	function endsWith($string, $suffix) {
		if (strlen($suffix) > strlen($string)) {
			return false;
		}
		return (substr($string, strlen($string)-strlen($suffix)) == $suffix);
	}

	function escapeXml($string) {
//		return htmlentities($string);
		return strtr($string, array('&' => '&amp;', '<' => '&lt;', '>' => '&gt;', '\'' => '&#039;', '"' => '&#034;'));
	}

	function indexOf($string, $substring) {
		$i	= strpos($string, $substring);
		if ($i === FALSE) {
			return -1;
		}
		return $i;
	}

	function join($array, $separator) {
		return implode($separator, $array);
	}

	function length($item) {
		if (is_null($item)) {
			return 0;
		} else if (is_array($item)) {
			return count($item);
		} else if (is_object($item)) {
			if (method_exists($item, 'getLength')) {
				return $obj->getLength();
			}
			if (method_exists($item, 'getCount')) {
				return $obj->getCount();
			}
			if (method_exists($item, 'getItems')) {
				$items	= $obj->getItems();
				return count($items);
			}
			return 1;
		} else {
			return strlen(Logic::toString($item));
		}
	}

	function replace($string, $before, $after) {
		return str_replace($before, $after, $string);
	}

	function split($string, $separator) {
		return explode($separator, $string);
	}

	function startsWith($string, $prefix) {
		if (strlen($prefix) > strlen($string)) {
			return false;
		}
		return (substr($string, 0, strlen($prefix)) == $prefix);
	}

	function substring($string, $begin, $end) {
		if ($begin < 0) {
			$begin	= 0;
		}
		return substr($string, $begin, $begin+$end);
	}

	function substringAfter($string, $substring) {
		$i	= strpos($string, $substring);
		if ($i === FALSE) {
			return $string;
		}
		return substr($string, $i+strlen($substring));
	}

	function substringBefore($string, $substring) {
		$i	= strpos($string, $substring);
		if ($i === FALSE) {
			return '';
		}
		return substr($string, 0, $i);
	}

	function toLowerCase($string) {
		return strtolower($string);
	}

	function toUpperCase($string) {
		return strtoupper($string);
	}

	function trim($string) {
		return trim($string);
	}
}

?>