<?php
/**
 * Moslate post installation function.
 *
 * @package moslate
 * @version $Id: install.moslate.php 208 2006-09-19 22:48:33Z  $
 * @copyright (C) 2004-2006 Daniel Ecer (de.siteof.de)
 * @license GNU/GPL
 */

/** Ensure this file is being included by a parent file */
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

//error_reporting(E_ALL);

//require_once ($mainframe->getPath('class'));
require_once($mosConfig_absolute_path.'/components/com_moslate/moslate.class.php');
require_once('admin.moslate.class.php');
require_once('admin.moslate.html.php');

mosMoslateLang::load();

if (!DEFINED('MOSLATE_CSS_INCLUDED')) {
	// note: this may cause the admin page to not validate, which it doesn't anyway
	echo '<link href="'.$mosConfig_live_site.'/components/com_moslate/css/moslate.css" rel="stylesheet" type="text/css"/>';
}

function com_install() {
	global $database, $mosConfig_absolute_path, $mosConfig_live_site;
	global $administratorAbsolutePath, $administratorLiveSite;

	ob_start();

	$logger				= new mosMoslateLoggerHtml();
	$lang				= mosMoslateLang::getInstance();
	$variableMap		= array();

	$status	= new mosMoslateStatusManager();
	$moslateMambotStatus		= $status->getMoslateMambotStatus();
	$legacyMambotStatus			= $status->getLegacyMambotStatus();
	$legacyMoslateMambotStatus	= $status->getLegacyMoslateMambotStatus();
	if (($legacyMoslateMambotStatus == MOSLATE_STATUS_NOT_PUBLISHED) && ($legacyMambotStatus == MOSLATE_STATUS_PUBLISHED)) {
		$legacyMoslateMambotStatus	= MOSLATE_STATUS_PUBLISHED;
	}

	$menuIcons	= array(
		"option=com_moslate&task=manage" => "edit.png",
		"option=categories&section=com_moslate" => "categories.png",
		"option=com_moslate&task=config" => "config.png",
		"option=com_moslate&task=import" => "restore.png",
		"option=com_moslate&task=export" => "backup.png",
		"option=com_moslate&task=about" => "document.png");
	// Set up icons for admin area
	foreach($menuIcons as $k => $v) {
		// this is not very important, errors might be ignored
		$database->setQuery('UPDATE #__components SET admin_menu_img=\'js/ThemeOffice/'.$v.'\' WHERE admin_menu_link=\''.$k.'\'');
		$database->query();
	}
	$lang->translateMoslateMenu();

	$warningCount	= 0;

	if (($moslateMambotStatus == MOSLATE_STATUS_NOT_INSTALLED) ||
			(($moslateMambotStatus != MOSLATE_STATUS_PUBLISHED) && ($legacyMambotStatus == MOSLATE_STATUS_PUBLISHED))) {
		// install/update Legacy Moslate Mambot
		$variableMap['source']	= $administratorAbsolutePath.'/components/com_moslate/mambots/moslate_mambot.php';
		$variableMap['target']	= $mosConfig_absolute_path.'/mambots/moslate_mambot.php';
		$copyResult = @copy($variableMap['source'], $variableMap['target']);
		if (!$copyResult) {
			$logger->logWarning($lang->getErrorTextAsHtml('INSTALL_MAMBOT',
					'Failed to copy moslate_mambot.php to Mambots folder. Please copy/replace it by yourself (or try using the mambot-installer)', $variableMap));
			$warningCount++;
		} else {
			$logger->logInfo($lang->getInfoTextAsHtml('COPIED_FILE',
					'Copied ${source} to ${target}.', $variableMap));
		}
		$legacyMambotStatus			= $status->getLegacyMambotStatus();
		$legacyMoslateMambotStatus	= $status->getLegacyMoslateMambotStatus();
		if (($legacyMoslateMambotStatus == MOSLATE_STATUS_NOT_PUBLISHED) && ($legacyMambotStatus == MOSLATE_STATUS_PUBLISHED)) {
			$legacyMoslateMambotStatus	= MOSLATE_STATUS_PUBLISHED;
		}
		$variableMap['status']	= $status->getStatusText($legacyMoslateMambotStatus);
		$text	= $lang->getInfoTextAsHtml('STATUS_LEGACY_MAMBOT', 'Legacy Moslate Mambot (using Legacy Mambot Includer) is ${status}.', $variableMap);
		if ($legacyMambotStatus == MOSLATE_STATUS_NOT_INSTALLED) {
			$logger->logWarning($text);
			$warningCount++;
		} else {
			$logger->logInfo($text);
		}
		if ($legacyMambotStatus == MOSLATE_STATUS_NOT_PUBLISHED) {
			if ($status->publishLegacyMambot()) {
				$logger->logInfo($lang->getInfoTextAsHtml('LEGACY_MAMBOT_PUBLISHED', 'Legacy Mambot Includer successfully published.', $variableMap));
			} else {
				$logger->logWarning($lang->getInfoTextAsHtml('PUBLISH_LEGACY_MAMBOT', 'Failed to publish Legacy Mambot Includer.', $variableMap));
				$warningCount++;
			}
		}
	} else {
		// install/update Moslate Mambot
		$variableMap['status']	= $status->getStatusText($moslateMambotStatus);
		$logger->logInfo($lang->getInfoTextAsHtml('STATUS_MOSLATE_MAMBOT', 'Moslate Mambot is ${status}.', $variableMap));
		if ($moslateMambotStatus == MOSLATE_STATUS_NOT_PUBLISHED) {
			if ($status->publishMoslateMambot()) {
				$logger->logInfo($lang->getInfoTextAsHtml('MOSLATE_MAMBOT_PUBLISHED', 'Moslate Mambot successfully published.', $variableMap));
			} else {
				$logger->logWarning($lang->getInfoTextAsHtml('PUBLISH_MOSLATE_MAMBOT', 'Failed to publish Moslate Mambot.', $variableMap));
				$warningCount++;
			}
		}
	}

	$database->setQuery('SELECT COUNT(*) FROM `#__categories` WHERE section=\'com_moslate\'');
	$result	= $database->loadRowList();
	if (($result == null) || (!is_array($result)) || (count($result) < 1)) {
		$errorMessage	= trim($database->getErrorMsg());
		if ($errorMessage != '') {
			$logger->logError($errorMessage);
		}
	} else {
		if ($result[0][0] == 0) {
			// no category found... create default category
			$row = new mosCategory( $database );
			$row->parent_id			= 0;
			$row->title				= 'Default Category';
			$row->name				= 'default';
			$row->section			= 'com_moslate';
			$row->image_position	= 'left';
			$row->description		= '';
			$row->published			= 1;
			$row->checked_out		= 0;
			$row->access			= 0;
			$row->count				= 0;
			if (!$row->store()) {
				$logger->logError($row->getError());
			} else {
				$logger->logInfo($lang->getInfoTextAsHtml('DEFAULT_CATEGORY_CREATED', 'Default category created.'));
			}
		}
	}

	echo '<h4 class="moslate-success">'.
		$lang->getInfoTextAsHtml('INSTALL_SUCCESS', 'Moslate-Manager was successfully installed.').
		'</h4>';
	if ($warningCount > 0) {
		$variableMap['warning.count']	= $warningCount;
		$logger->logInfo($lang->getInfoTextAsHtml('INSTALL_WARNINGS', '(beside ${warning.count} minor error(s))', $variableMap));
//		echo " (beside ".$warningCount." minor error(s))<br/>";
	}
	echo '<hr/>';
	HTML_moslate::showMoslateLinks();
//	echo '<div class="moslate-links">';
//	$menuMap	= $lang->getMoslateMenuMap();
//	$first		= TRUE;
//	foreach($menuMap as $k => $v) {
//		$label	= $lang->getLangText('_MOSLATE_MENU_'.$v, $v, $variableMap);
//		if ($first) {
//			echo '<span class="moslate-links-header">'.$label.'</span><ul align="left">';
//			$first	= FALSE;
//		} else {
//			echo '<li><a href="'.$administratorLiveSite.'/index2.php?'.$k.'">'.$label.'</a></li>';
//		}
//	}
//	if (!$first) {
//		echo '</ul>';
//	}
//	echo '</div>';
	echo '<hr/>';
	include $administratorAbsolutePath.'/components/com_moslate/readme.moslate.php';
	$output = ob_get_contents();
	ob_end_clean();
	return $output;
}

?>