<?php
/**
 * This is the main class file of Moslate containing core classes.
 *
 * @package moslate
 * @version $Id: moslate.class.php 208 2006-09-19 22:48:33Z  $
 * @copyright (C) 2004-2006 Daniel Ecer (de.siteof.de)
 * @license GNU/GPL
 */

// TODO split into individual files


/** Ensure this file is being included by a parent file */
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

DEFINE('_MOSLATE_VERSION', '0.5.5');

global $Moslate_debug, $Moslate_logFile, $mosConfig_absolute_path;
$Moslate_debug		= FALSE;
$Moslate_logFile	= $mosConfig_absolute_path.'/.debug.log';


if (!function_exists('ampReplace')) {
	function ampReplace( $text ) {
		$text = str_replace( '&#', '*-*', $text );
		$text = str_replace( '&', '&amp;', $text );
		$text = str_replace( '*-*', '&#', $text );

		return $text;
	}
}


class mosMoslateLang  {

	function getInstance() {
		return new mosMoslateLang();
	}

	function getLangText($name, $defaultValue, &$variableMap) {
		global $debug;
		$name	= strtoupper($name);
		if (!defined($name)) {
//			trigger_error('Moslate: key not translated: '.$name.' (default: '.htmlentities($defaultValue).')', E_USER_NOTICE);
			if ($debug) {
				$text	= $name;
			} else {
				$text	= $defaultValue;
			}
		} else {
			$text	= constant($name);
		}
		if (is_array($variableMap)) {
			$text	= mosMoslateLang::replaceVariables($text, $variableMap);
		}
		return $text;
	}

	function getLangTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangText($name, $defaultValue, $variableMap);
		//return htmlentities(mosMoslateLang::getLangText($name, $defaultValue));
	}

	function getTitleTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_TITLE_'.$name, $defaultValue, $variableMap);
	}

	function getFieldTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_FIELD_'.$name, $defaultValue, $variableMap);
	}

	function getColumnTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_COLUMN_'.$name, $defaultValue, $variableMap);
	}

	function getToolbarTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_TOOLBAR_'.$name, $defaultValue, $variableMap);
	}

	function getHeaderTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_HEADER_'.$name, $defaultValue, $variableMap);
	}

	function getTabTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_TAB_'.$name, $defaultValue, $variableMap);
	}

	function getHintTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_HINT_'.$name, $defaultValue, $variableMap);
	}

	function getButtonTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_BUTTON_'.$name, $defaultValue, $variableMap);
	}

	function getErrorTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_ERROR_'.$name, $defaultValue, $variableMap);
	}

	function getInfoTextAsHtml($name, $defaultValue, $variableMap = null) {
		return mosMoslateLang::getLangTextAsHtml('_MOSLATE_INFO_'.$name, $defaultValue, $variableMap);
	}

	function getErrorTextAsScriptString($name, $defaultValue, $quoteChar = '\'', $variableMap = null) {
		return mosMoslateLang::toScriptString(mosMoslateLang::getLangText('_MOSLATE_ERROR_'.$name, $defaultValue, $variableMap));
	}

	function prepareParameters(&$params) {
		global $mosConfig_absolute_path;
		// i don't know why this is not a separate function in mosParameters
	    if ($params->_path) {
	        if (!is_object( $params->_xmlElem )) {
				require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_lite_include.php' );

				$xmlDoc =& new DOMIT_Lite_Document();
				$xmlDoc->resolveErrors( true );
				if ($xmlDoc->loadXML( $params->_path, false, true )) {
					$element =& $xmlDoc->documentElement;

					if ($element->getTagName() == 'mosinstall' && $element->getAttribute( "type" ) == $params->_type) {
						if ($element = &$xmlDoc->getElementsByPath( 'params', 1 )) {
							$params->_xmlElem =& $element;
						}
					}
				}
			}
		}
	}

	function translateParameters(&$params) {
		mosMoslateLang::prepareParameters($params);
	    if (is_object($params->_xmlElem )) {
			$element =& $params->_xmlElem;
			$keys	= array_keys($element->childNodes);
			foreach($keys as $key) {
				mosMoslateLang::translateParameter($element->childNodes[$key]);
			}
	    } else {
	    }
	}

	function translateParameter(&$param) {
		$name			= $param->getAttribute('name');
		if ($name == '@spacer') {
			return;
		}
		//print_r($param);
		$label			= $param->getAttribute('label');
		$description	= $param->getAttribute('description');
		$label			= mosMoslateLang::getLangTextAsHtml('_MOSLATE_FIELD_'.$name, $label);
		$label			= str_replace(' ', '&nbsp;', $label);
		$description	= mosMoslateLang::getLangTextAsHtml('_MOSLATE_DESCRIPTION_'.$name, $description);
		$param->setAttribute('label', $label);
		$param->setAttribute('description', $description);
		//echo "translated ".$name." to ".$label;
		$keys	= array_keys($param->childNodes);
		foreach($keys as $key) {
			mosMoslateLang::translateParameterElement($name, $param->childNodes[$key]);
		}
	}

	function translateParameterElement($name, &$paramElement) {
		$tagName	= $paramElement->getTagName();
		if ($tagName != 'option') {
			return;
		}
		$variableMap	= array();
		$value			= $paramElement->getAttribute('value');
		$text			= $paramElement->getText();
		$text			= mosMoslateLang::getLangText('_MOSLATE_FIELD_'.$name.'_'.$value, $text, $variableMap);
		//echo 'name:'.('_MOSLATE_FIELD_'.$name.'_'.$value).' text:'.$text;
		$paramElement->setText($text);
	}

	function toScriptString($value, $quoteChar = '\'') {
		return $quoteChar.str_replace($quoteChar, '\\'.$quoteChar, html_entity_decode($value)).$quoteChar;
	}

	function toHtml($value) {
		return htmlentities($value);
	}

	function load() {
		global $debug;
		// *** Get language files
		if (mosMoslateLang::includeLangFile('', '', '.php')) {
		} else if (mosMoslateLang::includeLangFile('english', '', '.php')) {
		} else {
			if ($debug) {
				trigger_error('Moslate: no language file found', E_USER_WARNING);
			}
		}
	}

	function includeLangFile($lang, $prefix, $suffix) {
		global $mosConfig_absolute_path, $mosConfig_lang;
		if ($lang == '') {
			$lang	= $mosConfig_lang;
		}
		$path	= $mosConfig_absolute_path.'/components/com_moslate/language/';
		if (file_exists($path.$prefix.$lang.$suffix)) {
			include_once($path.$prefix.$lang.$suffix);
			return TRUE;
		} else {
			return FALSE;
		}
	}

	function getMoslateMenuMap() {
		return array(
			"option=com_moslate" => "MOSLATES",
			"option=com_moslate&task=manage" => "MANAGER",
			"option=categories&section=com_moslate" => "CATEGORIES",
			"option=com_moslate&task=config" => "CONFIGURATION",
			"option=com_moslate&task=import" => "IMPORT",
			"option=com_moslate&task=export" => "EXPORT",
			"option=com_moslate&task=about" => "ABOUT");
	}

	function translateMoslateMenu() {
		$menuNames	= $this->getMoslateMenuMap();
		return $this->translateMenu($menuNames, '_MOSLATE_MENU_');
	}

	function translateMenu(&$MenuNamesByLink, $prefix) {
		global $database;
		$variableMap	= null;
		$errorCount	= 0;
		foreach($MenuNamesByLink as $k => $v) {
			$label	= mosMoslateLang::getLangText($prefix.$v, '', $variableMap);
			if ($label != '') {
				$quotedLabel	= '\''.addslashes($label).'\'';
				$database->setQuery('UPDATE #__components SET name='.$quotedLabel.', admin_menu_alt='.$quotedLabel.' WHERE admin_menu_link=\''.$k.'\'');
				if ($database->query() === FALSE) {
					$errorCount++;
				}
			}
		}
		return ($errorCount == 0);
	}

	function replaceVariables($message, $variableMap) {
		$startPos	= 0;
		$s			= $message;
		while(TRUE) {
			$i	= strpos($s, '$'.'{', $startPos);
			if ($i === FALSE) {
				break;
			}
			$j	= strpos($s, '}', $i + 2);
			if ($j === FALSE) {
				break;
			}
			$oldValue	= substr($s, $i + 2, $j - $i + 1 - 3);
			if (isset($variableMap[$oldValue])) {
				$newValue	= $variableMap[$oldValue];
				$s			= substr($s, 0, $i).$newValue.substr($s, $j + 1);
				$startPos	= $j + 1 + strlen($newValue) - strlen($oldValue) - 3;
			} else {
				trigger_error('variable not found:'.$oldValue, E_USER_NOTICE);
				$startPos	= $j + 1;
			}
		}
		return $s;
	}
}

class mosMoslateMenus {

	// functions copied from mosAdminMenus

	/**
	* Internal function to recursive scan the include directories
	* @param string Path to scan
	* @param string root path of this folder
	* @param array  Value array of all existing folders
	* @param array  Value array of all existing images
	*/
	function ReadIncludes( $imagePath, $folderPath, &$folders, &$images ) {
		$imgFiles = mosReadDirectory( $imagePath );

		foreach ($imgFiles as $file) {
			$ff_ 	= $folderPath . $file .'/';
			$ff 	= $folderPath . $file;
			$i_f 	= $imagePath .'/'. $file;

			if ( is_dir( $i_f ) && $file <> 'CVS' ) {
				$folders[] = mosHTML::makeOption( $ff_ );
				mosMoslateMenus::ReadIncludes( $i_f, $ff_, $folders, $images );
			} else if ( eregi( "php|inc", $file ) && is_file( $i_f ) ) {
				// leading / we don't need
				$imageFile = substr( $ff, 1 );
				$images[$folderPath][] = mosHTML::makeOption( $imageFile, $file );
			}
		}
	}

	function GetIncludeFolders( &$folders, $path ) {
		$javascript 	= "onchange=\"changeDynaList( 'includefiles', folderincludes, document.adminForm.includefolders.options[document.adminForm.includefolders.selectedIndex].value, 0, 0);\"";
		$getfolders 	= mosHTML::selectList( $folders, 'includefolders', 'class="inputbox" size="1" '. $javascript, 'value', 'text', '/' );
		return $getfolders;
	}

	function GetIncludes( &$includes, $path ) {
		if ( !isset($includes['/'] ) ) {
			$includes['/'][] = mosHTML::makeOption( '' );
		}

		$javascript	= "";
		$getimages	= mosHTML::selectList( $includes['/'], 'includefiles', 'class="inputbox" size="10" multiple="multiple" '. $javascript , 'value', 'text', null );

		return $getimages;
	}

	function GetSavedIncludes( &$row ) {
		$includes2 = array();
		foreach( $row->includes as $file ) {
			$temp = explode( '|', $file );
			if( strrchr($temp[0], '/') ) {
				$filename = substr( strrchr($temp[0], '/' ), 1 );
			} else {
				$filename = $temp[0];
			}
			$includes2[] = mosHTML::makeOption( $file, $filename );
		}
		$javascript	= 'onchange="showIncludeProps();"';
		$imagelist 	= mosHTML::selectList( $includes2, 'includelist', 'class="inputbox" size="10" '. $javascript, 'value', 'text' );

		return $imagelist;
	}

	function GetSavedArguments( &$row ) {
		$args2 = array();
		foreach( $row->args as $file ) {
			$temp = explode( '|', $file );
			if( strrchr($temp[0], '/') ) {
				$filename = substr( strrchr($temp[0], '/' ), 1 );
			} else {
				$filename = $temp[0];
			}
			$args2[] = mosHTML::makeOption( $file, $filename );
		}
		$javascript	= 'onchange="showArgumentProps();"';
		$argumentlist 	= mosHTML::selectList( $args2, 'argumentlist', 'class="inputbox" size="10" '. $javascript, 'value', 'text' );

		return $argumentlist;
	}

}

class mosMoslateConfig {
	var $_file = null;

	function mosMoslateConfig() {
		global $mosConfig_absolute_path;
		$this->_file = $mosConfig_absolute_path.'/components/com_moslate/configuration.php';
		$this->load();
	}

	function &getInstance() {
		$key	= 'mosMoslate_config';
		if (!isset($GLOBALS[$key])) {
			$GLOBALS[$key]	=& new mosMoslateConfig();
		}
		return $GLOBALS[$key];
	}

	function get($name, $defaultValue = null) {
		if (!isset($this->$name)) {
			return $defaultValue;
		}
		return $this->$name;
	}

	function set($name, $value) {
		$this->$name	= $value;
	}

	function def($name, $defaultValue) {
		if (!isset($this->$name)) {
			$this->$name	= $defaultValue;
		}
	}

	function getPropertyNames() {
		$vars	= get_object_vars($this);
		$result	= array();
		foreach ($vars as $k => $v) {
			if (($k != '') && ($k{0} != '_')) {
				$result[]	= $k;
			}
		}
		return $result;
	}

	function load() {
		if (file_exists($this->_file)) {
			include ($this->_file);
		}
	}

	function save() {
		$txt = "<"."?php\n";
		$vars = get_object_vars($this);
		foreach ($vars as $k => $v) {
			if (($k != '') && ($k{0} != '_')) {
				$txt .= "\$this->".$k." = '".addslashes($v)."';\n";
			}
		}
		$txt .= "?".">";

		if ($fp = fopen($this->_file, 'w')) {
			fputs($fp, $txt, strlen($txt));
			fclose ($fp);
			return true;
		} else {
			return false;
		}
	}
}

/**
* This class saves xml-parsing done by mosParameters anyway
*/
class mosMoslateParameters extends mosParameters {
	var $paramAttributes	= null;
	var $enableRender		= TRUE;
	function mosMoslateParameters($text, $path='', $type='component') {
		$this->mosParameters($text, $path, $type);
		$this->paramAttributes	= array();
	}
	function renderParam(&$param) {
		$this->paramAttributes[$param->getAttribute('name')]	= $param;
		if ($this->enableRender) {
			return mosParameters::renderParam($param);
		}
		return $param;
	}
/**
* @param string The name of the param
* @param mixed The default value if not found
* @return string
*/
	function get($key, $default='') {
	    if (isset($this->_params->$key)) {
	        return $this->_params->$key === null ? $default : $this->_params->$key;
		} else {
		    return $default;
		}
	}
}

/**
*
*/
class mosMoslate extends mosDBTable {
	/** @var int Primary key */
	var $id = null;
	/** @var string */
	var $language = null;
	/** @var string */
	var $name = null;
	/** @var string */
	var $template = null;
	/** @var int */
	var $published = null;
	/** @var int */
	var $checked_out = null;
	/** @var datetime */
	var $checked_out_time = null;
	/** @var int */
	var $ordering = null;
	/** @var string */
	var $includes = null;
	/** @var string */
	var $args = null;
	/** @var string */
	var $params = null;
	/** @var int A link to a registered user */
	var $user_id = null;
	/** @var int A link to a category */
	var $catid = null;
	/** @var int */
	var $access = null;

	/**
	* @param database A database connector object
	*/
	function mosMoslate(& $db) {
		$this->mosDBTable('#__moslate', 'id', $db);
	}
}

class mosMoslateGlobals {
	var $initialized	= FALSE;
	var $tagBegin;
	var $tagEnd;
	var $moslates		= NULL;
	var $mosTag;
	var $mosTagRequired	= TRUE;
	var $loadLazy		= FALSE;
	var $enabled		= TRUE;
	var $parser 		= NULL;
	var $parserStack	= array();

	function &getGlobals($create = TRUE) {
		if (!isset($GLOBALS['botMoslateGlobals'])) {
			if ($create) {
				$GLOBALS['botMoslateGlobals']	=& new mosMoslateGlobals();
			} else {
				return NULL;
			}
		}
		return $GLOBALS['botMoslateGlobals'];
	}

	/**
	 * @since version 0.5.2
	 */
	function &getMoslates() {
		global $database;

		if (!is_array($this->moslates)) {
			// get moslates from database
			$query = 'SELECT name, template, includes, args, params, access'.
				' FROM #__moslate'.
				' WHERE published = 1'.
				' ORDER BY ordering';

			$database->setQuery($query);
			$moslates = $database->loadObjectList();
			if ($database->getErrorNum()) {
				trigger_error('Moslate: failed to read moslates from database:'.stripslashes($database->getErrorMsg()), E_USER_WARNING);
				return FALSE;
			}
			$this->moslates	=& $moslates;
		}
		return $this->moslates;
	}

	function &getInitializedGlobals($published = TRUE) {
		global $mosConfig_absolute_path;

		$mosGlobals	=& mosMoslateGlobals::getGlobals();
		if ($mosGlobals->initialized) {
			if (($published) && (!$mosGlobals->enabled)) {
				$mosGlobals->enabled	= TRUE;
				if (!$mosGlobals->loadLazy) {
					$mosGlobals->getMoslates();
				}
			}
			return $mosGlobals;
		}

		$mosGlobals->initialized	= TRUE;

		$config		= mosMoslateConfig::getInstance();

		if (count($config->getPropertyNames()) == 0) {
			// the configuration file seem to be empty, reading the xml-file gives more transparent results
			// get params definitions
			$file = $mosConfig_absolute_path .'/administrator/components/com_moslate/res/moslate_config.xml';
			$params =& new mosMoslateParameters('', $file, 'component');
			$params->render();	// just to let mosParameters parse the xml-document
			$paramAttributes	= $params->paramAttributes;
			if (is_array($paramAttributes)) {
				foreach($paramAttributes as $attributes) {
					$name			= $attributes->getAttribute('name');
					$defaultValue	= $attributes->getAttribute('default');
					if (($defaultValue != null) && ($config->get($name, null) == null)) {
						$config->set($name, $defaultValue);
					}
				}
				$config->def('access_el', 2);	// not part of the .xml
				$config->save();
			}
		}

		$mosTag		= trim($config->get('mos_tag', 'moslate'));
		$tagType	= intval(trim($config->get('tag_type', '1')));
		if ($config->get('enabled', '1') != '1') {
			$published	= false;
		}
		$mosGlobals->mosTag			= $mosTag;
		$mosGlobals->mosTagRequired	= intval($config->get('mos_tag_required', 1)) == 1;
		$mosGlobals->loadLazy		= intval($config->get('load_lazy', 0)) == 1;
		$mosGlobals->enabled		= $published;
		$mosGlobals->enabledEl		= intval($config->get('enabled_el', 1));
		$mosGlobals->accessEl		= intval($config->get('access_el', 2));

		if (!$published) {
			//return $mosGlobals;
		}

		$tagBegin	= array();
		$tagEnd		= array();
		if ($tagType == 0) {
			$tagType	= 3;
		}
		if (($tagType & 1) != 0) {
				$tagBegin[]	= '<';
				$tagEnd[]	= '>';
		}
		if (($tagType & 2) != 0) {
				$tagBegin[]	= '{';
				$tagEnd[]	= '}';
		}
		if (($tagType & 4) != 0) {
				$tagBegin[]	= '[';
				$tagEnd[]	= ']';
		}

		if (!$mosGlobals->loadLazy) {
			$mosGlobals->getMoslates();
		}

		$mosGlobals->tagBegin		= $tagBegin;
		$mosGlobals->tagEnd			= $tagEnd;
		return $mosGlobals;
	}

	function &getCurrentParser() {
		return $this->parser;
	}

	function pushParser(&$parser) {
		$this->parserStack[]	=& $parser;
//		array_push($this->parserStack, &$parser);
		$this->parser	=& $parser;
	}

	function &popParser() {
		end($this->parserStack);
		$result	=& $this->nodeStack[key($this->parserStack)];
		array_pop($this->parserStack);	// array_pop does not return a reference
		if (count($this->parserStack) > 0) {
			$this->parser =& $this->parserStack[count($this->parserStack)-1];
		} else {
			$dummyParser	= NULL;
			$this->parser =& $dummyParser;
		}
		return $result;
	}

	function &getNewParser($inheritSettings = FALSE) {
		if ($inheritSettings) {
			$mosGlobals		=& mosMoslateGlobals::getGlobals();
			$previousParser	=& $mosGlobals->getCurrentParser();
		} else {
			$previousParser	= NULL;
		}
		if (is_object($previousParser)) {
			// this allows to inherit settings
			$enabled		= $previousParser->enabled;
			$tagBegin		= $previousParser->tagBegin;
			$tagEnd			= $previousParser->tagEnd;
			$mosTag			= $previousParser->mosTag;
			$mosTagRequired	= $previousParser->mosTagRequired;
			$moslates		= $previousParser->moslates;
			$enabledEl		= $previousParser->enabledEl;
			$accessEl		= $previousParser->accessEl;
			$creatorUserId	= $previousParser->creatorUserId;
			$creatorGid		= $previousParser->creatorGid;
		} else {
			$enabled		= $this->enabled;
			$tagBegin		= $this->tagBegin;
			$tagEnd			= $this->tagEnd;
			$mosTag			= $this->mosTag;
			$mosTagRequired	= $this->mosTagRequired;
			$moslates		= $this->moslates;
			$enabledEl		= $this->enabledEl;
			$accessEl		= $this->accessEl;
			$creatorUserId	= 0;
			$creatorGid		= FALSE;
		}
		$parser	=& new mosMoslateParser($enabled, $tagBegin, $tagEnd, $mosTag, $moslates, $creatorUserId, $creatorGid);
		$parser->enabledEl		= $enabledEl;
		$parser->accessEl		= $accessEl;
		$parser->mosTagRequired	= $mosTagRequired;
		return $parser;
	}
}

class mosMoslateParser {
	var $tagBegin;
	var $tagEnd;
	var $moslates;
	var $unfilteredMoslates;
	var $mosTag;
	var $mosTagRequired	= TRUE;
	var $creatorUserId;
	var $creatorGid;
	var $insideMosTag;
	var $enabled;
	var $params;
	var $enabledEl;
	var $accessEl;
	var $id;
	var $accessCount = 0;

	function mosMoslateParser($enabled, $tagBegin, $tagEnd, $mosTag, &$moslates, $creatorUserId, $creatorGid, $insideMosTag = FALSE) {
		static $idCounter = 1;
		$this->id	= $idCounter++;
		$this->enabled				= $enabled;
		$this->tagBegin				= $tagBegin;
		$this->tagEnd				= $tagEnd;
		$this->mosTag				= $mosTag;
		$this->moslates				=& $moslates;
		$this->unfilteredMoslates	=& $moslates;
		$this->creatorUserId		= $creatorUserId;
		$this->creatorGid			= $creatorGid;
		$this->insideMosTag			= $insideMosTag;
	}


	function logDebug($message) {
		global $Moslate_debug;
		if ($Moslate_debug) {
			$logger		=& mosMoslateParser::getLogger();
			$logger->logDebug($message);
		}
	}

	function &getLogger() {
		global $mosConfig_absolute_path, $Moslate_debug, $Moslate_logFile;
		if (!$Moslate_debug) {
			// PHP BUG #33679 (PHP 4.4/5.1): Notice: Only variable references should be returned by reference
			$logger	= NULL;
			return $logger;
		}
		if (!isset($GLOBALS['Moslate_Logger'])) {
			if (!class_exists('mosMoslateLogger')) {
				require_once($mosConfig_absolute_path.'/components/com_moslate/moslate.logger.class.php');
			}
//			$logger	=& new mosMoslateLoggerBuffer();
			$logger	=& new mosMoslateLoggerFile($Moslate_logFile);
			$GLOBALS['Moslate_Logger']	=& $logger;
		}
		return $GLOBALS['Moslate_Logger'];
	}

	function getId() {
		return $this->id.'['.($this->accessCount++).']';
	}

	function findTermEnd($text, $startStr, $endStr, $escapeStr = '', $startPos = 0) {
		$i	= FALSE;
		$k	= FALSE;
		while(true) {
			if (($startStr != '') && ($startStr != $endStr)) {
				$i = strpos($text, $startStr, $startPos);
			}
			$j = strpos($text, $endStr, $startPos);
			if ($escapeStr != '') {
				$k = strpos($text, $escapeStr, $startPos);
			}
			if ($j === FALSE) {
				return FALSE;
			}
			if (($k !== FALSE) && (($k <= $j) || (($i !== FALSE) && ($k < $i)))) {
				$startPos	= $k + strlen($escapeStr);
				continue;
			}
			if (($i !== FALSE) && ($i <= $j)) {
				$startPos	= mosMoslateParser::findTermEnd($text, $startStr, $endStr, $escapeStr, $i + strlen($startStr));
				if ($startPos === FALSE) {
					return FALSE;
				}
				$startPos	+= strlen($endStr);
				continue;
			}
			return $j;
		}
	}

	function findTermEndSkipQuotes($text, $startStr, $endStr, $escapeStr = '', $startPos = 0, $skipHtmlQuote = FALSE) {
		while(true) {
			$i = mosMoslateParser::findTermEnd($text, $startStr, $endStr, $escapeStr, $startPos);
			if ($i !== FALSE) {
				$j	= strpos($text, '\'', $startPos);
				$k	= strpos($text, "\"", $startPos);
				if (($k !== FALSE) && (($j === FALSE) || ($k < $j))) {
					$j	= $k;
				}
				if ($skipHtmlQuote) {
					$k	= strpos($text, '&quot;', $startPos);
					if (($k !== FALSE) && (($j === FALSE) || ($k < $j))) {
						$j	= $k;
					}
				}
				if (($j === FALSE) || ($j > $i)) {
					return $i;
				}
				$quoteChar	= $text{$j};
				if ($quoteChar == '&') {
					$quoteChar	= '&quot;';
				}
				$startPos	= mosMoslateParser::findTermEnd($text, $quoteChar, $quoteChar, '\\'.$quoteChar, $j+strlen($quoteChar));
				if ($startPos === FALSE) {
					return FALSE;
				}
				$startPos	+= strlen($quoteChar);
				continue;
			}
			return $i;
		}
	}

	function skipChars($text, $chars, $startPos = 0) {
		$len	= strlen($text);
		while($startPos < $len) {
			if (strpos($chars, $text{$startPos}) === FALSE) {
				return $startPos;
			}
			$startPos++;
		}
		return $startPos;
	}

	function skipWhiteSpaces(&$text, $startPos = 0) {
		return mosMoslateParser::skipChars($text, " \t\r\n", $startPos);
	}

	/**
	 * @since version 0.5.2
	 */
	function &getMoslates() {
		if (!is_array($this->moslates)) {
			$mosGlobals	=& mosMoslateGlobals::getGlobals();
			$moslates	=& $mosGlobals->getMoslates();
			$this->moslates				=& $moslates;
			$this->unfilteredMoslates	=& $moslates;
			if ($this->creatorGid !== FALSE) {
				$this->setCreatorGid($this->creatorGid);
			}
		}
		return $this->moslates;
	}

	function parse($text, $triggerMoslates = FALSE) {
		global $mosConfig_absolute_path;
		if (($text == '') && (!$triggerMoslates)) {
			return $text;
		}
		$mosTag	= ($this->insideMosTag ? '' : $this->mosTag);
		if ((!$this->mosTagRequired) && ($mosTag != '')) {
			if (strpos($text, '{'.$mosTag.'}') === FALSE) {
				$mosTag	= '';	// pretend we don't have a mos tag
			}
		}

		if ($mosTag != '') {
			// parse content for the main moslate-tag (e.g. {moslate}...{/moslate})
			$this->insideMosTag = TRUE;
			$mosTagOpen		= '{'.$mosTag.'}';
			$mosTagClose	= '{/'.$mosTag.'}';
			$startPos		= 0;
			while(TRUE) {
				$i	= strpos($text, $mosTagOpen, $startPos);
				if ($i === FALSE) {
					break;
				}
				$startPos	= $i + strlen($mosTagOpen);
				$j	= mosMoslateParser::findTermEnd($text, $mosTagOpen, $mosTagClose, '', $startPos);
				if ($j === FALSE) {
					break;
				}
				$startPos	= $j + strlen($mosTagClose);
				if ($this->enabled) {
					$previousInnerLength	= $j - $i - strlen($mosTagOpen);
					$inner		= $this->parse(substr($text, $i + strlen($mosTagOpen), $previousInnerLength), TRUE);
					$text		= substr($text, 0, $i).$inner.substr($text, $j + strlen($mosTagClose));
					$startPos	= $i + strlen($inner);
				} else {
					// strip the moslate-tag
					$text		= substr($text, 0, $i).
						substr($text, $i + strlen($mosTagOpen), $j - $i - strlen($mosTagOpen)).
						substr($text, $j + strlen($mosTagClose));
					$startPos	= $j - strlen($mosTagOpen) - strlen($mosTagClose);
				}
			}
			$this->insideMosTag = FALSE;
			return $text;
		}

		// parse the text

		$moslates		=& $this->getMoslates();

		$prefixArray	= $this->tagBegin;
		$suffixArray	= $this->tagEnd;

		$mosTag			= $this->mosTag;

		$startPos		= 0;

		$whitespaces	= " \t\r\n";

		$nullValue		= NULL;

		$moslateKeys	= array_keys($moslates);

		while(TRUE) {
			// i is in use until end of while-loop
			$prefix = $suffix	= '';
			$i	= FALSE;
			// find tags by prefix first
			for ($iPrefix = 0; $iPrefix < count($prefixArray); $iPrefix++) {
				$pos	= strpos($text, $prefixArray[$iPrefix], $startPos);
				if (($pos !== FALSE) && (($i === FALSE) || ($pos < $i))) {
					$prefix	= $prefixArray[$iPrefix];
					$suffix	= $suffixArray[$iPrefix];
					$i	= $pos;
				}
			}

			if ($i === FALSE) {
				break;	// not found anymore
			}

			$name	= '';
			$moslate	=& $nullValue;
			foreach($moslateKeys as $k) {
				$moslate2	=& $moslates[$k];
				$name2		= trim($moslate2->name);
				if ($name2 == '') {
					continue;
				}
				if (substr($text, $i+1, strlen($name2)) != $name2) {
					continue;
				}

				$paramsStartPos = $i+1+strlen($name2);
				if ((substr($text, $paramsStartPos, strlen($suffix)) != $suffix) &&
					(substr($text, $paramsStartPos, strlen($suffix)+1) != '/'.$suffix) &&
					(strpos(" \t\r\n/", substr($text, $paramsStartPos, 1)) === FALSE)) {
					continue;	// the name was the beginning but not the whole word (tag)
				}
				$j				= mosMoslateParser::findTermEndSkipQuotes($text, $prefix, $suffix, '', $paramsStartPos, TRUE);
				if ($j === FALSE) {
					continue;
				}
				$parameters	= substr($text, $i+1+strlen($name2), $j-$i-1-strlen($name2));
				$name		= $name2;
				$moslate	=& $moslate2;
				break;
			}
			if ($name == '') {
				$startPos	= $i+1;
				continue;
			}
			$startPos	= $i;

			// parse tag parameters
			$parameters = trim($parameters);
			$isEndTag	= ((strlen($parameters) > 0) && ($parameters{strlen($parameters)-1} == '/'));
			if ($isEndTag) {
				$parameters	= trim(substr($parameters, 0, strlen($parameters)-1));
			}
			if ((substr($parameters, 0, 1) == "\"") || (strpos($parameters, '=') === FALSE)) {
				if ((substr($parameters, 0, 1) == "\"") && ($parameters{strlen($parameters)-1} == "\"")) {
					$parameters	= substr($parameters, 1, strlen($parameters)-2);
				}
				$params	= array();
				$parameters	= trim($parameters);
				if ($parameters != '') {
					$params['param']	= $parameters;
				}
			} else {
				$params	= array();
				while(TRUE) {
					$k	= strpos($parameters, '=');
					if ($k === FALSE) {
						break;
					}
					$paramName	= trim(substr($parameters, 0, $k));
					$parameters	= trim(substr($parameters, $k+1));
					$quoteChar	= '';
					if (($parameters{0} == '"') || ($parameters{0} == '\'')) {
						$quoteChar	= $parameters{0};
						$k	= mosMoslateParser::findTermEnd($parameters, $quoteChar, $quoteChar, '\\'.$quoteChar, 1);
					} else if (substr($parameters, 0, 6) == '&quot;') {
						$quoteChar	= '&quot;';
						$k	= mosMoslateParser::findTermEnd($parameters, $quoteChar, $quoteChar, '\\'.$quoteChar, 1);
						if ($k !== FALSE) {
							$k	+= strlen($quoteChar) - 1;
						}
					} else {
						$k	= strpos($parameters, ' ');
						if ($k !== FALSE) {
							$k--;
						}
					}
					if ($k === FALSE) {
						$value	= $parameters;
						$parameters	= '';
					} else {
						$value	= trim(substr($parameters, 0, $k+1));
						$parameters	= trim(substr($parameters, $k+1));
						if (substr($value, 0, 6) == '&quot;') {
							$value	= html_entity_decode($value);
						}
					}
					if ($paramName != '') {
						$params[$paramName]	= $value;
					}
				}
				$keys	= array_keys($params);
				foreach($keys as $key) {
					$value	= $params[$key];
					$quoteChar	= $value{0};
					if ((($quoteChar == "\"") || ($quoteChar == '\'')) && ($value{strlen($value)-1} == $quoteChar)) {
						$value	= stripslashes(substr($value, 1, strlen($value)-2));
					}
					$params[$key]	= $value;
				}
			}

			// it's time to parse the template parameters
			if (!isset($moslate->paramsObj)) {
				$moslate->paramsObj =& new mosParameters($moslate->params);
			}
			$templateParams =& $moslate->paramsObj;
			$dataVar	= trim($templateParams->get('data_var', ''));
			$mode		= intval($templateParams->get('mode', 1));
			$activation	= intval($templateParams->get('activation', 10));

			$data	= '';
			// now try to find the closing tag if necessary
			if ($dataVar != '') {
				if ($isEndTag) {	// the tag was already closed
				} else {
					$tagDepth	= 1;
					$startPos2	= $j+1;
					while(true) {
						$s	= $prefix.'/'.$name.$suffix;
						$s2	= $prefix.$name;
						$k	= strpos($text, $s, $startPos2);

						if ($k === FALSE) {
							break;
						} else {
							$l = strpos($text, $s2, $startPos2);
							if (($l !== FALSE) && ($l < $k)) {
								// there is a embedded moslate (the found closing tag is not ours)
								if ($tagDepth >= 0) {
									$tagDepth++;
								}
								$startPos2	= $l + strlen($s2);
							} else {
								$tagDepth--;
								if ($tagDepth <= 0) {
									$data	= substr($text, $j+1, $k-$j-1);
									$j	= $k+strlen($s)-1;	// we don't want to past the data / end-tag
									break;
								} else {
									$startPos2	= $k+strlen($s);
								}
							}
						}
					}
				}
			}

			if ($activation == 10) {
				$output	= $this->callMoslate($moslate, $params, $data);
			}

			// change/insert the new content
			$text		= substr($text, 0, $i).$output.substr($text, $j+1);
			$startPos	= $i + strlen($output);
		}	// while

		if ($triggerMoslates) {
			// activation: Mos-Tag
			foreach ($moslateKeys as $k) {
				$moslate	=& $moslates[$k];
				if (strpos($moslate->params, 'activation=20') !== FALSE) {
					$params		= array();
					$text		= $this->callMoslate($moslate, $params, $text);
				}
			}
		}

//		if ($mosTag != '') {
//			// define replacements (should be changed later - nested {moslate}-tag is not supported yet
//			$text	= str_replace('{!'.$mosTag, '{'.$mosTag, $text);
//			$text	= str_replace('{!/'.$mosTag, '{/'.$mosTag, $text);
//		}
		return $text;
	}

	function toPHPVariableMap(&$a) {
		$keys	= array_keys($a);
		foreach($keys as $key) {
			$i = strpos($key, '-');
			if ($i !== FALSE) {
				$oldKey	= $key;
				while($i !== FALSE) {
					$key	= substr($key, 0, $i).strtoupper(substr($key, $i+1, 1)).substr($key, $i+2);
					$i = strpos($key, '-');
				}
				$a[$key]	=& $a[$oldKey];
				unset($a[$oldKey]);
			}
		}
	}

	function evalPHP( $_phpcode, $_params, $_includes, $_args ) {
		global $mosConfig_absolute_path;
//		$_parser	=& $this;	// this fails with PHP5.1 (200505171830) - "Cannot re-assign $this"
		$this->toPHPVariableMap($_params);
		$this->toPHPVariableMap($_args);
		extract($_params, EXTR_SKIP);
		extract($_args, EXTR_SKIP);
//		foreach($_args as $paramName => $paramValue) {
//			$$paramName	= $paramValue;
//		}
		foreach($_includes as $f) {
			$_fileName	= $mosConfig_absolute_path.'/components/com_moslate/includes/'.$f;
			if (file_exists($_fileName)) {
				include_once($_fileName);
			} else {
				trigger_error('Moslate: file not found:'.$_fileName, E_USER_WARNING);
			}
		}
//		foreach($_params as $paramName => $paramValue) {
//			unset($$paramName);
//			$$paramName	= $paramValue;
//		}
		ob_start();
		eval($_phpcode);
		$result	= ob_get_contents();
		ob_end_clean();
		return $result;
	}

	function evalPHPReturnOutput( $_phpcode, $_params, $_includes, $_args ) {
		global $mosConfig_absolute_path;
//		$_parser	=& $this;	// this fails with PHP5.1 (200505171830) - "Cannot re-assign $this"
		$this->toPHPVariableMap($_params);
		$this->toPHPVariableMap($_args);
		extract($_params, EXTR_SKIP);
		extract($_args, EXTR_SKIP);
//		foreach($_args as $paramName => $paramValue) {
//			$$paramName	= $paramValue;
//		}
		foreach($_includes as $f) {
			$_fileName	= $mosConfig_absolute_path.'/components/com_moslate/includes/'.$f;
			if (file_exists($_fileName)) {
				include_once($_fileName);
			} else {
				trigger_error('Moslate: file not found:'.$_fileName, E_USER_WARNING);
			}
		}
//		foreach($_params as $paramName => $paramValue) {
//			unset($$paramName);
//			$$paramName	= $paramValue;
//		}
		$result	= ''.eval($_phpcode);
		return $result;
	}

	function includePHP( $_fileName, $_params, $_includes, $_args ) {
		global $mosConfig_absolute_path;
//		$_parser	=& $this;	// this fails with PHP5.1 (200505171830) - "Cannot re-assign $this"
		$this->toPHPVariableMap($_params);
		$this->toPHPVariableMap($_args);
		extract($_params, EXTR_SKIP);
		extract($_args, EXTR_SKIP);
//		foreach($_args as $paramName => $paramValue) {
//			$$paramName	= $paramValue;
//		}
		foreach($_includes as $f) {
			$_fileName	= $mosConfig_absolute_path.'/components/com_moslate/includes/'.$f;
			if (file_exists($_fileName)) {
				include_once($_fileName);
			} else {
				trigger_error('Moslate: file not found:'.$_fileName, E_USER_WARNING);
			}
		}
//		foreach($_params as $paramName => $paramValue) {
//			$$paramName	= $paramValue;
//		}
		ob_start();
		include($_fileName);
		$result	= ob_get_contents();
		ob_end_clean();
		return $result;
	}

	function callPHPFunction( $_functionName, $_params, $_includes, $_args ) {
		global $mosConfig_absolute_path;
		foreach($_includes as $f) {
			$_fileName	= $mosConfig_absolute_path.'/components/com_moslate/includes/'.$f;
			if (file_exists($_fileName)) {
				include_once($_fileName);
			} else {
				trigger_error('Moslate: file not found:'.$_fileName, E_USER_WARNING);
			}
		}
		$i	= strpos($_functionName, '::');
		if ($i !== FALSE) {
			$_className		= substr($_functionName, 0, $i);
			$_functionName	= substr($_functionName, $i + 2);
		} else {
			$_className		= '';
		}
		$result			= '';
		$parameterMap	= array_merge($_args, $_params);
		if ($_className != '') {
			if (!class_exists($_className)) {
				trigger_error('Moslate: class does not exist: '.$_className, E_USER_WARNING);
			} else {
				$f	= array($_className, $_functionName);
				if (!is_callable($f)) {
					trigger_error('Moslate: function does not exist: '.$_className.'::'.$_functionName, E_USER_WARNING);
					return $result;
				}
				$result	= call_user_func($f, $parameterMap);
			}
		} else {
			if (!function_exists($_functionName)) {
				trigger_error('Moslate: function does not exist: '.$_functionName, E_USER_WARNING);
			} else {
				$result	= call_user_func($f, $parameterMap);
			}
		}
		return ''.$result;
	}

	function callMoslate(&$moslate, &$params, $data) {
		global $mosConfig_absolute_path;
		static $functionContext;
		static $logicIncluded	= FALSE;

		$this->logDebug('callMoslate: name='.$moslate->name);

		if (!isset($moslate->paramsObj)) {
			$moslate->paramsObj =& new mosMoslateParameters($moslate->params);
		}
		$templateParams 	=& $moslate->paramsObj;
		$dataVar			= trim($templateParams->get('data_var', ''));
		$activation			= intval($templateParams->get('activation', 10));
		$mode				= intval($templateParams->get('mode', 1));
		$trimData			= intval($templateParams->get('trim_data', 1)) == 1;
		$evalParameters		= intval($templateParams->get('eval_parameters', 1)) == 1;
		$evalData			= intval($templateParams->get('eval_data', 0)) == 1;
		$evalOutput			= intval($templateParams->get('eval_output', 1)) == 1;
		$moslateContext		= intval($templateParams->get('moslate_context', 0)) == 1;
		$useLogic			= intval($templateParams->get('use_logic', 0)) == 1;
		$logicScope			= intval($templateParams->get('logic_scope', 1)) == 1;
		$evalParametersEl	= intval($templateParams->get('eval_parameters_el', 1)) == 1;
		$evalDataEl			= intval($templateParams->get('eval_data_el', 0)) == 1;
		$logicVars			= intval($templateParams->get('logic_vars', 0)) == 1;
		$asString			= intval($templateParams->get('as_string', 0)) == 1;
		if ($activation != 10) {
			$evalData	= FALSE;
			$evalOutput	= FALSE;
		}
		if ((!$this->enabledEl) || ($this->accessEl > $this->creatorGid)) {
			$evalParametersEl	= FALSE;
			$evalDataEl			= FALSE;
		}
		if (($evalData) && ($data != null)) {
			$data	= $this->parse($data);
		}
		if (($mode == 10) || ($mode == 11)) {
			// in "Replace Parameters" mode we need a string
			$asString			= TRUE;
		}
		if (($trimData) && ($data != null)) {
			$data	= trim($data);
		}
		if ((!$useLogic) && ($evalParametersEl) && (!$logicIncluded)) {
			foreach($params as $param) {
				if (strpos($param, '${') !== FALSE) {
					$useLogic	= TRUE;
					break;
				}
			}
			if (!$useLogic) {
				$evalParametersEl	= FALSE;	// optimize
			}
		}
		if ((!$useLogic) && ($evalDataEl) && (!$logicIncluded)) {
			if (strpos($data, '${') !== FALSE) {
				$useLogic	= TRUE;
			} else {
				$evalDataEl	= FALSE;	// optimize
			}
		}
		if (($logicVars) || ($evalParametersEl) || ($evalDataEl)) {
			$useLogic	= TRUE;
		}
		if (($useLogic) && (!$logicIncluded)) {
			$logicIncluded	= TRUE;
			require_once($mosConfig_absolute_path.'/components/com_moslate/includes/logic/logic.php');
		}
		if (!$logicIncluded) {
			$logicScope	= FALSE;
		}
		if (($useLogic) && ($evalParametersEl)) {
			foreach(array_keys($params) as $paramName) {
				if (($asString) && (!$logicVars)) {
					$params[$paramName]		= Logic::evalELAsString($params[$paramName]);
				} else {
					$params[$paramName]		=& Logic::evalEL($params[$paramName]);
				}
			}
		}
		if (($useLogic) && ($evalDataEl)) {
			if (($asString) && (!$logicVars)) {
				$data		= Logic::evalELAsString($data);
			} else {
				$data		=& Logic::evalEL($data);
			}
		}
		if ($dataVar != '') {
			if ((is_object($data)) || (is_array($data))) {
				$params[$dataVar]	=& $data;
			} else {
				$params[$dataVar]	= $data;
			}
		}

		// parse the include-files
		$includeFiles	= array();
		$a				= explode("\n", $moslate->includes);
		foreach($a as $v) {
			$a2				= explode('|', $v);
			if (count($a2) >= 1) {
				$fileName	= trim(rawurldecode($a2[0]));
				if ($fileName != '') {
					$includeFiles[]	= $fileName;
				}
			}
		}

		// parse the template arguments
		$templateArgs	= array();
		$a				= explode("\n", $moslate->args);
		foreach($a as $v) {
			$a2				= explode('|', $v);
			if (count($a2) >= 1) {
				$argName	= trim(rawurldecode($a2[0]));
				if ($argName != '') {
					$templateArgs[$argName] = (count($a2) >= 2 ? rawurldecode($a2[1]) : '');
				}
			}
		}

		if ($moslateContext) {
			$newFunctionContext	= array();
			foreach($templateArgs as $paramName => $paramValue) {
				$newFunctionContext[$paramName]	= $paramValue;
			}
			foreach($params as $paramName => $paramValue) {
				$newFunctionContext[$paramName]	= $paramValue;
			}
			$newFunctionContext['parentContext']	= $functionContext;
			$functionContext	= $newFunctionContext;
		}

		if ($logicScope) {
			Logic::beginScope();
		}

		if ($logicVars) {
			$scopeName	= 'pageScope';
			foreach(array_keys($params) as $paramName) {
				Logic::set($scopeName, $paramName, $params[$paramName]);
			}
			if (($asString) && (($evalParametersEl) || ($evalDataEl))) {
				foreach(array_keys($params) as $paramName) {
					$params[$paramName]	= Logic::toString($params[$paramName]);
				}
			}
		}

		$templateArgs['moslateContext']	= $functionContext;

		// set current output to the template-content
		$output		= $moslate->template;

		// apply moslate-code
		switch($mode) {
			case 10:	// Replace Parameters (PHP like)
				foreach($params as $paramName => $paramValue) {
					$output	= str_replace("\$".$paramName, $paramValue, $output);
				}
				foreach($templateArgs as $paramName => $paramValue) {
					if (!isset($params[$paramName])) {
						$output	= str_replace("\$".$paramName, $paramValue, $output);
					}
				}
				break;
			case 11:	// Replace Parameters (EL like)
				foreach($params as $paramName => $paramValue) {
					$output	= str_replace("\${".$paramName."}", $paramValue, $output);
				}
				foreach($templateArgs as $paramName => $paramValue) {
					if (!isset($params[$paramName])) {
						$output	= str_replace("\${".$paramName."}", $paramValue, $output);
					}
				}
				break;
			case 20:	// Eval PHP
				$output	= $this->evalPHP($output, $params, $includeFiles, $templateArgs);
				break;
			case 21:	// Eval PHP (Return Output)
				$output	= $this->evalPHPReturnOutput($output, $params, $includeFiles, $templateArgs);
				break;
			case 30:	// Include PHP
				$fileName	= trim($output);
				if ($fileName == '') {
					$fileName	= $moslate->name.'.php';
				}
				if ((strpos($fileName, ':') === FALSE) &&
					(substr($fileName, 0, 1) != '/') && (substr($fileName, 0, 1) != '\'') && (substr($fileName, 0, 1) != '.')) {
					$fileName	= $mosConfig_absolute_path.'/components/com_moslate/templates/'.$fileName;
				}
				if (!file_exists($fileName)) {
					trigger_error('Moslate: file not found:'.$fileName, E_USER_WARNING);
					$output	= '';
				} else {
					$output	= $this->includePHP($fileName, $params, $includeFiles, $templateArgs);
				}
				break;
			case 40:	// Call Function
				$output	= $this->callPHPFunction(trim($output), $params, $includeFiles, $templateArgs);
				break;
			default:	// Ignore Parameters
		}

		if ($evalOutput) {
			$output	= $this->parse($output);
		}

		if ($logicScope) {
			Logic::endScope();
		}

		if ($moslateContext) {
			$functionContext	= $functionContext['parentContext'];
		}

		$this->logDebug('callMoslate: end name='.$moslate->name);

		return $output;
	}

	/**
	* Replaces the matched tags (this function is actually obsolete)
	* @param array An array of matches (see preg_match_all)
	* @return string
	*/
	function replaceCallback( &$matches ) {
		return $this->parse($matches[1]);
	}

	function getGidByUser($userId) {
		global $acl;
		// gid-calculation taken from mosMainFrame::login
		// fudge the group stuff
		$grp = $acl->getAroGroup($userId);
		if (!is_object($grp)) {
			return 0;
		}
		if ($acl->is_group_child_of($grp->name, 'Registered', 'ARO') ||
			$acl->is_group_child_of($grp->name, 'Administrator', 'ARO')) {
			// fudge Authors, Editors, Publishers and Super Administrators into the Special Group
			return 2;
		}
		return 1;
	}

	function setCreatorUserId($userId) {
		$this->creatorUserId	= $userId;
		$this->setCreatorGid($this->getGidByUser($userId));
	}

	function setCreatorGid($gid) {
		$this->creatorGid		= $gid;
		if (($gid >= 0) && (is_array($this->unfilteredMoslates))) {
			$moslates				=& $this->unfilteredMoslates;
			$filteredMoslates		= array();

			foreach(array_keys($moslates) as $k) {
				$moslate	=& $moslates[$k];
				if ($moslate->access <= $gid) {
					array_push($filteredMoslates, $moslate);
				}
			}
			$this->moslates			=& $filteredMoslates;
		}
	}

	function processContent(&$row) {
		if (!$this->enabled) {
			if ($this->mosTag != '') {
				$row->text = $this->parse($row->text);
			}
			return;
		}

		$mosGlobals	=& mosMoslateGlobals::getGlobals();

		if (isset($row->created_by)) {
			$this->setCreatorUserId($row->created_by);
		} else {
			$this->setCreatorGid(1);	// since 4.5.3 we are called for sections for example as well... assume registered
		}

		$mosGlobals->pushParser($this);

		$row->text	= $this->parse($row->text);

		$parserParams		=& $this->params;

		if ($parserParams != NULL) {
			$isIntroText	= $parserParams->get('intro_only');
		} else {
			$isIntroText	= FALSE;
		}
		$isFullText	= !$isIntroText;

		// activation: Every Content, Intro Text, Full Text
		if (is_array($this->moslates)) {
			$moslates	=& 	$this->moslates;
			foreach(array_keys($moslates) as $k) {
				$moslate	=& $moslates[$k];
				if ((strpos($moslate->params, 'activation=30') !== FALSE) ||
					(($isIntroText) && (strpos($moslate->params, 'activation=31') !== FALSE)) ||
					(($isFullText) && (strpos($moslate->params, 'activation=32') !== FALSE))) {
					$params		= array();
					$row->text	= $this->callMoslate($moslate, $params, ''.$row->text);
				}
			}
		}

		$mosGlobals->popParser();

		return TRUE;
	}
}

class mosMoslateMambot {


	function botMoslateWithoutParams(&$row) {
		$params = null;
		mosMoslateMambot::botMoslate(TRUE, $row, $params, 0);
	}

	/**
	* Moslate  Mambot
	*
	* <b>(default) Usage:</b> <code>{moslate}...{/moslate}</code>
	*/
	function botMoslate($published, &$row, &$params, $page=0) {
		$result	= mosMoslateAPI::processContentWithParameters($row, $params, $published, FALSE);
		return $result;
	}

	/**
	 * for compatibility
	 * @see mosMoslateAPI::parse
	 * @return string
	 * @deprecated
	 */
	function parse($text) {
		return mosMoslateAPI::parse($text);
	}

	/**
	 * for compatibility
	 * @see mosMoslateAPI::getCreatorGid
	 * @return int
	 * @deprecated
	 */
	function getGidCreator() {
		return mosMoslateAPI::getCreatorGid();
	}

}

/**
 * this class is intended to provide (static) utility functions which are not directly relevant for Moslate
 * @since version - 0.5
 */
class mosMoslateUtil {
	/**
	 * returns a quoted string you could use inside a query
	 * (this is a function provided for compatibility with Mambo 4.5.1)
	 * @see database::quote
	 * @return string
	 */
	function dbQuote(&$database, $text) {
		if (method_exists($database, 'quote')) {
			return $database->quote($text);
		} else {
			return '\''.mysql_escape_string($text).'\'';
		}
	}

	function saveArrayValues(&$array, $keys) {
		$result	= array();
		foreach($keys as $k) {
			if (isset($array[$k])) {
				if ((is_object($array[$k])) || (is_array($array[$k]))) {
					$result[$k]	=& $array[$k];
				} else {
					$result[$k]	= $array[$k];
				}
			} else {
				$result[$k]	= NULL;
			}
		}
		return $result;
	}

	function restoreArrayValues(&$array, $savedArray) {
		foreach(array_keys($savedArray) as $k) {
			if (is_null($savedArray[$k])) {
				unset($array[$k]);
			} else {
				if ((is_object($savedArray[$k])) || (is_array($savedArray[$k]))) {
					$array[$k]	=& $savedArray[$k];
				} else {
					$array[$k]	= $savedArray[$k];
				}
			}
		}
	}

	/**
	 * returns an array of contents matching the parameters
	 * @return array
	 */
	function &getContentArray($id = 0, $titleAlias = '', $onlyPublished = FALSE, $allowFromOtherUser = FALSE, $reduceToOwnedIfNotEmpty = TRUE) {
		global $database;
		$userId	= mosMoslateAPI::getCreatorUserId();
		$wheres = array();
		if ($id != '') {
			$wheres[] = 'id = '.intval($id);
		}
		if ($titleAlias != '') {
			$wheres[] = 'title_alias = '.mosMoslateUtil::dbQuote($database, $titleAlias);
		}
		if ($onlyPublished) {
			$wheres[] = 'published = 1';
		}
		if (!$allowFromOtherUser) {
			$wheres[] = 'created_by = '.intval($userId);
		}
		$query = 'SELECT *'.
			' FROM #__content'.
			' WHERE '.implode(' AND ', $wheres);
		$database->setQuery($query);
		$contents	= $database->loadObjectList();
		if (!is_array($contents)) {
			$contents	= array();
		}
		if ((count($contents) > 1) && ($allowFromOtherUser) && ($reduceToOwnedIfNotEmpty)) {
			$userId	= mosMoslateAPI::getCreatorUserId();
			$contents2	= array();
			foreach (array_keys($contents) as $key) {
				$content	=& $contents[$key];
				if ($content->created_by == $userId) {
					array_push($contents2, $content);
				}
			}
			if (count($contents2) > 0) {
				$contents	=& $contents2;
			}
		}
		return $contents;
	}

	/**
	 * returns the content matching the parameters, none if more than one were found
	 * @return content
	 */
	function &getContent($id = 0, $titleAlias = '', $onlyPublished = FALSE, $allowFromOtherUser = FALSE) {
		$contents	=& mosMoslateUtil::getContentArray($id, $titleAlias, $onlyPublished, $allowFromOtherUser, TRUE);
		if (count($contents) == 1) {
			return $contents[0];
		} else {
			$nullValue	= NULL;
			return $nullValue;
		}
	}

	/**
	 * returns the first content matching the parameters
	 * @return content
	 */
	function &getFirstContent($id = 0, $titleAlias = '', $onlyPublished = FALSE, $allowFromOtherUser = FALSE) {
		$contents	=& mosMoslateUtil::getContentArray($id, $titleAlias, $onlyPublished, $allowFromOtherUser, TRUE);
		if (count($contents) > 0) {
			return $contents[0];
		} else {
			return NULL;
		}
	}

	function getItemIdByContentId($id) {
		global $database, $Itemid, $mainframe;
		return $mainframe->getItemid($id);
//		// try to find a menu link
//		$query = 'SELECT *'.
//			' FROM #__menu'.
//			' WHERE type = \'content_item_link\' AND published=1 AND link = '.
//			mosMoslateAPI::dbQuote($database, $link);
//		$database->setQuery($query);
//		$menus = $database->loadObjectList();
//		if ((is_array($menus)) && (count($menus) == 1)) {
//			return $menus[0]->id;
//		} else {
//			return $mainframe->getItemid($id);
//		}
	}

	/**
	 * returns the a link for the content-id
	 * @return string
	 */
	function getContentLinkById($id, $resolveMenuLink = TRUE) {
		global $database, $Itemid;
		$id		= intval($id);
		$link	= 'index.php?option=com_content&task=view&id='.$id;
		if ($resolveMenuLink) {
			$link	.= '&Itemid='.mosMoslateUtil::getItemIdByContentId($id);
		}
		$link = ampReplace($link);
		$link = sefRelToAbs($link);
		return $link;
	}

	/**
	 * returns the a linke for the content
	 * @return string
	 */
	function getContentLinkByContent(&$content, $resolveMenuLink = TRUE) {
		return mosMoslateUtil::getContentLinkById($content->id, $resolveMenuLink);
	}

	/**
	 * this is a generic database loading function using an instance of mosDBTable (or similiar)
	 * (you need logic core included before calling this function - Use Logic)
	 * @return string
	 * @since version - 0.5
	 */
	function &loadDatabaseEntryByObject($scopeName, $varName, &$classNameOrObject, $id) {
		global $database;
		if (!is_object($classNameOrObject)) {
			$className	= ''.$classNameOrObject;
			if (!class_exists($className)) {
				trigger_error('Moslate: class does not exsist:'.$classNameOrObject, E_USER_WARNING);
				if ($varName != '') {
					Logic::remove($scopeName, $varName);
				}
				$result	= NULL;
				return $result;
			}
			$classNameOrObject	=& new $className($database);
		}
		if (!$classNameOrObject->load($id)) {
			$result		= NULL;
		} else {
			$result		=& $classNameOrObject;
		}
		if ($varName != '') {
			Logic::set($scopeName, $varName, $result);
		}
		return $result;
	}

	function secureIdentifier($s) {
		return strtr(trim($s), ':/\\.\'"', "______");	// replace invalid characters for security reasons
	}

	/**
	 * this is a generic database loading function using an table
	 * (you need logic core included before calling this function - Use Logic)
	 * @return string
	 * @since version - 0.5
	 */
	function &loadDatabaseEntryByTable($scopeName, $varName, $tableName, $id, $idField = 'id') {
		global $database;
		$result		= NULL;
		$id			= trim($id);
		if ($id == '') {
			return $result;
		}
		$idField	= mosMoslateUtil::secureIdentifier($idField);
		$id			= intval($id);
		if ($idField == '') {
			$idField	= 'id';
		}
		$where	= $idField.' = '.$id;
		$order	= '';
//		$result	=& mosMoslateUtil::loadDatabaseEntriesByTable($scopeName, $varName, $tableName, $where, TRUE);
		$result	=& mosMoslateUtil::doLoadDatabaseEntriesByTable($scopeName, $varName, $tableName, $where, $order, TRUE);
		return $result;
	}

	/**
	 * this is a generic database loading function using a table
	 * (you need logic core included before calling this function - Use Logic)
	 * @return string
	 * @since version - 0.5
	 */
	function &loadDatabaseEntriesByTable($scopeName, $varName, $tableName, $where = '', $order = '') {
		$result	=& mosMoslateUtil::doLoadDatabaseEntriesByTable($scopeName, $varName, $tableName, $where, $order, FALSE);
		return $result;
	}

	/**
	 * this is a generic database loading function using a table
	 * (you need logic core included before calling this function - Use Logic)
	 * This function is for private use only.
	 * @return string
	 * @since version - 0.5.3
	 */
	function &doLoadDatabaseEntriesByTable($scopeName, $varName, $tableName, $where = '', $order = '', $returnFirst = FALSE) {
		global $database;
		$result		= NULL;
		$where		= trim($where);
		$order		= trim($order);
		$tableName	= mosMoslateUtil::secureIdentifier($tableName);
		if ($tableName == '') {
			trigger_error('Moslate: table name need to be specified', E_USER_WARNING);
			return $result;
		}
		$sql	= 'SELECT * FROM '.$tableName;
		if ($where != '') {
			$sql	.= ' WHERE '.$where;
		}
		if ($order != '') {
			$sql	.= ' ORDER BY '.$order;
		}
		$database->setQuery($sql);
		if ($returnFirst) {
			if (!$database->loadObject($result)) {
				$errorMessage	= $database->getErrorMsg();
				if ($errorMessage != '') {
					trigger_error('Moslate: failed to execute query - '.$errorMessage, E_USER_WARNING);
				}
			}
		} else {
			$result	= $database->loadObjectList();
			if (is_null($result)) {
				trigger_error('Moslate: failed to execute query - '.$database->getErrorMsg(), E_USER_WARNING);
			}
		}
		if ($varName != '') {
			Logic::set($scopeName, $varName, $result);
		}
		return $result;
	}
}

/**
 * this class is intended to provide (static) functions as an API to Moslate
 */
class mosMoslateAPI {

	/**
	 * returns the current parser
	 * @return mosMoslateParser
	 */
	function &getCurrentParser() {
		$mosGlobals	=& mosMoslateGlobals::getGlobals();
		return $mosGlobals->getCurrentParser();
	}

	/**
	 * returns a quoted string you could use inside a query
	 * (this is a function provided for compatibility with Mambo 4.5.1)
	 * @see mosMoslateUtil::dbQuote
	 * @return string
	 */
	function dbQuote(&$database, $text) {
		return mosMoslateUtil::dbQuote($database, $text);
	}

	/**
	 * returns the gid of the content which is currently processed
	 * @return int
	 */
	function getCreatorUserId() {
		$parser	=& mosMoslateAPI::getCurrentParser();
		if (!is_object($parser)) {
			echo '{error "invalid context for mosMoslateAPI::getCreatorUserId"}"';
			return FALSE;
		}
		return $parser->creatorUserId;
	}

	/**
	 * returns the gid of the content which is currently processed
	 * @return int
	 */
	function getCreatorGid() {
		$parser	=& mosMoslateAPI::getCurrentParser();
		if (!is_object($parser)) {
			echo '{error "invalid context for mosMoslateAPI::getCreatorGid"}';
			return FALSE;
		}
		return $parser->creatorGid;
	}

	/**
	 * parses the text using the current parser
	 * @return string
	 */
	function parse($text) {
		$parser	=& mosMoslateAPI::getCurrentParser();
		if (!is_object($parser)) {
			return '{error "invalid context for mosMoslateAPI::parse"}';
		}
		return $parser->parse($text);
	}

	/**
	 * process the content
	 * @param class $row $row->text will be parsed while $row->created_by is the author
	 * @return bool
	 */
	function processContent(&$row, $published = TRUE, $inheritSettings = FALSE) {
		$params		= null;
		return mosMoslateAPI::processContentWithParameters($row, $params, $published, $inheritSettings);
	}

	/**
	 * process the content
	 * @param class $row $row->text will be parsed while $row->created_by is the author
	 * @return bool
	 */
	function processContentWithParameters(&$row, &$params, $published = TRUE, $inheritSettings = FALSE) {
		if (!$published) {
			return FALSE;	// do not partially parse the content anymore when unpublished
		}
		$mosGlobals	=& mosMoslateGlobals::getInitializedGlobals($published);
		$parser		=& $mosGlobals->getNewParser($inheritSettings);
		if (!$published) {
			$parser->enabled	= FALSE;
		}
		if ($params != null) {
			$parser->params	=& $params;
		}
		return $parser->processContent($row);
	}


	/**
	 * returns an array of contents matching the parameters
	 * @return array
	 * @see mosMoslateUtil#getContentArray
	 * @deprecated version - 0.5
	 */
	function &getContentArray($id = 0, $titleAlias = '', $onlyPublished = FALSE, $allowFromOtherUser = FALSE, $reduceToOwnedIfNotEmpty = TRUE) {
		// PHP BUG #33558 (PHP 4.4/5.1): Notice: Only variable references should be returned by reference
		return mosMoslateUtil::getContentArray($id, $titleAlias, $onlyPublished, $allowFromOtherUser, $reduceToOwnedIfNotEmpty);
	}

	/**
	 * returns the content matching the parameters, none if more than one were found
	 * @return content
	 * @see mosMoslateUtil#getContent
	 * @deprecated version - 0.5
	 */
	function &getContent($id = 0, $titleAlias = '', $onlyPublished = FALSE, $allowFromOtherUser = FALSE) {
		// PHP BUG #33558 (PHP 4.4/5.1): Notice: Only variable references should be returned by reference
		return mosMoslateUtil::getContent($id, $titleAlias, $onlyPublished, $allowFromOtherUser);
	}

	/**
	 * returns the first content matching the parameters
	 * @return content
	 * @see mosMoslateUtil#getFirstContent
	 * @deprecated version - 0.5
	 */
	function &getFirstContent($id = 0, $titleAlias = '', $onlyPublished = FALSE, $allowFromOtherUser = FALSE) {
		return mosMoslateUtil::getFirstContent($id, $titleAlias, $onlyPublished, $allowFromOtherUser);
	}

	/**
	 * returns the a linke for the content-id
	 * @return string
	 * @see mosMoslateUtil#getContentLinkById
	 * @deprecated version - 0.5
	 */
	function getContentLinkById($id, $resolveMenuLink = TRUE) {
		return mosMoslateUtil::getContentLinkById($id, $resolveMenuLink);
	}

	/**
	 * returns the a linke for the content
	 * @return string
	 * @see mosMoslateUtil#getContentLinkByContent
	 * @deprecated version - 0.5
	 */
	function getContentLinkByContent(&$content, $resolveMenuLink = TRUE) {
		return mosMoslateUtil::getContentLinkById($content, $resolveMenuLink);
	}

	/**
	 * this is a sample function which can be used in combination with mode=Call Function
	 * @return string
	 * @since version - 0.5
	 */
	function sampleEchoFunction($parameterMap) {
		return $parameterMap['data'];
	}

}

?>