<?php
/**
 * Moslate logger class.
 *
 * @package moslate
 * @version $Id: moslate.logger.class.php 208 2006-09-19 22:48:33Z  $
 * @copyright (C) 2004-2006 Daniel Ecer (de.siteof.de)
 * @license GNU/GPL
 */


DEFINE('MOSLATE_LOGLEVEL_FATAL',	50000);
DEFINE('MOSLATE_LOGLEVEL_ERROR',	40000);
DEFINE('MOSLATE_LOGLEVEL_WARNING',	30000);
DEFINE('MOSLATE_LOGLEVEL_INFO',		20000);
DEFINE('MOSLATE_LOGLEVEL_DEBUG',	10000);
DEFINE('MOSLATE_LOGLEVEL_ALL',		0);

class mosMoslateLogEntry {
	var $level;
	var $message;

	function mosMoslateLogEntry($level, $message) {
		$this->level	= $level;
		$this->message	= $message;
	}
}

class mosMoslateLogger {

	var $threshold	= MOSLATE_LOGLEVEL_ALL;

	function doLog($level, $message) {
	}

	function levelToName($level) {
		// do not translate names
		switch($level) {
			case MOSLATE_LOGLEVEL_FATAL:
				return 'FATAL';
			case MOSLATE_LOGLEVEL_ERROR:
				return 'ERROR';
			case MOSLATE_LOGLEVEL_WARNING:
				return 'WARNING';
			case MOSLATE_LOGLEVEL_INFO:
				return 'INFO';
			case MOSLATE_LOGLEVEL_DEBUG:
				return 'DEBUG';
			case MOSLATE_LOGLEVEL_ALL:
				return 'ALL';
		}
		return 'LEVEL'.$level;
	}

	function levelToString($level) {
		$text			= $this->levelToName($level);
		$variableMap	= null;
		$text			= mosMoslateLang::getLangText('_MOSLATE_LOGLEVEL_'.$text, $text, $variableMap);
		return $text;
	}

	function levelToImage($level) {
		switch($level) {
			case MOSLATE_LOGLEVEL_FATAL:
				return 'fatal.gif';
			case MOSLATE_LOGLEVEL_ERROR:
				return 'error.gif';
			case MOSLATE_LOGLEVEL_WARNING:
				return 'warning.gif';
			case MOSLATE_LOGLEVEL_INFO:
				return 'info.gif';
			case MOSLATE_LOGLEVEL_DEBUG:
				return 'debug.gif';
		}
		return '';
	}

	function levelToImageUrl($level) {
		global $mosConfig_live_site;
		$image	= $this->levelToImage($level);
		if ($image != '') {
			return $mosConfig_live_site.'/components/com_moslate/images/'.$image;
		}
		return '';
	}

	function logByLevel($level, $message) {
		if ($level >= $this->threshold) {
			$this->doLog($level, $message);
		}
	}

	function logEntries($entries) {
		foreach($entries as $entry) {
			if (is_object($entry)) {
				$this->logByLevel($entry->level, $entry->message);
			} else {
				$this->logByLevel($entry['level'], $entry['message']);
			}
		}
	}

	function getTimestamp() {
		return date("Y-m-d h:i:s");
	}

	function replaceVariables($message, &$variableMap) {
		return mosMoslateLang::replaceVariables($message, $variableMap);
	}

	function logFatal($message) {
		$this->logByLevel(MOSLATE_LOGLEVEL_FATAL, $message);
	}

	function logError($message) {
		$this->logByLevel(MOSLATE_LOGLEVEL_ERROR, $message);
	}

	function logWarning($message) {
		$this->logByLevel(MOSLATE_LOGLEVEL_WARNING, $message);
	}

	function logInfo($message) {
		$this->logByLevel(MOSLATE_LOGLEVEL_INFO, $message);
	}

	function logDebug($message) {
		$this->logByLevel(MOSLATE_LOGLEVEL_DEBUG, $message);
	}
}

class mosMoslateLoggerHtml extends mosMoslateLogger {

	function doLog($level, $message) {
		$levelName	= $this->levelToName($level);
		$levelText	= $this->levelToString($level);
		$image		= $this->levelToImageUrl($level);
		$text		= $this->levelToString($level).': '.$message;
		$tagName	= 'div';
		$s			= '<'.$tagName;
		$s			.= ' class="logentry-'.strtolower($levelName).'"';
		$s			.= ' title="'.$levelText.'"';
		$s			.= '>';
		if ($image != '') {
			$s			.= '<img src="'.$image.'" alt="'.$levelText.'" /> ';
		} else {
			$s			.= $levelText.': ';
		}
		$s			.= '<span>';
		$s			.= $message;
//		$s			.= htmlentities($message);
		$s			.= '</span>';
		$s			.= '</'.$tagName.'>';
		echo $s;
	}
}

class mosMoslateLoggerBuffer extends mosMoslateLogger {
	var $entries	= array();

	function doLog($level, $message) {
		$this->entries[]	=& new mosMoslateLogEntry($level, $message);
	}
}

class mosMoslateLoggerFile extends mosMoslateLogger {
	var $fileName;
	var $fileHandle;
	var $open	= FALSE;

	function mosMoslateLoggerFile($fileName) {
		$this->fileName	= $fileName;
	}

	function open() {
		if (!$this->open) {
			$this->fileHandle	= fopen($this->fileName, 'a');
			$this->open			= ($this->fileHandle !== FALSE);
		}
		return $this->open;
	}

	function close() {
		if ($this->open) {
			fclose($this->fileHandle);
			$this->fileHandle	= FALSE;
			$this->open			= FALSE;
		}
	}

	function doLog($level, $message) {
		if (!$this->open) {
			$this->open();
			if (!$this->open) {
				return FALSE;
			}
		}
		$levelName	= $this->levelToName($level);
		$levelText	= $this->levelToString($level);
		$timestamp	= $this->getTimestamp();
		$text		= $timestamp.': ['.$levelText.'] '.$message;
		$s			= $text."\n";
		fwrite($this->fileHandle, $s);
		fflush($this->fileHandle);
		$this->close();
		return TRUE;
	}
}
?>