<?php
/**
 * Moslate toolbar output class.
 *
 * @package moslate
 * @version $Id: toolbar.moslate.html.php 208 2006-09-19 22:48:33Z  $
 * @copyright (C) 2004-2006 Daniel Ecer (de.siteof.de)
 * @license GNU/GPL
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/*
 * Some legacy functions for campatibility with Mambo 4.5.1
 */
class mosMenuBarLegacy {
	function apply() {
		if (is_callable(array('mosMenuBar', 'apply'))) {
			mosMenuBar::apply();
		} else {
			// we do not bother to place an apply-button in if it is not available usually anyway
		}
	}
}

/**
*
*/
class TOOLBAR_moslate {
	/**
	* Draws the menu for a New Contact
	*/
	function _EDIT() {
		mosMenuBar::startTable();
		mosMenuBar::save();
		mosMenuBar::spacer();
		mosMenuBarLegacy::apply();
		mosMenuBar::spacer();
		mosMenuBar::cancel();
		mosMenuBar::endTable();
	}

	/**
	* Draws the menu for Configuration
	*/
	function _CONFIG() {
		mosMenuBar::startTable();
		mosMenuBar::custom('updatelanguage', 'langmanager.png', 'langmanager.png',
			mosMoslateLang::getToolbarTextAsHtml('UPDATE_LANGUAGE', 'Update Language (Menu)'), false);
		mosMenuBar::spacer();
		mosMenuBar::save('saveconfig');
		mosMenuBar::spacer();
		mosMenuBar::cancel();
		mosMenuBar::endTable();
	}

	/**
	* Draws the menu for Import
	*/
	function _IMPORT() {
		mosMenuBar::startTable();
		mosMenuBar::custom('uploadimport', 'restore.png', 'restore_f2.png',
			mosMoslateLang::getToolbarTextAsHtml('IMPORT', 'Import'), false);
		mosMenuBar::spacer();
		mosMenuBar::cancel();
		mosMenuBar::endTable();
	}

	/**
	* Draws the menu for Import
	*/
	function _UPLOADIMPORT() {
		mosMenuBar::startTable();
		mosMenuBar::custom('manage', 'next.png', 'next_f2.png',
			mosMoslateLang::getToolbarTextAsHtml('CONTINUE', 'Continue'), false);
		mosMenuBar::spacer();
		mosMenuBar::endTable();
	}

	/**
	* Draws the menu for Export
	*/
	function _EXPORT() {
		mosMenuBar::startTable();
		mosMenuBar::custom('downloadexport', 'backup.png', 'backup.png',
			mosMoslateLang::getToolbarTextAsHtml('EXPORT', 'Export'), false);
		mosMenuBar::spacer();
		mosMenuBar::cancel();
		mosMenuBar::endTable();
	}

	/**
	* Draws the menu for Export
	*/
	function _DOWNLOADEXPORT() {
		mosMenuBar::startTable();
		mosMenuBar::custom('manage', 'next.png', 'next_f2.png',
			mosMoslateLang::getToolbarTextAsHtml('CONTINUE', 'Continue'), false);
		mosMenuBar::spacer();
		mosMenuBar::endTable();
	}

	/**
	* Draws the menu for Export
	*/
	function _ABOUT() {
	}


	function _DEFAULT() {
		mosMenuBar::startTable();
		mosMenuBar::publish();
		mosMenuBar::spacer();
		mosMenuBar::unpublish();
		mosMenuBar::spacer();
		mosMenuBar::addNew();
		mosMenuBar::spacer();
		mosMenuBar::editList();
		mosMenuBar::spacer();
		mosMenuBar::deleteList();
		mosMenuBar::endTable();
	}
}

?>