/*
 * Decompiled with CFR 0.152.
 */
package my.de.webfileshrinker;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class MyStringBuffer
implements Serializable {
    private char[] value;
    private int count;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;
    private static final MyStringBuffer NULL = new MyStringBuffer("null");

    public MyStringBuffer() {
        this(16);
    }

    public MyStringBuffer(int n) {
        this.value = new char[n];
        this.shared = false;
    }

    public MyStringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public synchronized int length() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value.length;
    }

    private final void copy() {
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    private void expandCapacity(int n) {
        int n2 = (this.value.length + 1) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        if (this.count < n) {
            if (this.shared) {
                this.copy();
            }
            while (this.count < n) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = n;
            if (this.shared) {
                this.copy();
            }
        }
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.shared) {
            this.copy();
        }
        this.value[n] = c;
    }

    public synchronized MyStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized MyStringBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n2 = this.count + (n = string.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        string.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public synchronized MyStringBuffer append(MyStringBuffer myStringBuffer) {
        int n;
        int n2;
        if (myStringBuffer == null) {
            myStringBuffer = NULL;
        }
        if ((n2 = this.count + (n = myStringBuffer.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        myStringBuffer.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public synchronized MyStringBuffer append(char[] cArray) {
        int n = cArray.length;
        int n2 = this.count + n;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count = n2;
        return this;
    }

    public synchronized MyStringBuffer append(char[] cArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public MyStringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized MyStringBuffer append(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.count++] = c;
        return this;
    }

    public MyStringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public MyStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public MyStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public MyStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public synchronized MyStringBuffer delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            if (this.shared) {
                this.copy();
            }
            System.arraycopy(this.value, n + n3, this.value, n, this.count - n2);
            this.count -= n3;
        }
        return this;
    }

    public synchronized MyStringBuffer deleteCharAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        --this.count;
        return this;
    }

    public synchronized MyStringBuffer replace(int n, int n2, String string) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = string.length();
        int n4 = this.count + n3 - (n2 - n);
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n2, this.value, n + n3, this.count - n2);
        string.getChars(0, n3, this.value, n);
        this.count = n4;
        return this;
    }

    public synchronized String substring(int n) {
        return this.substring(n, this.count);
    }

    public synchronized String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return new String(this.value, n, n2 - n);
    }

    public synchronized MyStringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count = n4;
        return this;
    }

    public synchronized MyStringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized MyStringBuffer insert(int n, String string) {
        int n2;
        int n3;
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + (n2 = string.length())) > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count = n3;
        return this;
    }

    public synchronized MyStringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count = n3;
        return this;
    }

    public MyStringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public synchronized MyStringBuffer insert(int n, char c) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        this.count = n2;
        return this;
    }

    public MyStringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public MyStringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public MyStringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public MyStringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int indexOf(String string, int n) {
        return this.toString().indexOf(string, n);
    }

    public synchronized MyStringBuffer reverse() {
        if (this.shared) {
            this.copy();
        }
        int n = this.count - 1;
        for (int i = n - 1 >> 1; i >= 0; --i) {
            char c = this.value[i];
            this.value[i] = this.value[n - i];
            this.value[n - i] = c;
        }
        return this;
    }

    public String toString() {
        return new String((char[])this.value.clone(), 0, this.length());
    }

    final void setShared() {
        this.shared = true;
    }

    final char[] getValue() {
        return this.value;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.value = (char[])this.value.clone();
        this.shared = false;
    }
}

