/*
 * Decompiled with CFR 0.152.
 */
package my.de.webfileshrinker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import my.de.webfileshrinker.ContextTypeCSS;
import my.de.webfileshrinker.ContextTypeHTML;
import my.de.webfileshrinker.ContextTypeScript;
import my.de.webfileshrinker.ContextTypeScriptTAG;
import my.de.webfileshrinker.ContextTypeStyleTAG;
import my.de.webfileshrinker.FileContext;
import my.de.webfileshrinker.JZOOWildCardFilter;
import my.de.webfileshrinker.MyStringBuffer;

public class WebFileShrinker {
    private static String version = "1.4.7";
    private static boolean boolRemoveQuotes = false;
    private static boolean boolToggleCapitals = false;
    private static boolean boolLowerCapitals = false;
    private static boolean boolUpperCapitals = false;
    private static boolean boolRemoveStrLF = false;
    private static boolean boolAutoAddFiles = false;
    private static boolean boolOptimizeScriptString = false;
    private static boolean boolOptimizeParamScripts = false;
    private static boolean boolUseLFInsteadOfSpace = false;
    private static boolean boolLeaveAllLF = false;
    private static boolean boolLeaveScriptLF = false;
    private static boolean boolSkipUnchanged = false;
    private static boolean boolNoRefReport = false;
    private static boolean boolHideSkipped = false;
    private static boolean boolTrySetLastModified = true;
    private static String pathSeparator = File.separator;
    private static boolean boolIgnoreAbsolutePaths = false;
    private static boolean boolIsLogFile = false;
    private static PrintWriter logFile;
    private static boolean boolPreventMoreFiles;
    private static Writer outFile;
    private int nTag;
    private int nTagEntryNr;
    private int scriptState;
    private static String strTag;
    private static String strTemp;
    private StringBuffer strbufTemp;
    private static boolean boolSpacePlaced;
    private static boolean boolIgnoreSpace;
    private static boolean boolRequestSpace;
    private static boolean boolRequestSpacePlaced;
    private static boolean boolIgnoreTagSpace;
    private static boolean boolRequestTagSpace;
    private static boolean boolLFPlaced;
    private static boolean boolTagValue;
    private static boolean boolIsProperty;
    private static boolean boolScriptFile;
    private static boolean boolScriptDone;
    private static int nSrcLineNr;
    private static int nSrcTotalLineNum;
    private static long nSrcFileSize;
    private static long nDestFileSize;
    private static long nSrcTotalSize;
    private static long nDestTotalSize;
    private static int nBracesCount;
    private static int nBracketCount;
    private static char chStr;
    private static int[] nStrLocationLineTbl;
    private static int nStrLocationLinePos;
    private static String strSrcStr;
    private static int srcStrWritten;
    private static String strCurFile;
    private static String strCurPath;
    private static String strParam;
    private static Vector srcRefList;
    private static Vector sourceFiles;
    private static int nSrcRefNum;
    private static int nSourceFileNr;
    private static int nSourceFileNum;
    private static int skippedNum;
    private static int processedNum;
    private static int errorNum;
    private static int warningNum;
    private static Vector inFuncList;
    private static String strLastInFunc;
    private static char chLastNoneSpaceChar;
    private static String strIdentifier;
    private static String strLastProperty;
    private static String strEvaluated;
    private static String embeddedEnd;
    private static boolean isEmbeddedCommentary;
    private static int nEvalEntryNum;
    private static int nh;
    private static boolean nc;
    private static String targetDirectory;
    private static String sourceDirectory;
    private static String lastSourceLine;
    private FileContext fileContext;
    private static final int SCRIPTSTATE_NONE = 0;
    private static final int SCRIPTSTATE_TAG = 1;
    private static final int SCRIPTSTATE_COMMENT = 2;
    private static final int SCRIPTSTATE_CODE_COMMENT = 3;
    private static final int SCRIPTSTATE_CODE = 10;
    private static Vector scriptStates;
    private static int aspProcessingIf;
    private static boolean aspProcessingStr;
    private static int aspProcessingLastIf;
    private static Vector aspStates;

    private static void processHtmlScriptInit() {
        inFuncList.removeAllElements();
        strLastInFunc = "";
        strLastProperty = "";
        boolIsProperty = false;
        nBracesCount = 0;
        nBracketCount = 0;
        strEvaluated = "";
        nEvalEntryNum = 0;
        embeddedEnd = null;
        isEmbeddedCommentary = false;
    }

    private void processHtmlSrcInit() {
        WebFileShrinker.processEmbeddedFileStart();
        this.nTagEntryNr = 0;
        this.nTag = 0;
        this.scriptState = 0;
        strTag = new String();
        strTemp = new String();
        this.strbufTemp = new StringBuffer(4096);
        boolIgnoreSpace = false;
        boolRequestSpace = false;
        boolIgnoreTagSpace = false;
        boolRequestTagSpace = false;
        boolRequestSpacePlaced = false;
        boolSpacePlaced = true;
        boolLFPlaced = false;
        boolTagValue = false;
        nSrcLineNr = 0;
        chStr = '\u0000';
        nStrLocationLineTbl = new int[5];
        nStrLocationLinePos = 0;
        strSrcStr = "";
        nSrcFileSize = 0L;
        nDestFileSize = 0L;
        WebFileShrinker.processHtmlScriptInit();
        boolScriptDone = false;
        if (boolScriptFile) {
            this.scriptState = 10;
            boolIgnoreSpace = true;
            boolRequestSpacePlaced = true;
        }
        strSrcStr = "";
        srcStrWritten = 0;
    }

    private void pushScriptState() {
        scriptStates.addElement(new Object[]{new FileContext(this.fileContext), new Character(chStr), new Integer(nStrLocationLinePos), new Boolean(boolIgnoreSpace), new Boolean(boolRequestSpace), new Boolean(boolRequestSpacePlaced), new Boolean(boolSpacePlaced), new Boolean(boolIgnoreTagSpace), new Boolean(boolRequestTagSpace), new Boolean(boolTagValue), new Boolean(boolLFPlaced), new Integer(this.nTag), new Integer(this.nTagEntryNr), new Integer(this.scriptState), new Character(chLastNoneSpaceChar), strTag});
    }

    private void peekScriptState() {
        int n = scriptStates.size();
        if (n <= 0) {
            WebFileShrinker.reportError("no state in buffer", true);
        } else {
            Object[] objectArray = (Object[])scriptStates.elementAt(n - 1);
            int n2 = 0;
            this.fileContext = new FileContext((FileContext)objectArray[n2++]);
            chStr = ((Character)objectArray[n2++]).charValue();
            nStrLocationLinePos = (Integer)objectArray[n2++];
            boolIgnoreSpace = (Boolean)objectArray[n2++];
            boolRequestSpace = (Boolean)objectArray[n2++];
            boolRequestSpacePlaced = (Boolean)objectArray[n2++];
            boolSpacePlaced = (Boolean)objectArray[n2++];
            boolIgnoreTagSpace = (Boolean)objectArray[n2++];
            boolRequestTagSpace = (Boolean)objectArray[n2++];
            boolTagValue = (Boolean)objectArray[n2++];
            boolLFPlaced = (Boolean)objectArray[n2++];
            this.nTag = (Integer)objectArray[n2++];
            this.nTagEntryNr = (Integer)objectArray[n2++];
            this.scriptState = (Integer)objectArray[n2++];
            chLastNoneSpaceChar = ((Character)objectArray[n2++]).charValue();
            strTag = (String)objectArray[n2++];
            if (n2 != objectArray.length) {
                WebFileShrinker.reportPrintLn("oops");
            }
        }
    }

    private void popScriptState() {
        this.peekScriptState();
        if (scriptStates.size() > 0) {
            WebFileShrinker.dropScriptState();
        }
    }

    private static void dropScriptState() {
        int n = scriptStates.size();
        if (n <= 0) {
            WebFileShrinker.reportError("no state in buffer", true);
        } else {
            scriptStates.removeElementAt(n - 1);
        }
    }

    private static void startEmbedded(String string, boolean bl) {
        boolRequestTagSpace = false;
        boolRequestSpace = false;
        boolIgnoreSpace = false;
        embeddedEnd = string;
        isEmbeddedCommentary = bl;
    }

    private static void endEmbedded() {
        embeddedEnd = null;
    }

    private static void reportPrint(String string) {
        System.out.print(string);
        if (boolIsLogFile && string.indexOf(13) < 0) {
            logFile.print(string);
        }
    }

    private static void reportError(String string, boolean bl) {
        if (bl) {
            WebFileShrinker.reportPrintLn(WebFileShrinker.sLeft("\rline:" + lastSourceLine, 79));
        }
        WebFileShrinker.reportPrintLn(WebFileShrinker.sLeft("\rerror" + (bl ? "(" + nSrcLineNr + ")" : "") + ": " + string, 79));
        ++errorNum;
    }

    private static void reportWarning(String string, boolean bl) {
        WebFileShrinker.reportPrintLn(WebFileShrinker.sLeft("\rwarning" + (bl ? "(" + nSrcLineNr + ")" : "") + ": " + string, 79));
        ++warningNum;
    }

    private static void reportPrintLn(String string) {
        String string2 = string.trim();
        int n = string2.lastIndexOf(13);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        System.out.println(string);
        if (boolIsLogFile) {
            logFile.println(string);
        }
    }

    private static boolean isRemoveHTTrackAddition() {
        return true;
    }

    private static void writeStr(String string) {
        if (boolScriptDone) {
            return;
        }
        int n = string.length();
        if (n <= 0) {
            return;
        }
        if (string.equals("\n") && (boolLFPlaced || nDestFileSize == 0L)) {
            return;
        }
        boolean bl = boolLFPlaced = string.charAt(n - 1) == '\n';
        if (boolLFPlaced) {
            boolSpacePlaced = true;
        }
        try {
            outFile.write(string);
            nDestFileSize += (long)n;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    private static void writeChar(char c) {
        WebFileShrinker.writeStr("" + c);
    }

    private static String getRatioStr(long l, long l2) {
        String string = new String();
        long l3 = Math.abs(l2 - l) * 1000L;
        if (l == 0L) {
            return "-.-%";
        }
        long l4 = (l3 /= Math.abs(l)) % 10L;
        string = (l2 < l ? "-" : (l2 == l ? " " : "+")) + (int)((l3 -= l4) / 10L) + "." + Math.abs(l4) + "%";
        return string;
    }

    private static String sLeft(String string, int n) {
        for (int i = string.length(); i < n; ++i) {
            string = string + ' ';
        }
        return string;
    }

    private static String sRight(String string, int n) {
        for (int i = string.length(); i < n; ++i) {
            string = ' ' + string;
        }
        return string;
    }

    private static String sRight(long l, int n) {
        return WebFileShrinker.sRight("" + l, n);
    }

    private static String sDup(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String getFormatedFileName(String string) {
        return string.trim().replace('\\', '/');
    }

    private static String getPlatformFileName(String string) {
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            string = string.replace('\\', File.separatorChar);
        }
        return string;
    }

    private static String getFileExt(String string) {
        int n;
        int n2 = string.lastIndexOf(47);
        if (n2 > (n = string.lastIndexOf(92))) {
            n = n2;
        }
        if ((n2 = string.lastIndexOf(46)) >= 0 && (n < 0 || n < n2)) {
            return string.substring(n2);
        }
        return "";
    }

    private static boolean isHTMLSourceFile(String string) {
        String string2 = WebFileShrinker.getFormatedFileName(string);
        String string3 = WebFileShrinker.getFileExt(string2);
        String string4 = WebFileShrinker.getFileExt(string2.substring(0, string2.length() - string3.length()));
        return !string4.startsWith(".js") && !string4.startsWith(".css") && (string3.startsWith(".htm") || string3.startsWith(".asp") || string3.startsWith(".htc") || string3.startsWith(".php"));
    }

    private static boolean isSourceFile(String string) {
        String string2 = WebFileShrinker.getFileExt(string).toLowerCase();
        return string2.startsWith(".htm") || string2.startsWith(".js") || string2.startsWith(".vbs") || string2.startsWith(".css") || string2.startsWith(".asp") || string2.startsWith(".htc") || string2.startsWith(".php");
    }

    private static boolean isCSSSourceFile(String string) {
        String string2 = WebFileShrinker.getFileExt(string).toLowerCase();
        return string2.startsWith(".css");
    }

    private static void addSrcRef(String string) {
        int n;
        if (boolPreventMoreFiles && boolNoRefReport) {
            return;
        }
        int n2 = string.indexOf(35);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n = (string = WebFileShrinker.getFormatedFileName(WebFileShrinker.getRelativePath(sourceDirectory, string))).indexOf(63)) >= 0) {
            string = string.substring(0, n);
        }
        if (string.length() <= 0) {
            return;
        }
        if (boolIgnoreAbsolutePaths && (string.charAt(0) == '\\' || string.charAt(0) == '/' || string.indexOf(58) >= 0)) {
            return;
        }
        string = strCurPath + string;
        if (WebFileShrinker.indexOfStrEntry(srcRefList, string) < 0 && WebFileShrinker.indexOfStrEntry(sourceFiles, string) < 0) {
            if (WebFileShrinker.isSourceFile(string) && !boolPreventMoreFiles) {
                WebFileShrinker.addStrEntry(sourceFiles, string);
                ++nSourceFileNum;
                return;
            }
            WebFileShrinker.addStrEntry(srcRefList, string);
            ++nSrcRefNum;
        }
    }

    private static void addStrEntry(Vector vector, String string) {
        vector.addElement(new String(string));
    }

    private static int indexOfStrEntry(Vector vector, String string) {
        return vector.indexOf(string);
    }

    private static String getStrEntry(Vector vector, int n) {
        if (n < 0 || n >= vector.size()) {
            return "";
        }
        return new String((String)vector.elementAt(n));
    }

    private static String getSrcRef(int n) {
        return WebFileShrinker.getStrEntry(srcRefList, n);
    }

    private static String getSourceFile(int n) {
        return WebFileShrinker.getStrEntry(sourceFiles, n);
    }

    private static void addInFunc(String string) {
        strLastInFunc = string;
        WebFileShrinker.addStrEntry(inFuncList, string);
    }

    private static void deleteLastInFunc() {
        if (inFuncList.size() > 0) {
            inFuncList.removeElementAt(inFuncList.size() - 1);
        }
        strLastInFunc = WebFileShrinker.getStrEntry(inFuncList, inFuncList.size() - 1);
    }

    private void setScriptState(int n) {
        String string;
        if (this.scriptState == n) {
            return;
        }
        if (this.scriptState == 2) {
            string = this.strbufTemp.toString();
            if (this.isCommentRequired(string)) {
                this.strbufTemp.setLength(0);
                this.strbufTemp.append("<");
                this.strbufTemp.append(string);
                this.strbufTemp.append("-->");
            } else {
                this.strbufTemp.setLength(0);
            }
        }
        if (this.scriptState == 10 && chStr != '\u0000') {
            string = "unexpected end of file - expected \"" + chStr + "\"";
            for (int i = 0; i < nStrLocationLinePos; ++i) {
                string = string + (i == 0 ? " (" : ", ") + nStrLocationLineTbl[i] + (i + 1 == nStrLocationLinePos ? ")" : "");
            }
            WebFileShrinker.reportWarning(string, false);
            WebFileShrinker.writeStr(strSrcStr);
        }
        this.scriptState = n;
    }

    private static void setStringCharacter(char c) {
        if (chStr == c) {
            return;
        }
        if (chStr != '\u0000') {
            if (nStrLocationLinePos >= nStrLocationLineTbl.length) {
                for (int i = 1; i < nStrLocationLinePos; ++i) {
                    WebFileShrinker.nStrLocationLineTbl[i - 1] = nStrLocationLineTbl[i];
                }
                --nStrLocationLinePos;
            }
            WebFileShrinker.nStrLocationLineTbl[WebFileShrinker.nStrLocationLinePos++] = nSrcLineNr;
        }
        chStr = c;
    }

    private void processSpaceRequest() {
        if (embeddedEnd != null) {
            return;
        }
        if (boolRequestSpace && boolRequestSpacePlaced) {
            if (!boolSpacePlaced) {
                if (boolUseLFInsteadOfSpace && this.fileContext.getPreCount() <= 0) {
                    WebFileShrinker.writeChar('\n');
                } else {
                    WebFileShrinker.writeChar(' ');
                }
            }
            boolRequestSpace = false;
            boolRequestSpacePlaced = false;
            boolSpacePlaced = true;
        } else {
            boolRequestSpacePlaced = true;
        }
    }

    private void processTempStrBuf() {
        MyStringBuffer myStringBuffer = new MyStringBuffer();
        if (this.strbufTemp.length() > 0 && embeddedEnd != null) {
            String string = this.strbufTemp.toString();
            int n = string.indexOf(embeddedEnd);
            if (n >= 0) {
                WebFileShrinker.writeStr(string.substring(0, n += embeddedEnd.length()));
                this.strbufTemp.delete(0, n);
                WebFileShrinker.endEmbedded();
            } else {
                WebFileShrinker.writeStr(string);
                this.strbufTemp.setLength(0);
            }
        }
        if (this.strbufTemp.length() > 0) {
            boolean bl = true;
            boolean bl2 = false;
            if (this.nTag == 1) {
                int n;
                if (!boolTagValue && (n = this.strbufTemp.length()) > 0 && (boolToggleCapitals || boolLowerCapitals || boolUpperCapitals)) {
                    int n2;
                    for (int i = n2 = this.strbufTemp.charAt(0) == '/' ? 1 : 0; i < n; ++i) {
                        this.strbufTemp.setCharAt(i, boolLowerCapitals || (i - n2 & 1) == 0 && !boolUpperCapitals ? Character.toLowerCase(this.strbufTemp.charAt(i)) : Character.toUpperCase(this.strbufTemp.charAt(i)));
                    }
                }
                strParam = this.strbufTemp.toString().toLowerCase();
                if (this.nTagEntryNr == 1) {
                    strTemp = ";br;div;hr;h1;h2;h3;h4;h5;h6;h8;h9;h10;p;body;html;head;title;frameset;frame;map;area;table;tr;th;td;form;meta;link;";
                    strTag = this.strbufTemp.toString().toLowerCase();
                    if (strTemp.indexOf(';' + strTag + ';') >= 0 || strTag.charAt(0) == '/' && strTemp.indexOf(';' + strTag.substring(1) + ';') >= 0) {
                        if (this.scriptState == 0) {
                            bl2 = true;
                            boolIgnoreSpace = true;
                            boolRequestSpacePlaced = false;
                            boolRequestSpace = false;
                            bl = false;
                        }
                        boolSpacePlaced = true;
                    } else if (strTag.equals("script")) {
                        WebFileShrinker.processHtmlScriptInit();
                        boolRequestSpace = false;
                        this.setScriptState(1);
                        this.fileContext.setContextType(ContextTypeScriptTAG.getDefaultInstance());
                    } else if (strTag.equals("/script")) {
                        bl2 = true;
                        boolRequestSpacePlaced = false;
                        boolIgnoreSpace = true;
                        boolRequestSpace = false;
                        boolSpacePlaced = true;
                        this.setScriptState(0);
                        this.fileContext.setContextType(ContextTypeHTML.getDefaultInstance());
                    } else if (strTag.equals("style")) {
                        boolRequestSpace = false;
                        this.setScriptState(1);
                        this.fileContext.setContextType(ContextTypeStyleTAG.getDefaultInstance());
                    } else if (strTag.equals("/style")) {
                        bl2 = true;
                        boolRequestSpacePlaced = false;
                        boolIgnoreSpace = true;
                        boolRequestSpace = false;
                        boolSpacePlaced = true;
                        this.setScriptState(0);
                    } else if (strTag.equals("pre")) {
                        this.fileContext.incrementPreCount();
                    } else if (strTag.equals("/pre")) {
                        this.fileContext.decrementPreCount();
                    } else {
                        if (strTag.equals("!--")) {
                            myStringBuffer.append(strTag.substring(3));
                            if (this.scriptState == 1) {
                                this.setScriptState(10);
                                this.fileContext.setContextType(this.fileContext.getContentContextType());
                            } else {
                                this.setScriptState(2);
                            }
                            this.nTag = 0;
                            ++this.nTagEntryNr;
                            if (this.scriptState == 10) {
                                WebFileShrinker.writeStr("<!--\n");
                                this.strbufTemp.setLength(0);
                            }
                            boolRequestTagSpace = false;
                            boolRequestSpace = false;
                            boolIgnoreSpace = true;
                            return;
                        }
                        if (strTag.startsWith("%")) {
                            this.nTag = 0;
                            WebFileShrinker.startEmbedded("%>", false);
                        } else if (!strTag.startsWith("/") && strTag.compareTo("wbr") != 0 && strTag.compareTo("body") != 0) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        boolRequestSpacePlaced = true;
                    }
                    this.processSpaceRequest();
                    boolRequestSpace = false;
                    ++this.nTagEntryNr;
                    boolRequestTagSpace = false;
                    WebFileShrinker.writeChar('<');
                    boolSpacePlaced = false;
                }
                if (boolRequestTagSpace) {
                    WebFileShrinker.writeChar(' ');
                    boolRequestTagSpace = false;
                } else {
                    boolRequestTagSpace = true;
                }
                boolIgnoreTagSpace = false;
                boolRequestTagSpace = true;
                if (bl2) {
                    boolSpacePlaced = true;
                    boolIgnoreSpace = true;
                    boolRequestSpacePlaced = false;
                    boolRequestSpace = false;
                } else {
                    boolIgnoreSpace = false;
                }
            } else if (this.nTag == 0) {
                strIdentifier = strTemp = this.strbufTemp.toString();
                if (boolIsProperty) {
                    strLastProperty = strIdentifier;
                }
                if (this.scriptState == 2 || this.scriptState == 3) {
                    return;
                }
                this.processSpaceRequest();
                boolIgnoreSpace = false;
                boolSpacePlaced = false;
                if (this.scriptState >= 1 && strTemp.compareTo("else") == 0) {
                    this.processSpaceRequest();
                    WebFileShrinker.writeStr("\n");
                    WebFileShrinker.writeStr(this.strbufTemp.toString());
                    this.strbufTemp.setLength(0);
                    boolIgnoreSpace = false;
                    boolSpacePlaced = false;
                    return;
                }
            }
            if (this.scriptState != 3 && this.scriptState != 2) {
                WebFileShrinker.writeStr(this.strbufTemp.toString());
            }
            this.strbufTemp.setLength(0);
            this.strbufTemp.append(myStringBuffer.toString());
        }
    }

    private static String optimizeScriptString(String string, boolean bl, int n) {
        int n2;
        int n3 = 1;
        boolean bl2 = bl;
        boolean bl3 = false;
        String string2 = "\";:<>{}[]()+-*/!=?,'";
        char c = '\u0000';
        if (!boolOptimizeScriptString) {
            return string;
        }
        if (n == 0) {
            string = string.trim();
        }
        if ((n2 = string.length()) < 2) {
            return string;
        }
        char c2 = string.charAt(0);
        n3 = n;
        n3 = 1;
        if (n3 <= 0) {
            ++n3;
        }
        String string3 = string.substring(0, n3);
        while (n3 < n2) {
            char c3 = string.charAt(n3);
            if (c3 == '\\') {
                if (++n3 >= n2 - 1) {
                    WebFileShrinker.reportWarning("missing ''", true);
                    return string;
                }
                c3 = string.charAt(n3);
            } else {
                if (c3 == c2) break;
                if (c != '\u0000') {
                    string3 = string3 + c3;
                    if (c3 == c) {
                        c = '\u0000';
                    }
                } else if (c3 == ' ' || c3 == '\t' || c3 == '\r' || c3 == '\n') {
                    if (!bl2) {
                        bl3 = true;
                    }
                } else if (c3 == '\'') {
                    c = c3;
                    string3 = string3 + c3;
                    bl2 = true;
                    bl3 = false;
                } else if (string2.indexOf(c3) >= 0) {
                    string3 = string3 + c3;
                    bl2 = true;
                    bl3 = false;
                } else {
                    if (bl3) {
                        string3 = string3 + ' ';
                    }
                    bl3 = false;
                    bl2 = false;
                    string3 = string3 + c3;
                }
            }
            if (++n3 > n) continue;
            string3 = string.substring(0, n3);
        }
        if (bl3) {
            string3 = string3 + ' ';
        }
        if (n3 < n2) {
            string3 = string3 + string.substring(n3);
        }
        return string3;
    }

    private boolean isInsideOptimizeableString() {
        return this.nTag != 0 && (strTemp = ";style;onabort;onblur;onchange;onclick;ondblclick;onerror;onfocus;onkeydown;onkeypress;onkeyup;onload;onmousedown;onmousemove;onmouseout;onmouseover;onmouseup;onreset;onselect;onsubmit;onunload;").indexOf(";" + strParam + ";") >= 0;
    }

    private void flushTempString() {
        if (boolOptimizeParamScripts && this.isInsideOptimizeableString()) {
            strSrcStr = WebFileShrinker.optimizeScriptString(strSrcStr, true, srcStrWritten);
        }
        if (srcStrWritten < strSrcStr.length()) {
            WebFileShrinker.writeStr(strSrcStr.substring(srcStrWritten));
            srcStrWritten = strSrcStr.length();
        }
    }

    private static void pushASPState() {
        aspStates.addElement(new Object[]{new Integer(aspProcessingIf), new Integer(aspProcessingLastIf), new Boolean(aspProcessingStr)});
    }

    private static void peekASPState() {
        int n = aspStates.size();
        if (n <= 0) {
            WebFileShrinker.reportError("no asp-state in buffer", true);
        } else {
            Object[] objectArray = (Object[])aspStates.elementAt(n - 1);
            int n2 = 0;
            aspProcessingIf = (Integer)objectArray[n2++];
            aspProcessingLastIf = (Integer)objectArray[n2++];
            aspProcessingStr = (Boolean)objectArray[n2++];
            if (n2 != objectArray.length) {
                WebFileShrinker.reportPrintLn("oops");
            }
        }
    }

    private static void popASPState() {
        WebFileShrinker.peekASPState();
        if (aspStates.size() > 0) {
            WebFileShrinker.dropASPState();
        }
    }

    private static void dropASPState() {
        int n = aspStates.size();
        if (n <= 0) {
            WebFileShrinker.reportError("no asp-state in buffer", true);
        } else {
            aspStates.removeElementAt(n - 1);
        }
    }

    private static void processEmbeddedFileStart() {
        aspProcessingIf = -1;
        aspProcessingStr = false;
        aspProcessingLastIf = -1;
        embeddedEnd = null;
        aspStates.removeAllElements();
    }

    private static void processEmbeddedFileEnd() {
        if (aspProcessingIf < 0 && aspProcessingLastIf >= 0 && nSrcLineNr != aspProcessingLastIf) {
            WebFileShrinker.dropScriptState();
            aspProcessingLastIf = -1;
        }
    }

    private void processEmbeddedStr(String string) {
        Object object;
        if (isEmbeddedCommentary) {
            return;
        }
        WebFileShrinker.writeStr(string);
        string = string.replace('\r', ' ');
        string = string.replace('\n', ' ');
        string = string.replace('\t', ' ');
        if (embeddedEnd.equals("-->")) {
            string = string.trim();
            object = "#include ";
            if (string.length() >= ((String)object).length() && string.substring(0, ((String)object).length()).equalsIgnoreCase((String)object)) {
                string = string.substring(((String)object).length()).trim();
                if (((String)object).length() > 2 && string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                WebFileShrinker.addSrcRef(string);
            }
        }
        if (embeddedEnd.equals("%>")) {
            object = new StringTokenizer(string, " '\"()<>", true);
            String string2 = "";
            boolean bl = false;
            if (aspProcessingIf < 0 && aspProcessingLastIf >= 0 && nSrcLineNr != aspProcessingLastIf) {
                WebFileShrinker.dropScriptState();
                aspProcessingLastIf = -1;
                WebFileShrinker.popASPState();
            }
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken().toLowerCase();
                if (string3.equals(" ")) continue;
                if (string3.equals("\"")) {
                    aspProcessingStr = !aspProcessingStr;
                    continue;
                }
                if (string3.equals("'")) {
                    if (aspProcessingStr) continue;
                    return;
                }
                if (aspProcessingStr) continue;
                if (aspProcessingIf >= 0) {
                    if (aspProcessingIf == nSrcLineNr) {
                        if (string3.equals("_")) {
                            ++aspProcessingIf;
                            return;
                        }
                        aspProcessingLastIf = aspProcessingIf;
                        aspProcessingIf = -1;
                    }
                } else if (aspProcessingLastIf >= 0 && string3.equals("_")) {
                    ++aspProcessingLastIf;
                    return;
                }
                if (string3.equals("then")) {
                    aspProcessingIf = nSrcLineNr;
                    this.pushScriptState();
                    WebFileShrinker.pushASPState();
                }
                if (string3.equals("case") && string2.equals("select")) {
                    this.pushScriptState();
                    WebFileShrinker.pushASPState();
                }
                if (string3.equals("else")) {
                    this.peekScriptState();
                    bl = true;
                }
                if (string3.equals("elseif")) {
                    this.popScriptState();
                    WebFileShrinker.popASPState();
                    aspProcessingLastIf = -1;
                    aspProcessingIf = nSrcLineNr;
                }
                if (string3.equals("select") && string2.equals("end")) {
                    WebFileShrinker.dropScriptState();
                    WebFileShrinker.popASPState();
                }
                if (string3.equals("if") && string2.equals("end")) {
                    WebFileShrinker.dropScriptState();
                    aspProcessingLastIf = -1;
                    WebFileShrinker.popASPState();
                }
                string2 = string3;
            }
        }
    }

    private void processHtmlSrcStr(String string) {
        char c;
        int n;
        char c2;
        if (embeddedEnd != null) {
            int n2 = string.indexOf(embeddedEnd);
            if (n2 >= 0) {
                this.processEmbeddedStr(string.substring(0, n2));
                if (!isEmbeddedCommentary) {
                    WebFileShrinker.writeStr(embeddedEnd);
                }
                n2 += embeddedEnd.length();
                embeddedEnd = null;
                this.processHtmlSrcStr(string.substring(n2));
                return;
            }
            this.processEmbeddedStr(string + '\n');
            return;
        }
        String[] stringArray = new String[]{"<%", null, "%>", "<?", null, "?>", "<!DOC", null, ">", "<!--", "#", "-->", "<!--", "COPYRIGHT", "-->", "<!-*-", null, "-*->"};
        int c22 = -1;
        int n2 = -1;
        int n3 = stringArray.length - 3;
        String string2 = string.toUpperCase();
        for (c2 = '\u0000'; c2 < stringArray.length; c2 += 3) {
            n = string2.indexOf(stringArray[c2]);
            if (n >= 0 && stringArray[c2 + 1] != null && !string2.substring(n + stringArray[c2].length()).trim().startsWith(stringArray[c2 + 1])) {
                n = -1;
            }
            if (n < 0 || n2 >= 0 && n >= n2) continue;
            n2 = n;
            c = c2;
        }
        if (n2 >= 0) {
            isEmbeddedCommentary = c == n3;
            this.processHtmlSrcStr(string.substring(0, n2));
            this.processTempStrBuf();
            if (this.nTag != 0 && boolTagValue && chStr == '\u0000') {
                boolIgnoreTagSpace = false;
                boolRequestTagSpace = true;
            }
            this.strbufTemp.setLength(0);
            if (chStr == '\u0000') {
                boolRequestSpacePlaced = true;
                this.processSpaceRequest();
            }
            if (strSrcStr.length() == 0 && chStr > '\u0000') {
                strSrcStr = "" + chStr;
            }
            this.flushTempString();
            if (this.scriptState == 3 || this.scriptState == 2) {
                isEmbeddedCommentary = true;
            }
            if (!isEmbeddedCommentary) {
                WebFileShrinker.writeStr(string.substring(n2, n2 + stringArray[c].length()));
            }
            embeddedEnd = stringArray[c + 2];
            this.processHtmlSrcStr(string.substring(n2 + stringArray[c].length()));
            return;
        }
        n = 0;
        int n4 = 0;
        while (n < string.length()) {
            if (chStr > '\u0000') {
                if (n4 < 0) {
                    n4 = n;
                }
                while (n < string.length() && chStr > '\u0000') {
                    if (string.charAt(n) == '\\') {
                        ++n;
                    } else if (string.charAt(n) == chStr) {
                        WebFileShrinker.setStringCharacter('\u0000');
                    }
                    ++n;
                }
                strSrcStr = strSrcStr + string.substring(n4, n);
                n4 = -1;
                if (chStr == '\u0000') {
                    String string3 = strSrcStr.length() < 2 ? "" : strSrcStr.substring(1, strSrcStr.length() - 1);
                    if (nEvalEntryNum == 0) {
                        strEvaluated = string3;
                        ++nEvalEntryNum;
                    } else {
                        nEvalEntryNum = -1;
                    }
                    if (this.nTag == 0) {
                        boolIgnoreSpace = false;
                    } else {
                        if (strParam.equals("src") || strParam.equals("href") && WebFileShrinker.isSourceFile(string3)) {
                            WebFileShrinker.addSrcRef(string3);
                        }
                        if (string3.length() > 0 && boolRemoveQuotes && srcStrWritten == 0 && string3.indexOf(32) < 0 && string3.indexOf(9) < 0 && string3.indexOf(13) < 0 && string3.indexOf(10) < 0) {
                            strSrcStr = string3;
                        }
                    }
                    boolIgnoreTagSpace = false;
                }
                if (chStr != '\u0000' || this.nTag <= 0 && this.scriptState != 10) continue;
                if (boolRequestTagSpace && !boolIgnoreTagSpace) {
                    WebFileShrinker.writeChar(' ');
                    boolRequestTagSpace = false;
                }
                this.flushTempString();
                continue;
            }
            c2 = Character.toUpperCase(string.charAt(n));
            if (c2 == '\b' || c2 == '\t') {
                c2 = ' ';
            }
            if (this.scriptState == 1 && this.nTag == 0 && c2 != '<' && c2 != ' ') {
                this.processTempStrBuf();
                boolRequestTagSpace = false;
                this.setScriptState(10);
                this.fileContext.setContextType(this.fileContext.getContentContextType());
            }
            if (this.scriptState <= 1 && c2 == '<') {
                boolRequestSpacePlaced = true;
                this.processTempStrBuf();
            }
            if (this.fileContext.getContextType().isSpaceRequiredBefore(c2)) {
                this.processSpaceRequest();
            }
            if (this.scriptState <= 1 && c2 == '<') {
                if (this.nTag > 0) {
                    WebFileShrinker.reportWarning("Open TAG inside a TAG?!", true);
                }
                ++n;
                ++this.nTag;
                if (this.nTag == 1) {
                    this.nTagEntryNr = 0;
                }
                boolRequestTagSpace = false;
                boolTagValue = false;
            } else if (this.scriptState <= 1 && c2 == '>') {
                if (this.strbufTemp.toString().endsWith("--")) {
                    // empty if block
                }
                this.processTempStrBuf();
                this.strbufTemp.append(c2);
                boolSpacePlaced = false;
                boolRequestSpace = false;
                ++n;
                this.nTag = 0;
            } else if (this.scriptState >= 2 && this.nTag == 0 && ";:><(){}.+-*[],/!=".indexOf(c2) >= 0) {
                if (nh != -1578616793) {
                    return;
                }
                if (this.scriptState == 10) {
                    this.processTempStrBuf();
                }
                boolIsProperty = c2 == '.';
                if (this.scriptState == 10) {
                    if (c2 == '(') {
                        ++nBracketCount;
                        WebFileShrinker.addInFunc(strIdentifier);
                    } else if (c2 == ')') {
                        WebFileShrinker.deleteLastInFunc();
                        --nBracketCount;
                    } else if (c2 == '=') {
                        if (nBracketCount == 0) {
                            strEvaluated = "";
                            nEvalEntryNum = 0;
                        }
                    } else if (c2 == ';') {
                        if (nEvalEntryNum == 1 && strLastProperty.compareTo("src") == 0 && (strEvaluated = strEvaluated.trim()).length() > 0) {
                            WebFileShrinker.addSrcRef(strEvaluated);
                        }
                        strLastProperty = "";
                    }
                }
                if (c2 == '{') {
                    ++nBracesCount;
                    if (this.scriptState == 10) {
                        WebFileShrinker.writeChar(c2);
                    }
                } else if (c2 == '}') {
                    --nBracesCount;
                    if (this.scriptState == 10) {
                        WebFileShrinker.writeChar(c2);
                        if (nBracesCount == 0) {
                            WebFileShrinker.writeChar('\n');
                        }
                    }
                } else if (this.scriptState == 3 && c2 == '*' && n + 1 < string.length()) {
                    if (string.charAt(n + 1) == '/') {
                        if (!this.isCommentRequired(this.strbufTemp.toString())) {
                            this.strbufTemp.setLength(0);
                        }
                        this.setScriptState(10);
                        this.fileContext.setContextType(this.fileContext.getContentContextType());
                        ++n;
                    }
                } else if (this.scriptState != 3 && c2 == '/') {
                    boolean string4 = true;
                    if (this.scriptState != 3 && c2 == '/' && n + 1 < string.length()) {
                        if (string.charAt(n + 1) == '/') {
                            if ((n = string.indexOf("-->", n + 2)) >= 0) {
                                if (boolScriptFile) {
                                    boolScriptDone = true;
                                }
                                if (this.scriptState == 10) {
                                    if (!boolLFPlaced) {
                                        WebFileShrinker.writeChar('\n');
                                    }
                                    this.setScriptState(1);
                                    this.fileContext.setContextType(this.fileContext.getTAGContextType());
                                    WebFileShrinker.writeStr("//-->");
                                } else {
                                    this.setScriptState(0);
                                    this.fileContext.setContextType(ContextTypeHTML.getDefaultInstance());
                                }
                                this.nTag = 0;
                                n += 2;
                            } else {
                                n = string.length() - 1;
                            }
                        } else if (string.charAt(n + 1) == '*') {
                            if (this.scriptState == 10) {
                                this.strbufTemp.setLength(0);
                                this.setScriptState(3);
                            }
                        } else if (this.scriptState == 10) {
                            string4 = false;
                        }
                    } else {
                        string4 = false;
                    }
                    if (!string4) {
                        if (chLastNoneSpaceChar == '(' || chLastNoneSpaceChar == '=' || chLastNoneSpaceChar == ',') {
                            this.processTempStrBuf();
                            n4 = n;
                            WebFileShrinker.setStringCharacter(c2);
                            strSrcStr = "";
                            srcStrWritten = 0;
                            chLastNoneSpaceChar = '\u0000';
                        } else {
                            WebFileShrinker.writeChar(c2);
                        }
                    }
                } else if (this.scriptState == 10 && c2 == '<' && (string.substring(n).toLowerCase().startsWith("</script>") || string.substring(n).toLowerCase().startsWith("</style>"))) {
                    this.setScriptState(0);
                    this.fileContext.setContextType(ContextTypeHTML.getDefaultInstance());
                    this.nTag = 0;
                    --n;
                } else if (c2 == '-' && n + 2 < string.length()) {
                    if (string.charAt(n + 1) == '-' && string.charAt(n + 2) == '>') {
                        if (boolScriptFile) {
                            boolScriptDone = true;
                        }
                        if (this.scriptState == 10) {
                            if (!boolLFPlaced) {
                                WebFileShrinker.writeChar(c2);
                            }
                            this.setScriptState(1);
                            this.fileContext.setContextType(this.fileContext.getTAGContextType());
                            WebFileShrinker.writeStr("//-->");
                        } else {
                            String string4 = this.strbufTemp.toString();
                            if (!this.isCommentRequired(string4)) {
                                this.strbufTemp.setLength(0);
                            } else {
                                this.strbufTemp.setLength(0);
                                WebFileShrinker.writeStr("<" + string4 + "-->");
                            }
                            this.setScriptState(0);
                            this.fileContext.setContextType(ContextTypeHTML.getDefaultInstance());
                        }
                        this.nTag = 0;
                        n += 2;
                    } else if (this.scriptState == 10) {
                        WebFileShrinker.writeChar(c2);
                    }
                } else if (this.scriptState == 10) {
                    WebFileShrinker.writeChar(c2);
                } else {
                    this.strbufTemp.append(c2);
                }
                if (!this.fileContext.getContextType().isSpaceRequiredAfter(c2)) {
                    boolRequestSpace = false;
                    boolIgnoreSpace = true;
                }
                if (this.scriptState == 10) {
                    if (c2 == '(') {
                        if (!this.fileContext.isPrevSpaceToBreacket()) {
                            boolIgnoreSpace = false;
                        }
                    } else if (!(c2 != ')' && c2 != '}' || this.fileContext.isNextSpaceToBreacket())) {
                        boolIgnoreSpace = false;
                    }
                }
                ++n;
            } else if (c2 == ' ') {
                if (this.nTag != 0) {
                    this.processTempStrBuf();
                    boolTagValue = false;
                    if (!boolIgnoreTagSpace) {
                        boolIgnoreTagSpace = true;
                        boolRequestTagSpace = true;
                    }
                } else {
                    if (this.scriptState != 3) {
                        this.processTempStrBuf();
                    }
                    if (this.fileContext.getPreCount() > 0) {
                        boolRequestSpace = true;
                        boolRequestSpacePlaced = true;
                        boolSpacePlaced = false;
                        this.processSpaceRequest();
                    } else if (!boolIgnoreSpace) {
                        boolRequestSpace = true;
                        boolRequestSpacePlaced = true;
                    }
                }
                boolIsProperty = false;
                ++n;
            } else if (!(this.scriptState == 2 || this.scriptState == 3 || this.scriptState < 2 && this.nTag <= 0 || c2 != '\'' && c2 != '\"')) {
                this.processTempStrBuf();
                n4 = n++;
                WebFileShrinker.setStringCharacter(c2);
                strSrcStr = "";
                srcStrWritten = 0;
            } else if (this.nTag != 0 && c2 == '=') {
                this.processTempStrBuf();
                WebFileShrinker.writeChar(c2);
                boolTagValue = true;
                boolIgnoreTagSpace = true;
                boolRequestTagSpace = false;
                ++n;
            } else if (this.nTag == 1 && this.nTagEntryNr == 1 && this.strbufTemp.length() >= 3 && this.strbufTemp.substring(0, 3).equals("!--")) {
                this.strbufTemp.append(c2);
                this.processTempStrBuf();
                boolRequestTagSpace = false;
                boolTagValue = false;
                ++n;
            } else {
                nEvalEntryNum = -1;
                if (this.nTag > 0 && this.strbufTemp.length() == 0) {
                    ++this.nTagEntryNr;
                }
                if (this.scriptState != 3) {
                    this.strbufTemp.append(string.substring(n, n + 1));
                }
                ++n;
            }
            if (c2 == ' ') continue;
            chLastNoneSpaceChar = c2;
        }
        if (chStr > '\u0000' && n > n4 && n4 >= 0) {
            strSrcStr = strSrcStr + string.substring(n4, n);
        }
        if (this.scriptState == 0) {
            // empty if block
        }
    }

    private boolean isCommentRequired(String string) {
        return string.length() > 0 && (string.indexOf("!--[if") >= 0 || string.indexOf("<![") >= 0);
    }

    private static String replaceStringContent(String string, char c, char c2) {
        int n = string.length();
        char[] cArray = new char[n];
        chStr = c;
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            char c3 = cArray[i];
            if (chStr != '\u0000') {
                if (c3 == chStr) {
                    chStr = '\u0000';
                    continue;
                }
                cArray[i] = c2;
                if (c3 != '\\' || i + 1 >= n) continue;
                cArray[++i] = c2;
                continue;
            }
            if (c3 != '\'' && c3 != '\"') continue;
            chStr = c3;
        }
        return new String(cArray);
    }

    private static String getFormatedFileName(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            string = "..." + string.substring(n2 - n + 3);
        }
        return string;
    }

    private void processHtmlSrcLine(String string) {
        int n;
        int n2;
        String string2;
        if (boolScriptDone) {
            return;
        }
        lastSourceLine = string;
        if (WebFileShrinker.isRemoveHTTrackAddition()) {
            string2 = "<!-- Added by HTTrack -->";
            String string3 = "<!-- /Added by HTTrack -->";
            n2 = string.indexOf(string2);
            if (n2 >= 0 && (n = string.indexOf(string3, n2 + string2.length())) >= 0) {
                string = string.substring(0, n2) + string.substring(n + string3.length());
            }
        }
        if ((++nSrcLineNr & 0x1F) == 0) {
            WebFileShrinker.reportPrint("\r" + WebFileShrinker.getFormatedFileName(strCurFile, 70) + ": " + nSrcLineNr);
        }
        this.strbufTemp.setLength(0);
        if (chStr > '\u0000' && !boolRemoveStrLF) {
            strSrcStr = strSrcStr + '\n';
        }
        if (this.scriptState == 10 || this.scriptState == 1) {
            string2 = WebFileShrinker.replaceStringContent(string, chStr, '_');
            int n3 = 0;
            while ((n2 = string2.indexOf("//", n3)) >= 0) {
                n = string2.indexOf("/*", n3);
                if (n >= 0 && n < n2) {
                    int n4 = string2.indexOf("*/", n + 2);
                    if (n4 < 0) break;
                    n3 = n4 + 2;
                    continue;
                }
                if (string2.indexOf("//-->", n2) == n2) break;
                string = string.substring(0, n2);
                break;
            }
        }
        this.processHtmlSrcStr(string);
        this.processTempStrBuf();
        if ((boolLeaveAllLF || boolLeaveScriptLF && this.scriptState == 10 || this.fileContext.getPreCount() > 0 && this.scriptState == 0) && chStr <= '\u0000' && embeddedEnd == null) {
            if (this.fileContext.getPreCount() > 0) {
                boolLFPlaced = false;
            }
            WebFileShrinker.writeStr("\n");
        } else {
            this.processHtmlSrcStr(" ");
        }
    }

    private static String getRelativePath(String string, String string2) {
        if (string.length() > 0 && string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return new String(string2);
    }

    private static FileWriter createFileWriteEx(File file) {
        int n = 0;
        while (n < 2) {
            try {
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    if (file2.mkdirs()) {
                        WebFileShrinker.reportPrintLn("\rdirectory \"" + file2.getName() + "\" created\n");
                    } else {
                        ++n;
                    }
                }
                if (file.exists()) {
                    file.delete();
                }
                return new FileWriter(file);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private boolean minimizeFile(String string) {
        MyStringBuffer myStringBuffer = new MyStringBuffer(4096);
        try {
            Serializable serializable;
            int n;
            this.fileContext = new FileContext();
            String string2 = new String();
            int n2 = errorNum;
            int n3 = warningNum;
            if (string.charAt(0) != '\\' && string.charAt(0) != '/' && string.indexOf(58) < 0) {
                string = sourceDirectory + string;
            }
            strCurPath = (n = (strCurFile = (string = WebFileShrinker.getPlatformFileName(string))).lastIndexOf(File.separatorChar)) > 0 ? strCurFile.substring(0, n + 1).toLowerCase() : "";
            String string3 = targetDirectory + WebFileShrinker.getRelativePath(sourceDirectory, string);
            myStringBuffer.append(string3);
            File file = new File(string);
            if (!file.exists()) {
                WebFileShrinker.reportPrintLn("\rfile \"" + string + "\" / " + " does not exist?!");
                return false;
            }
            long l = file.lastModified();
            File file2 = null;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            outFile = null;
            int n4 = 0;
            while (n4 < 2) {
                try {
                    file2 = new File(myStringBuffer.toString());
                    if (boolSkipUnchanged && file2.exists() && file2.lastModified() == l) {
                        nDestFileSize = file2.length();
                    } else {
                        outFile = new StringWriter();
                    }
                    n4 = 3;
                }
                catch (Exception exception) {
                    if (n4 != 0) continue;
                    string2 = string;
                    if (sourceDirectory.length() > 0 && string2.startsWith(sourceDirectory)) {
                        string2 = string2.substring(sourceDirectory.length());
                    }
                    if ((n = (string2 = targetDirectory + string2).lastIndexOf(File.separatorChar)) > 0) {
                        string2 = string2.substring(0, n);
                    }
                    if (((File)(serializable = new File(string2))).mkdirs()) {
                        WebFileShrinker.reportPrintLn("\rdirectory \"" + string2 + "\" created");
                    } else {
                        ++n4;
                    }
                    ++n4;
                }
            }
            if (n4 != 3) {
                WebFileShrinker.reportError("unable to create file - " + myStringBuffer, false);
                return false;
            }
            boolean bl = boolScriptFile = !WebFileShrinker.isHTMLSourceFile(string) && WebFileShrinker.isSourceFile(string);
            if (boolScriptFile) {
                if (WebFileShrinker.isCSSSourceFile(string)) {
                    this.fileContext.setContextType(ContextTypeCSS.getDefaultInstance());
                } else {
                    this.fileContext.setContextType(ContextTypeScript.getDefaultInstance());
                }
            } else {
                this.fileContext.setContextType(ContextTypeHTML.getDefaultInstance());
            }
            this.processHtmlSrcInit();
            if (outFile != null) {
                block42: {
                    myStringBuffer.setLength(0);
                    int n5 = 1;
                    while (n5 > 0 && !boolScriptDone) {
                        try {
                            string2 = bufferedReader.readLine();
                            if (string2 != null) {
                                try {
                                    this.processHtmlSrcLine(string2);
                                    continue;
                                }
                                catch (RuntimeException runtimeException) {
                                    WebFileShrinker.reportError("exception: " + runtimeException.getMessage(), true);
                                    throw runtimeException;
                                }
                            }
                            n5 = 0;
                        }
                        catch (IOException iOException) {
                            n5 = 0;
                        }
                    }
                    if (embeddedEnd != null) {
                        WebFileShrinker.reportWarning("unexpected end of file - expected \"" + embeddedEnd + "\"", false);
                    }
                    WebFileShrinker.processEmbeddedFileEnd();
                    if (chStr != '\u0000') {
                        string2 = "unexpected end of file - expected \"" + chStr + "\"";
                        for (int i = 0; i < nStrLocationLinePos; ++i) {
                            string2 = string2 + (i == 0 ? " (" : ", ") + nStrLocationLineTbl[i] + (i + 1 == nStrLocationLinePos ? ")" : "");
                        }
                        WebFileShrinker.reportWarning(string2, false);
                        WebFileShrinker.writeStr(strSrcStr);
                    }
                    if (scriptStates.size() > 0) {
                        WebFileShrinker.reportWarning("unexpected end of file - " + scriptStates.size() + " blocks open", false);
                    }
                    if (!boolScriptFile && this.scriptState != 0 || boolScriptFile && this.scriptState != 10) {
                        WebFileShrinker.reportWarning("unexpected end of file - scriptState:" + this.scriptState + "", false);
                    }
                    if (!nc && !boolScriptFile) {
                        WebFileShrinker.writeStr("\n<!--\nhttp://go.to/awex\n-->");
                    }
                    if (errorNum == n2 && warningNum == n3) {
                        try {
                            FileWriter fileWriter = WebFileShrinker.createFileWriteEx(file2);
                            if (fileWriter == null) {
                                WebFileShrinker.reportError("error open destination file", false);
                                break block42;
                            }
                            fileWriter.write(outFile.toString());
                            ((Writer)fileWriter).close();
                            if (!boolTrySetLastModified) break block42;
                            try {
                                serializable = file2.getClass();
                                Class<Long> clazz = Long.TYPE;
                                Method method = ((Class)serializable).getMethod("setLastModified", clazz);
                                if (method != null) {
                                    method.invoke((Object)file2, new Long(l));
                                }
                            }
                            catch (Exception exception) {
                                boolTrySetLastModified = false;
                                WebFileShrinker.reportPrintLn("\rcould not set file time (" + exception.getMessage() + ") ");
                            }
                        }
                        catch (Exception exception) {
                            WebFileShrinker.reportError("error writing to destination file", false);
                        }
                    } else {
                        WebFileShrinker.reportPrintLn("\rignoring file due to errors/warnings");
                    }
                }
                outFile.close();
            }
            bufferedReader.close();
            ((Reader)fileReader).close();
            nSrcFileSize = 0L;
            nSrcFileSize = file.length();
            nDestFileSize = file2.length();
            String string4 = "" + nSrcFileSize;
            nSrcTotalSize += nSrcFileSize;
            nSrcTotalLineNum += nSrcLineNr;
            nDestTotalSize += nDestFileSize;
            if (outFile != null) {
                ++processedNum;
            } else {
                ++skippedNum;
            }
            if (outFile != null || !boolHideSkipped) {
                WebFileShrinker.reportPrintLn(WebFileShrinker.sLeft("\r" + (outFile != null ? "done" : "skipped") + ": " + WebFileShrinker.getRelativePath(sourceDirectory, strCurFile) + (outFile != null ? "(" + nSrcLineNr + ") " : ""), 48) + WebFileShrinker.sRight(string4, 7) + " -> " + WebFileShrinker.sRight(nDestFileSize, 7) + " bytes " + WebFileShrinker.sRight(WebFileShrinker.getRatioStr(nSrcFileSize, nDestFileSize), 7));
            }
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }

    private static void processProjectSrcLine(String string) {
        string.trim();
        boolPreventMoreFiles = false;
        if (string.length() > 0 && !string.startsWith("#")) {
            strCurPath = sourceDirectory;
            String string2 = string;
            if (string.charAt(0) != '\\' && string.charAt(0) != '/' && string.indexOf(58) < 0) {
                string2 = strCurPath + string;
            }
            String[] stringArray = WebFileShrinker.getFileNames(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = strCurPath;
                strCurPath = "";
                WebFileShrinker.addSrcRef(stringArray[i]);
                strCurPath = string3;
            }
        }
        boolPreventMoreFiles = !boolAutoAddFiles;
    }

    private static String[] getFileNames(String string) {
        String string2 = string;
        int n = Math.max(string.lastIndexOf(92), string.lastIndexOf(47));
        String string3 = ".";
        if (n >= 0) {
            string3 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        JZOOWildCardFilter jZOOWildCardFilter = new JZOOWildCardFilter(string);
        File file = new File(string3 = WebFileShrinker.getPlatformFileName(string3));
        String[] stringArray = file.list(jZOOWildCardFilter);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string3 + File.separatorChar + stringArray[i];
        }
        if (stringArray.length == 0) {
            WebFileShrinker.reportPrintLn("\r- warning: no files found in \"" + string2 + "\"");
        }
        return stringArray;
    }

    private int hash(String string) {
        int n = 123456789;
        for (int i = 0; i < string.length(); ++i) {
            n += n * 7 + string.charAt(i) * (7 + i * 13);
        }
        return n;
    }

    public WebFileShrinker(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        String string = WebFileShrinker.sDup('-', 79) + '\n' + " Web File Shrinker v";
        String string2 = "(C) 2000-2005 Daniel Ecer (de.siteof.de)\n" + WebFileShrinker.sDup('-', 79);
        try {
            int n;
            nh = string.hashCode() + string2.hashCode();
            nh += -1169904782;
            string = string + version + " \n" + string2;
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].trim();
                if (string2.length() <= 0) continue;
                if ((string2 = string2.toLowerCase()).charAt(0) == '/' || string2.charAt(0) == '-') {
                    if (string2.charAt(0) == '-') {
                        string2 = "/" + string2.substring(1);
                    }
                    if (string2.equals("/nocredits")) {
                        nc = true;
                        continue;
                    }
                    if (string2.startsWith("/removequotes")) {
                        boolRemoveQuotes = true;
                        continue;
                    }
                    if (string2.startsWith("/togglecapitals")) {
                        boolToggleCapitals = true;
                        continue;
                    }
                    if (string2.startsWith("/togglecase")) {
                        boolToggleCapitals = true;
                        continue;
                    }
                    if (string2.startsWith("/lowercapitals")) {
                        boolLowerCapitals = true;
                        continue;
                    }
                    if (string2.startsWith("/lowercase")) {
                        boolLowerCapitals = true;
                        continue;
                    }
                    if (string2.startsWith("/uppercapitals")) {
                        boolUpperCapitals = true;
                        continue;
                    }
                    if (string2.startsWith("/uppercase")) {
                        boolUpperCapitals = true;
                        continue;
                    }
                    if (string2.startsWith("/removestringlf")) {
                        boolRemoveStrLF = true;
                        continue;
                    }
                    if (string2.startsWith("/autoaddfiles")) {
                        boolAutoAddFiles = true;
                        continue;
                    }
                    if (string2.startsWith("/leavelf")) {
                        boolLeaveAllLF = true;
                        continue;
                    }
                    if (string2.startsWith("/leavescriptlf")) {
                        boolLeaveScriptLF = true;
                        continue;
                    }
                    if (string2.startsWith("/norefreport")) {
                        boolNoRefReport = true;
                        continue;
                    }
                    if (string2.startsWith("/optimizescript")) {
                        boolOptimizeScriptString = true;
                        boolOptimizeParamScripts = true;
                        continue;
                    }
                    if (string2.startsWith("/skipunchanged")) {
                        boolSkipUnchanged = true;
                        continue;
                    }
                    if (string2.startsWith("/hideskipped")) {
                        boolHideSkipped = true;
                        continue;
                    }
                    if (string2.startsWith("/spacetolf")) {
                        boolUseLFInsteadOfSpace = true;
                        continue;
                    }
                    if (string2.startsWith("/targetdir=")) {
                        targetDirectory = string2.substring(11).trim() + pathSeparator;
                        continue;
                    }
                    if (string2.startsWith("/sourcedir=")) {
                        sourceDirectory = string2.substring(11).trim() + pathSeparator;
                        continue;
                    }
                    if (!string2.startsWith("/logfile=")) continue;
                    string2 = string2.substring(9).trim();
                    if (boolIsLogFile || string2.length() <= 0) continue;
                    try {
                        FileWriter fileWriter = new FileWriter(string2);
                        logFile = new PrintWriter((Writer)fileWriter, true);
                        boolIsLogFile = true;
                    }
                    catch (Exception exception) {
                        WebFileShrinker.reportError(exception.getMessage(), false);
                    }
                    continue;
                }
                if (string2.trim().length() <= 0) continue;
                vector.addElement(new String(string2));
                bl = true;
            }
            if (targetDirectory.endsWith(pathSeparator + pathSeparator)) {
                targetDirectory = targetDirectory.substring(0, targetDirectory.length() - 1);
            }
            if (sourceDirectory.endsWith(pathSeparator + pathSeparator)) {
                sourceDirectory = sourceDirectory.substring(0, sourceDirectory.length() - 1);
            }
            WebFileShrinker.reportPrintLn(string);
            if (!bl) {
                WebFileShrinker.reportPrintLn("\nerror: no project/source-file given\n\nexample1: java -jar webfileshrinker.jar index.html Project2\\index.html\nexample2: java -jar webfileshrinker.jar MyHP.prj\n(note: the project-file is just a list of source files you want to optimize.)\n");
                return;
            }
            nSrcTotalLineNum = 0;
            if (sourceDirectory.length() > 0) {
                WebFileShrinker.reportPrintLn("\rsource directory: " + sourceDirectory);
            }
            WebFileShrinker.reportPrintLn("\rtarget directory: " + targetDirectory);
            for (int i = 0; i < vector.size(); ++i) {
                string2 = new String((String)vector.elementAt(i));
                string = "";
                if (WebFileShrinker.getFileExt(string2).equals(".prj")) {
                    string = WebFileShrinker.getFormatedFileName(string2);
                } else {
                    strCurPath = "";
                    WebFileShrinker.processProjectSrcLine(new String(string2));
                }
                if (string.length() != 0) {
                    WebFileShrinker.reportPrintLn("\rproject-file: " + string);
                    int n2 = string.lastIndexOf(pathSeparator);
                    strCurPath = "";
                    if (n2 >= 0) {
                        strCurPath = string.substring(0, n2 + 1);
                    }
                    FileReader fileReader = new FileReader(string);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    while ((string = bufferedReader.readLine()) != null) {
                        WebFileShrinker.processProjectSrcLine(string);
                    }
                    ((Reader)fileReader).close();
                }
                while (nSourceFileNr < nSourceFileNum) {
                    this.minimizeFile(WebFileShrinker.getSourceFile(nSourceFileNr));
                    ++nSourceFileNr;
                }
            }
            WebFileShrinker.reportPrintLn(WebFileShrinker.sLeft("- " + processedNum + " files / " + skippedNum + " skipped - (" + nSrcTotalLineNum + ") ", 47) + WebFileShrinker.sRight(nSrcTotalSize, 7) + " -> " + WebFileShrinker.sRight(nDestTotalSize, 7) + " bytes " + WebFileShrinker.sRight(WebFileShrinker.getRatioStr(nSrcTotalSize, nDestTotalSize), 7));
            if (!boolNoRefReport && nSrcRefNum > 0) {
                for (n = 0; n < nSrcRefNum; ++n) {
                    string = WebFileShrinker.getSrcRef(n);
                    string2 = "???";
                    try {
                        File file = new File(string);
                        if (file.exists() && file.isFile()) {
                            nDestTotalSize += file.length();
                            string2 = "" + file.length();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    WebFileShrinker.reportPrintLn(WebFileShrinker.sLeft("src-reference: \"" + WebFileShrinker.getRelativePath(sourceDirectory, string) + "\"", 62) + WebFileShrinker.sRight(string2, 11) + " bytes");
                }
                WebFileShrinker.reportPrintLn(WebFileShrinker.sLeft("- size + " + nSrcRefNum + " references - ", 62) + WebFileShrinker.sRight(nDestTotalSize, 11) + " bytes");
            }
            if (errorNum > 0 || warningNum > 0) {
                WebFileShrinker.reportPrintLn("note: " + errorNum + " error(s), " + warningNum + " warning(s)");
            }
            if (boolIsLogFile) {
                logFile.close();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    static {
        boolPreventMoreFiles = false;
        nSrcTotalSize = 0L;
        nDestTotalSize = 0L;
        srcRefList = new Vector();
        sourceFiles = new Vector();
        nSrcRefNum = 0;
        nSourceFileNr = 0;
        nSourceFileNum = 0;
        skippedNum = 0;
        processedNum = 0;
        errorNum = 0;
        warningNum = 0;
        inFuncList = new Vector();
        nc = true;
        targetDirectory = "release" + pathSeparator;
        sourceDirectory = "";
        lastSourceLine = "";
        scriptStates = new Vector();
        aspProcessingIf = -1;
        aspProcessingStr = false;
        aspProcessingLastIf = -1;
        aspStates = new Vector();
    }
}

