/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.service.resolver;

import org.eclipse.osgi.service.resolver.Version;

public class VersionRange {
    private Version minVersion;
    private Version maxVersion;

    public VersionRange(Version minVersion, Version maxVersion) {
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public VersionRange(String versionRange) {
        if (versionRange == null || versionRange.length() == 0) {
            return;
        }
        if ((versionRange = versionRange.trim()).charAt(0) == '[' || versionRange.charAt(0) == '(') {
            int comma = versionRange.indexOf(44);
            if (comma < 0) {
                throw new IllegalArgumentException();
            }
            char last = versionRange.charAt(versionRange.length() - 1);
            if (last != ']' && last != ')') {
                throw new IllegalArgumentException();
            }
            this.minVersion = new Version(versionRange.substring(1, comma), versionRange.charAt(0) == '[');
            this.maxVersion = new Version(versionRange.substring(comma + 1, versionRange.length() - 1), last == ']');
        } else {
            this.minVersion = new Version(versionRange);
            this.maxVersion = Version.maxVersion;
        }
    }

    public Version getMinimum() {
        return this.minVersion;
    }

    public Version getMaximum() {
        return this.maxVersion;
    }

    public boolean isIncluded(Version version) {
        int maxCheck;
        Version minRequired = this.getMinimum();
        if (minRequired == null) {
            return true;
        }
        if (version == null) {
            return false;
        }
        Version maxRequired = this.getMaximum() == null ? Version.maxVersion : this.getMaximum();
        int minCheck = minRequired.isInclusive() ? 0 : 1;
        int n = maxCheck = maxRequired.isInclusive() ? 0 : -1;
        return version.compareTo(minRequired) >= minCheck && version.compareTo(maxRequired) <= maxCheck;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange vr = (VersionRange)object;
        if (this.minVersion != null && vr.getMinimum() != null) {
            if (this.minVersion.equals(vr.getMinimum()) && this.minVersion.isInclusive() == vr.getMinimum().isInclusive() && this.maxVersion != null && vr.getMaximum() != null) {
                if (this.maxVersion.equals(vr.getMaximum()) && this.maxVersion.isInclusive() == vr.getMaximum().isInclusive()) {
                    return true;
                }
                return this.maxVersion == vr.getMaximum();
            }
        } else {
            return this.minVersion == vr.getMinimum();
        }
        return false;
    }

    public String toString() {
        if (this.minVersion != null && Version.maxVersion.equals(this.maxVersion)) {
            return this.minVersion.toString();
        }
        StringBuffer result = new StringBuffer();
        if (this.minVersion != null) {
            result.append(this.minVersion.isInclusive() ? (char)'[' : '(');
        }
        result.append(this.minVersion);
        result.append(',');
        result.append(this.maxVersion);
        if (this.maxVersion != null) {
            result.append(this.maxVersion.isInclusive() ? (char)']' : ')');
        }
        return result.toString();
    }
}

