/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.JobListeners;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ObjectMap;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class InternalJob
extends PlatformObject
implements Comparable {
    static final int BLOCKED = 8;
    static final int ABOUT_TO_RUN = 16;
    private static final int M_STATE = 255;
    private static final int M_SYSTEM = 256;
    private static final int M_USER = 512;
    private static final JobManager manager = JobManager.getInstance();
    private static int nextJobNumber = 0;
    static final long T_INFINITE = Long.MAX_VALUE;
    static final long T_NONE = -1L;
    private volatile int flags = 0;
    private final int jobNumber = nextJobNumber++;
    private volatile IJobChangeListener[] listeners = JobListeners.EMPTY_LISTENERS;
    private IProgressMonitor monitor;
    private String name;
    private InternalJob next;
    private InternalJob previous;
    private int priority = 30;
    private ObjectMap properties;
    private IStatus result;
    private ISchedulingRule schedulingRule;
    private long startTime;
    private volatile Thread thread = null;
    static /* synthetic */ Class class$0;

    protected InternalJob(String name) {
        Assert.isNotNull(name);
        this.name = name;
    }

    protected void addJobChangeListener(IJobChangeListener listener) {
        IJobChangeListener[] tempListeners = this.listeners;
        int oldCount = tempListeners.length;
        int i = 0;
        while (i < oldCount) {
            if (tempListeners[i] == listener) {
                return;
            }
            ++i;
        }
        IJobChangeListener[] newListeners = new IJobChangeListener[tempListeners.length + 1];
        System.arraycopy(tempListeners, 0, newListeners, 0, oldCount);
        newListeners[oldCount] = listener;
        this.listeners = newListeners;
    }

    final void addLast(InternalJob entry) {
        if (this.previous == null) {
            this.previous = entry;
            entry.next = this;
            entry.previous = null;
        } else {
            Assert.isTrue(this.previous.next() == this);
            this.previous.addLast(entry);
        }
    }

    protected boolean belongsTo(Object family) {
        return false;
    }

    protected boolean cancel() {
        return manager.cancel(this);
    }

    public final int compareTo(Object otherJob) {
        return (int)(((InternalJob)otherJob).startTime - this.startTime);
    }

    protected void done(IStatus result) {
        manager.endJob(this, result, true);
    }

    final IJobChangeListener[] getListeners() {
        return this.listeners;
    }

    protected String getName() {
        return this.name;
    }

    protected int getPriority() {
        return this.priority;
    }

    final IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    protected Object getProperty(QualifiedName key) {
        ObjectMap temp = this.properties;
        if (temp == null) {
            return null;
        }
        return temp.get(key);
    }

    protected IStatus getResult() {
        return this.result;
    }

    protected ISchedulingRule getRule() {
        return this.schedulingRule;
    }

    final long getStartTime() {
        return this.startTime;
    }

    protected int getState() {
        int state = this.flags & 0xFF;
        switch (state) {
            case 8: {
                return 2;
            }
            case 16: {
                return 4;
            }
        }
        return state;
    }

    protected Thread getThread() {
        return this.thread;
    }

    final int internalGetState() {
        return this.flags & 0xFF;
    }

    final void internalSetPriority(int newPriority) {
        this.priority = newPriority;
    }

    final void internalSetRule(ISchedulingRule rule) {
        this.schedulingRule = rule;
    }

    final void internalSetState(int i) {
        this.flags = this.flags & 0xFFFFFF00 | i;
    }

    protected boolean isBlocking() {
        return manager.isBlocking(this);
    }

    final boolean isConflicting(InternalJob otherJob) {
        ISchedulingRule otherRule = otherJob.getRule();
        if (this.schedulingRule == null || otherRule == null) {
            return false;
        }
        Class<?> clazz = this.schedulingRule.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.runtime.jobs.MultiRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.schedulingRule.isConflicting(otherRule);
        }
        return otherRule.isConflicting(this.schedulingRule);
    }

    protected boolean isSystem() {
        return (this.flags & 0x100) != 0;
    }

    protected boolean isUser() {
        return (this.flags & 0x200) != 0;
    }

    protected void join() throws InterruptedException {
        manager.join(this);
    }

    final InternalJob next() {
        return this.next;
    }

    final InternalJob previous() {
        return this.previous;
    }

    final InternalJob remove() {
        if (this.next != null) {
            this.next.setPrevious(this.previous);
        }
        if (this.previous != null) {
            this.previous.setNext(this.next);
        }
        this.previous = null;
        this.next = null;
        return this;
    }

    protected void removeJobChangeListener(IJobChangeListener listener) {
        IJobChangeListener[] tempListeners = this.listeners;
        int oldCount = tempListeners.length;
        if (oldCount == 0 || oldCount == 1 && tempListeners[0] == listener) {
            this.listeners = JobListeners.EMPTY_LISTENERS;
            return;
        }
        int i = 0;
        while (i < oldCount) {
            if (tempListeners[i] == listener) {
                IJobChangeListener[] newListeners = new IJobChangeListener[oldCount - 1];
                System.arraycopy(tempListeners, 0, newListeners, 0, i);
                System.arraycopy(tempListeners, i + 1, newListeners, i, oldCount - i - 1);
                this.listeners = newListeners;
                return;
            }
            ++i;
        }
    }

    protected abstract IStatus run(IProgressMonitor var1);

    protected void schedule(long delay) {
        manager.schedule(this, delay, false);
    }

    protected void setName(String name) {
        Assert.isNotNull(name);
        this.name = name;
    }

    final void setNext(InternalJob entry) {
        this.next = entry;
    }

    final void setPrevious(InternalJob entry) {
        this.previous = entry;
    }

    protected void setPriority(int newPriority) {
        switch (newPriority) {
            case 10: 
            case 20: 
            case 30: 
            case 40: 
            case 50: {
                manager.setPriority(this, newPriority);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(newPriority));
            }
        }
    }

    protected void setProgressGroup(IProgressMonitor group, int ticks) {
        Assert.isNotNull(group);
        IProgressMonitor result = manager.createMonitor(this, group, ticks);
        if (result != null) {
            this.setProgressMonitor(result);
        }
    }

    final void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    protected void setProperty(QualifiedName key, Object value) {
        if (value == null) {
            if (this.properties == null) {
                return;
            }
            ObjectMap temp = (ObjectMap)this.properties.clone();
            temp.remove(key);
            this.properties = temp.isEmpty() ? null : temp;
        } else {
            ObjectMap temp = this.properties;
            temp = temp == null ? new ObjectMap(5) : (ObjectMap)this.properties.clone();
            temp.put(key, value);
            this.properties = temp;
        }
    }

    final void setResult(IStatus result) {
        this.result = result;
    }

    protected void setRule(ISchedulingRule rule) {
        manager.setRule(this, rule);
    }

    final void setStartTime(long time) {
        this.startTime = time;
    }

    protected void setSystem(boolean value) {
        if (this.getState() != 0) {
            throw new IllegalStateException();
        }
        this.flags = value ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
    }

    protected void setThread(Thread thread) {
        this.thread = thread;
    }

    protected void setUser(boolean value) {
        if (this.getState() != 0) {
            throw new IllegalStateException();
        }
        this.flags = value ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
    }

    protected boolean shouldSchedule() {
        return true;
    }

    protected boolean sleep() {
        return manager.sleep(this);
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.jobNumber + ")";
    }

    protected void wakeUp(long delay) {
        manager.wakeUp(this, delay);
    }
}

