/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.ExtensionsParser;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.MultiStatus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;

    public EclipseBundleListener(ExtensionRegistry registry) {
        this.registry = registry;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 32: {
                this.addBundle(bundle);
                break;
            }
            case 64: {
                this.removeBundle(bundle);
            }
        }
    }

    public void processBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (this.isBundleResolved(bundles[i])) {
                this.addBundle(bundles[i]);
            } else {
                this.removeBundle(bundles[i]);
            }
            ++i;
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle) {
        this.registry.remove(bundle.getSymbolicName(), bundle.getBundleId());
    }

    private void addBundle(Bundle bundle) {
        if (this.registry.getNamespace(bundle.getSymbolicName()) != null) {
            return;
        }
        Namespace bundleModel = this.getBundleModel(bundle);
        if (bundleModel == null) {
            return;
        }
        this.registry.add(bundleModel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Namespace getBundleModel(Bundle bundle) {
        Namespace namespace;
        if (bundle.getBundleId() == 0L) {
            return null;
        }
        if (bundle.getSymbolicName() == null) {
            return null;
        }
        InputStream is = null;
        String manifestType = null;
        boolean isFragment = InternalPlatform.getDefault().isFragment(bundle);
        String manifestName = isFragment ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST;
        try {
            URL url = bundle.getEntry(manifestName);
            if (url != null) {
                is = url.openStream();
                manifestType = isFragment ? "fragment" : "plugin";
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (is == null) {
            return null;
        }
        try {
            try {
                Bundle[] hosts;
                String message = Policy.bind("parse.problems", bundle.getLocation());
                MultiStatus problems = new MultiStatus("org.eclipse.core.runtime", 1, message, null);
                ResourceBundle b = null;
                try {
                    b = ResourceTranslator.getResourceBundle(bundle);
                }
                catch (MissingResourceException missingResourceException) {}
                Namespace bundleModel = new ExtensionsParser(problems).parseManifest(new InputSource(is), manifestType, manifestName, b);
                bundleModel.setUniqueIdentifier(bundle.getSymbolicName());
                bundleModel.setBundle(bundle);
                if (isFragment && (hosts = InternalPlatform.getDefault().getHosts(bundle)) != null && hosts.length > 0) {
                    bundleModel.setHostIdentifier(hosts[0].getSymbolicName());
                }
                if (problems.getSeverity() != 0) {
                    InternalPlatform.getDefault().log(problems);
                }
                namespace = bundleModel;
                Object var11_16 = null;
            }
            catch (SAXException e) {
                e.printStackTrace();
                Namespace namespace2 = null;
                Object var11_17 = null;
                try {
                    is.close();
                    return namespace2;
                }
                catch (IOException iOException) {}
                return namespace2;
            }
            catch (IOException e) {
                e.printStackTrace();
                Namespace namespace3 = null;
                Object var11_18 = null;
                try {}
                catch (IOException iOException) {}
                is.close();
                return namespace3;
            }
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            is.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        is.close();
        return namespace;
    }
}

