/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.SafeFileOutputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class RegistryCacheWriter {
    protected HashMap objectTable = null;
    protected MultiStatus problems = null;
    protected File cacheFile;

    public RegistryCacheWriter(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    private int addToObjectTable(Object object) {
        if (this.objectTable == null) {
            this.objectTable = new HashMap();
        }
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return (Integer)objectResult;
        }
        return -1;
    }

    public void writeConfigurationElement(ConfigurationElement object, DataOutputStream out) {
        try {
            this.writeCachedStringOrNull(object.getName(), out);
            this.writeStringOrNull(object.getValue(), out);
            ConfigurationProperty[] properties = object.getProperties();
            int length = properties == null ? 0 : properties.length;
            out.writeInt(length);
            int i = 0;
            while (i < length) {
                this.writeConfigurationProperty(properties[i], out);
                ++i;
            }
            IConfigurationElement[] elements = object.getChildren();
            length = elements == null ? 0 : elements.length;
            out.writeInt(length);
            int i2 = 0;
            while (i2 < length) {
                this.writeConfigurationElement((ConfigurationElement)elements[i2], out);
                ++i2;
            }
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "ConfigruationElement"), ioe));
        }
    }

    public void writeConfigurationProperty(ConfigurationProperty object, DataOutputStream out) {
        try {
            this.writeCachedStringOrNull(object.getName(), out);
            this.writeStringOrNull(object.getValue(), out);
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "ConfigurationProperty"), ioe));
        }
    }

    public void writeExtension(Extension object, DataOutputStream out) {
        try {
            if (this.writeIndex(object, out)) {
                return;
            }
            this.addToObjectTable(object);
            out.writeByte(1);
            this.writeStringOrNull(object.getSimpleIdentifier(), out);
            this.writeBundleModel((Namespace)object.getParent(), out);
            this.writeStringOrNull(object.getName(), out);
            this.writeCachedStringOrNull(object.getExtensionPointIdentifier(), out);
            this.writeSubElements(object, out);
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "Extension"), ioe));
        }
    }

    private void writeCachedStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            int index = this.getFromObjectTable(string);
            if (index == -1) {
                this.addToObjectTable(string);
                out.writeByte(1);
                out.writeUTF(string);
            } else {
                out.writeByte(2);
                out.writeInt(index);
            }
        }
    }

    public void writeSubElements(Extension object, DataOutputStream out) throws IOException {
        IConfigurationElement[] subElements = object.getConfigurationElements();
        if (subElements == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        out.writeInt(out.size());
        out.writeInt(subElements.length);
        int i = 0;
        while (i < subElements.length) {
            this.writeConfigurationElement((ConfigurationElement)subElements[i], out);
            ++i;
        }
    }

    public void writeExtensionPoint(ExtensionPoint object, DataOutputStream out) {
        try {
            if (this.writeIndex(object, out)) {
                return;
            }
            this.addToObjectTable(object);
            out.writeByte(1);
            this.writeStringOrNull(object.getSimpleIdentifier(), out);
            this.writeStringOrNull(object.getName(), out);
            this.writeStringOrNull(object.getSchema(), out);
            IExtension[] extensions = object.getExtensions();
            int length = extensions == null ? 0 : extensions.length;
            out.writeInt(length);
            int i = 0;
            while (i < length) {
                this.writeExtension((Extension)extensions[i], out);
                ++i;
            }
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "ExtensionPoint"), ioe));
        }
    }

    public void writeHeaderInformation(long registryStamp, DataOutputStream out) {
        try {
            out.writeInt(7);
            out.writeLong(InternalPlatform.getDefault().getStateTimeStamp());
            out.writeLong(registryStamp);
            InternalPlatform info = InternalPlatform.getDefault();
            out.writeUTF(info.getOS());
            out.writeUTF(info.getWS());
            out.writeUTF(info.getNL());
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "HeaderInformation"), ioe));
        }
    }

    public void writeBundleModel(Namespace object, DataOutputStream out) {
        try {
            if (this.writeIndex(object, out)) {
                return;
            }
            this.addToObjectTable(object);
            out.writeByte(1);
            this.writeCachedStringOrNull(object.getUniqueIdentifier(), out);
            out.writeLong(object.getId());
            this.writeRegistry((ExtensionRegistry)object.getParent(), out);
            this.writeCachedStringOrNull(object.getHostIdentifier(), out);
            IExtensionPoint[] extensionPoints = object.getExtensionPoints();
            int length = extensionPoints == null ? 0 : extensionPoints.length;
            out.writeInt(length);
            int i = 0;
            while (i < length) {
                this.writeExtensionPoint((ExtensionPoint)extensionPoints[i], out);
                ++i;
            }
            IExtension[] extensions = object.getExtensions();
            length = extensions == null ? 0 : extensions.length;
            out.writeInt(length);
            int i2 = 0;
            while (i2 < length) {
                this.writeExtension((Extension)extensions[i2], out);
                ++i2;
            }
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "Bundle"), ioe));
        }
    }

    public void writeCache(ExtensionRegistry object, long registryStamp, DataOutputStream out) {
        if (this.problems == null) {
            this.problems = new MultiStatus("org.eclipse.core.runtime", 1, Policy.bind("meta.registryCacheWriteProblems"), null);
        }
        this.writeHeaderInformation(registryStamp, out);
        this.writeRegistry(object, out);
    }

    public void writeRegistry(ExtensionRegistry object, DataOutputStream out) {
        try {
            if (this.writeIndex(object, out)) {
                return;
            }
            this.addToObjectTable(object);
            out.writeByte(1);
            String[] ids = object.basicGetNamespaces();
            out.writeInt(ids.length);
            int i = 0;
            while (i < ids.length) {
                this.writeBundleModel(object.basicGetNamespace(ids[i]), out);
                ++i;
            }
        }
        catch (IOException ioe) {
            this.problems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOExceptionWriting", "ExtensionRegisry"), ioe));
        }
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    private boolean writeIndex(Object object, DataOutputStream out) throws IOException {
        if (object == null) {
            out.writeByte(0);
            return true;
        }
        int index = this.getFromObjectTable(object);
        if (index == -1) {
            return false;
        }
        out.writeByte(2);
        out.writeInt(index);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCache(ExtensionRegistry registry, long registryStamp) {
        registry.enterRead();
        try {
            try {
                DataOutputStream out = this.openCacheFile();
                try {
                    this.writeCache(registry, registryStamp, out);
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    out.close();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                    out.close();
                }
            }
            catch (IOException e) {
                if (InternalPlatform.DEBUG_REGISTRY) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            registry.exitRead();
            throw throwable;
        }
        {
            Object var7_10 = null;
            registry.exitRead();
            return;
        }
    }

    public void saveCache(ExtensionRegistry registry) {
        this.saveCache(registry, 0L);
    }

    private DataOutputStream openCacheFile() throws IOException {
        return new DataOutputStream(new SafeFileOutputStream(this.cacheFile));
    }
}

